/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.maven.plugin;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;

public class ClassesMove {
    public static void change(File file) {
        String target = file.getParent() + File.separator;
        String name = file.getName();
        String desc = name.substring(0, name.lastIndexOf("."));
        File file1 = new File(target + desc);
        if (file1.isDirectory()) {
            ClassesMove.deleteDirectory(file1.getAbsolutePath());
        }
        file1.mkdirs();
        try {
            ClassesMove.unzipJar(file1.getPath(), file.getAbsolutePath());
            ClassesMove.deleteFile(file.getAbsolutePath());
            ClassesMove.jar(file.getAbsolutePath(), file1);
            ClassesMove.deleteDirectory(file1.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void jar(String jarFileName, File f) throws Exception {
        FileOutputStream fileOutputStream = new FileOutputStream(jarFileName);
        JarOutputStream out = new JarOutputStream(fileOutputStream);
        ClassesMove.jar(out, f, "BOOT-INF/classes");
        out.flush();
        out.close();
        fileOutputStream.flush();
        fileOutputStream.close();
    }

    private static void jar(JarOutputStream out, File f, String base) throws Exception {
        if (f.isDirectory()) {
            File[] fl = f.listFiles();
            out.putNextEntry(new JarEntry(base + "/"));
            base = base.length() == 0 ? "" : base + "/";
            for (int i = 0; i < fl.length; ++i) {
                ClassesMove.jar(out, fl[i], base + fl[i].getName());
            }
        } else {
            out.putNextEntry(new ZipEntry(base));
            try (FileInputStream in = new FileInputStream(f);
                 BufferedInputStream bis = new BufferedInputStream(in);){
                int len;
                byte[] buffer = new byte[1024];
                while ((len = bis.read(buffer)) > 0) {
                    out.write(buffer, 0, len);
                }
            }
        }
    }

    public static boolean deleteDirectory(String dir) {
        File dirFile;
        if (!dir.endsWith(File.separator)) {
            dir = dir + File.separator;
        }
        if (!(dirFile = new File(dir)).exists() || !dirFile.isDirectory()) {
            return false;
        }
        boolean flag = true;
        File[] files = dirFile.listFiles();
        for (int i = 0; i < files.length && !(files[i].isFile() ? !(flag = ClassesMove.deleteFile(files[i].getAbsolutePath())) : files[i].isDirectory() && !(flag = ClassesMove.deleteDirectory(files[i].getAbsolutePath()))); ++i) {
        }
        if (!flag) {
            return false;
        }
        return dirFile.delete();
    }

    public static boolean deleteFile(String fileName) {
        File file = new File(fileName);
        if (file.exists() && file.isFile()) {
            return file.delete();
        }
        return false;
    }

    public static void unzipJar(String destinationDir, String jarPath) throws IOException {
        File outputDir = new File(destinationDir);
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        try (JarFile jarFile = new JarFile(jarPath);){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                File outputFile = new File(destinationDir, entry.getName());
                if (!outputFile.getParentFile().exists()) {
                    outputFile.getParentFile().mkdirs();
                }
                InputStream inputStream = jarFile.getInputStream(entry);
                Throwable throwable = null;
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(outputFile);
                    Throwable throwable2 = null;
                    try {
                        int bytesRead;
                        byte[] buffer = new byte[4096];
                        while ((bytesRead = inputStream.read(buffer)) != -1) {
                            fileOutputStream.write(buffer, 0, bytesRead);
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (fileOutputStream == null) continue;
                        if (throwable2 != null) {
                            try {
                                fileOutputStream.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        fileOutputStream.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
        }
    }
}

