/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.ToolchainManager;
import org.noear.solon.maven.plugin.CommandLineBuilder;
import org.noear.solon.maven.plugin.JavaProcessExecutor;
import org.noear.solon.maven.plugin.RunArguments;
import org.noear.solon.maven.plugin.tools.SolonMavenUtil;
import org.noear.solon.maven.plugin.tools.StringUtils;

@Mojo(name="process-aot", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class ProcessAotMojo
extends AbstractMojo {
    private static final String AOT_PROCESSOR_CLASS_NAME = "org.noear.solon.aot.SolonAotProcessor";
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Component
    private ToolchainManager toolchainManager;
    @Component
    private MavenProject project;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true)
    private File classesDirectory;
    @Parameter(property="solon.aot.main-class")
    private String mainClass;
    @Parameter
    private Map<String, String> systemPropertyVariables;
    @Parameter(property="solon.aot.jvmArguments")
    private String jvmArguments;
    @Parameter(property="solon.aot.compilerArguments")
    private String compilerArguments;
    @Parameter
    private String[] arguments;
    @Parameter
    private String[] envs;

    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)"start process aot ...");
        try {
            String applicationClass = SolonMavenUtil.getStartClass(this.classesDirectory, this.mainClass, this.getLog());
            List<String> command = CommandLineBuilder.forMainClass(AOT_PROCESSOR_CLASS_NAME).withSystemProperties(this.systemPropertyVariables).withJvmArguments(new RunArguments(this.jvmArguments).asArray()).withClasspath(this.getClassPath()).withArguments(this.getAotArguments(applicationClass)).build();
            this.getLog().info((CharSequence)("Generating AOT assets using command: " + command));
            JavaProcessExecutor processExecutor = new JavaProcessExecutor(this.session, this.toolchainManager);
            processExecutor.run(this.project.getBasedir(), command, Collections.emptyMap());
        }
        catch (IOException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
        }
    }

    private String[] getAotArguments(String applicationClass) {
        ArrayList<String> aotArguments = new ArrayList<String>();
        aotArguments.add(applicationClass);
        aotArguments.add(this.classesDirectory.getAbsolutePath());
        aotArguments.add(this.project.getGroupId());
        aotArguments.add(this.project.getArtifactId());
        if (this.envs != null && this.envs.length != 0) {
            aotArguments.add("--solon.env=" + String.join((CharSequence)",", this.envs));
        }
        if (this.arguments != null) {
            Arrays.stream(this.arguments).filter(Objects::nonNull).forEach(aotArguments::add);
        }
        return aotArguments.toArray(new String[0]);
    }

    private URL[] getClassPath() {
        ArrayList<URL> urls = new ArrayList<URL>();
        urls.add(this.toURL(this.classesDirectory));
        Set artifacts = this.project.getArtifacts();
        List artifactUrlList = artifacts.stream().filter(artifact -> !StringUtils.equals(artifact.getScope(), "test")).map(artifact -> this.toURL(artifact.getFile())).collect(Collectors.toList());
        urls.addAll(artifactUrlList);
        return urls.toArray(new URL[0]);
    }

    protected URL toURL(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException("Invalid URL for " + file, ex);
        }
    }
}

