/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.loader.jar;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.jar.Manifest;
import org.noear.solon.loader.jar.JarEntry;
import org.noear.solon.loader.jar.JarEntryData;
import org.noear.solon.loader.jar.JarFile;
import org.noear.solon.loader.util.AsciiBytes;

class JarURLConnection
extends java.net.JarURLConnection {
    private static final FileNotFoundException FILE_NOT_FOUND_EXCEPTION = new FileNotFoundException();
    private static final String SEPARATOR = "!/";
    private static final URL EMPTY_JAR_URL;
    private static final JarEntryName EMPTY_JAR_ENTRY_NAME;
    private static ThreadLocal<Boolean> useFastExceptions;
    private final JarFile jarFile;
    private JarEntryData jarEntryData;
    private URL jarFileUrl;
    private JarEntryName jarEntryName;

    protected JarURLConnection(URL url, JarFile jarFile) throws IOException {
        super(EMPTY_JAR_URL);
        int separator;
        this.url = url;
        String spec = url.getFile().substring(jarFile.getUrl().getFile().length());
        while ((separator = spec.indexOf(SEPARATOR)) > 0) {
            jarFile = this.getNestedJarFile(jarFile, spec.substring(0, separator));
            spec = spec.substring(separator + SEPARATOR.length());
        }
        this.jarFile = jarFile;
        this.jarEntryName = this.getJarEntryName(spec);
    }

    private JarFile getNestedJarFile(JarFile jarFile, String name) throws IOException {
        JarEntry jarEntry = jarFile.getJarEntry(name);
        if (jarEntry == null) {
            this.throwFileNotFound(jarEntry, jarFile);
        }
        return jarFile.getNestedJarFile(jarEntry);
    }

    private JarEntryName getJarEntryName(String spec) {
        if (spec.length() == 0) {
            return EMPTY_JAR_ENTRY_NAME;
        }
        return new JarEntryName(spec);
    }

    @Override
    public void connect() throws IOException {
        if (!this.jarEntryName.isEmpty()) {
            this.jarEntryData = this.jarFile.getJarEntryData(this.jarEntryName.asAsciiBytes());
            if (this.jarEntryData == null) {
                this.throwFileNotFound(this.jarEntryName, this.jarFile);
            }
        }
        this.connected = true;
    }

    private void throwFileNotFound(Object entry, JarFile jarFile) throws FileNotFoundException {
        if (Boolean.TRUE.equals(useFastExceptions.get())) {
            throw FILE_NOT_FOUND_EXCEPTION;
        }
        throw new FileNotFoundException("JAR entry " + entry + " not found in " + jarFile.getName());
    }

    @Override
    public Manifest getManifest() throws IOException {
        try {
            Manifest manifest = super.getManifest();
            return manifest;
        }
        finally {
            this.connected = false;
        }
    }

    @Override
    public JarFile getJarFile() throws IOException {
        this.connect();
        return this.jarFile;
    }

    @Override
    public URL getJarFileURL() {
        if (this.jarFileUrl == null) {
            this.jarFileUrl = this.buildJarFileUrl();
        }
        return this.jarFileUrl;
    }

    private URL buildJarFileUrl() {
        try {
            String spec = this.jarFile.getUrl().getFile();
            if (spec.endsWith(SEPARATOR)) {
                spec = spec.substring(0, spec.length() - SEPARATOR.length());
            }
            if (spec.indexOf(SEPARATOR) == -1) {
                return new URL(spec);
            }
            return new URL("jar:" + spec);
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public JarEntry getJarEntry() throws IOException {
        this.connect();
        return this.jarEntryData == null ? null : this.jarEntryData.asJarEntry();
    }

    @Override
    public String getEntryName() {
        return this.jarEntryName.toString();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.connect();
        if (this.jarEntryName.isEmpty()) {
            throw new IOException("no entry name specified");
        }
        return this.jarEntryData.getInputStream();
    }

    @Override
    public int getContentLength() {
        try {
            this.connect();
            if (this.jarEntryData != null) {
                return this.jarEntryData.getSize();
            }
            return this.jarFile.size();
        }
        catch (IOException ex) {
            return -1;
        }
    }

    @Override
    public Object getContent() throws IOException {
        this.connect();
        return this.jarEntryData == null ? this.jarFile : super.getContent();
    }

    @Override
    public String getContentType() {
        return this.jarEntryName.getContentType();
    }

    static void setUseFastExceptions(boolean useFastExceptions) {
        JarURLConnection.useFastExceptions.set(useFastExceptions);
    }

    static {
        try {
            EMPTY_JAR_URL = new URL("jar:", null, 0, "file:!/", new URLStreamHandler(){

                @Override
                protected URLConnection openConnection(URL u) throws IOException {
                    return null;
                }
            });
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException(ex);
        }
        EMPTY_JAR_ENTRY_NAME = new JarEntryName("");
        useFastExceptions = new ThreadLocal();
    }

    private static class JarEntryName {
        private final AsciiBytes name;
        private String contentType;

        JarEntryName(String spec) {
            this.name = this.decode(spec);
        }

        private AsciiBytes decode(String source) {
            int length;
            int n = length = source == null ? 0 : source.length();
            if (length == 0 || source.indexOf(37) < 0) {
                return new AsciiBytes(source);
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream(length);
            for (int i = 0; i < length; ++i) {
                char ch = source.charAt(i);
                if (ch == '%') {
                    if (i + 2 >= length) {
                        throw new IllegalArgumentException("Invalid encoded sequence \"" + source.substring(i) + "\"");
                    }
                    ch = this.decodeEscapeSequence(source, i);
                    i += 2;
                }
                bos.write(ch);
            }
            return new AsciiBytes(bos.toByteArray());
        }

        private char decodeEscapeSequence(String source, int i) {
            int hi = Character.digit(source.charAt(i + 1), 16);
            int lo = Character.digit(source.charAt(i + 2), 16);
            if (hi == -1 || lo == -1) {
                throw new IllegalArgumentException("Invalid encoded sequence \"" + source.substring(i) + "\"");
            }
            return (char)((hi << 4) + lo);
        }

        public String toString() {
            return this.name.toString();
        }

        public AsciiBytes asAsciiBytes() {
            return this.name;
        }

        public boolean isEmpty() {
            return this.name.length() == 0;
        }

        public String getContentType() {
            if (this.contentType == null) {
                this.contentType = this.deduceContentType();
            }
            return this.contentType;
        }

        private String deduceContentType() {
            String type = this.isEmpty() ? "x-java/jar" : null;
            type = type != null ? type : URLConnection.guessContentTypeFromName(this.toString());
            type = type != null ? type : "content/unknown";
            return type;
        }
    }
}

