/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.solon;

import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.util.ReadOnlyStringMap;

@Plugin(name="tags", category="Converter")
@ConverterKeys(value={"tags", "tags"})
public class SolonTagsConverter
extends LogEventPatternConverter {
    private static final SolonTagsConverter INSTANCE = new SolonTagsConverter();

    public static SolonTagsConverter newInstance(String[] options) {
        return INSTANCE;
    }

    private SolonTagsConverter() {
        super("tags", "tags");
    }

    public void format(LogEvent event, StringBuilder toAppendTo) {
        ReadOnlyStringMap eData = event.getContextData();
        if (eData != null) {
            eData.forEach((tag, val) -> {
                if (!"traceId".equals(tag)) {
                    toAppendTo.append("[@").append((String)tag).append(":").append(val).append("]");
                }
            });
        }
    }
}

