/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.luffy.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.noear.luffy.model.AFileModel;
import org.noear.solon.Solon;
import org.noear.solon.core.util.IoUtil;
import org.noear.solon.luffy.impl.JtFunctionLoader;
import org.noear.solon.luffy.impl.JtMapping;
import org.noear.solon.luffy.impl.JtRun;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JtFunctionLoaderFile
implements JtFunctionLoader {
    static final Logger log = LoggerFactory.getLogger(JtFunctionLoaderFile.class);
    private final Map<String, AFileModel> fileCached = new LinkedHashMap<String, AFileModel>();
    private final ReentrantLock SYNC_LOCK = new ReentrantLock();
    private File _baseDir;

    public JtFunctionLoaderFile() {
        this("./luffy/");
    }

    public JtFunctionLoaderFile(String baseDir) {
        this._baseDir = new File(baseDir);
        if (!this._baseDir.exists()) {
            this._baseDir.mkdir();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AFileModel fileGet(String path) throws Exception {
        if (path.contains("../") || path.contains("..\\")) {
            return null;
        }
        File file = this.fileBuildDo(path);
        if (file == null) {
            return null;
        }
        AFileModel fileModel = this.fileCached.get(path);
        if (fileModel == null) {
            this.SYNC_LOCK.lock();
            try {
                fileModel = this.fileCached.get(path);
                if (fileModel == null) {
                    fileModel = new AFileModel();
                    this.fileFillDo(fileModel, file, path);
                    this.fileCached.put(path, fileModel);
                }
            }
            finally {
                this.SYNC_LOCK.unlock();
            }
        }
        if (fileModel.update_fulltime.getTime() != file.lastModified()) {
            this.SYNC_LOCK.lock();
            try {
                if (fileModel.update_fulltime.getTime() != file.lastModified()) {
                    this.fileFillDo(fileModel, file, path);
                }
                if (fileModel.content != null) {
                    JtRun.dele(path);
                }
            }
            finally {
                this.SYNC_LOCK.unlock();
            }
        }
        return fileModel;
    }

    protected void fileFillDo(AFileModel fileModel, File file, String path) throws Exception {
        fileModel.content = this.fileContentGet(file);
        if (fileModel.content != null) {
            String fileName = file.getName();
            if (fileModel.file_id == 0) {
                fileModel.path = path;
                fileModel.tag = "luffy";
                if (fileName.indexOf(46) > 0) {
                    String suffix = fileName.substring(fileName.indexOf(46) + 1);
                    fileModel.edit_mode = JtMapping.getActuator(suffix);
                } else {
                    fileModel.edit_mode = JtMapping.getActuator("");
                }
                fileModel.file_id = Math.abs(path.hashCode());
            }
            fileModel.update_fulltime = new Date(file.lastModified());
        }
    }

    protected File fileBuildDo(String path) {
        if (this._baseDir == null) {
            return null;
        }
        File file = new File(this._baseDir, path);
        if (file.exists()) {
            return file;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String fileContentGet(File file) {
        try (FileInputStream ins = new FileInputStream(file);){
            String string = IoUtil.transferToString((InputStream)ins, (String)Solon.encoding());
            return string;
        }
        catch (IOException e) {
            log.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

