/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.expression.snel;

public enum ComparisonOp {
    lt("<"),
    lte("<="),
    gt(">"),
    gte(">="),
    eq("=="),
    neq("!="),
    lk("LIKE"),
    nlk("NOT LIKE"),
    in("IN"),
    nin("NO IN");

    private final String code;

    private ComparisonOp(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public static ComparisonOp parse(String op) {
        switch (op) {
            case "<": {
                return lt;
            }
            case "<=": {
                return lte;
            }
            case ">": {
                return gt;
            }
            case ">=": {
                return gte;
            }
            case "==": {
                return eq;
            }
            case "!=": {
                return neq;
            }
            case "LIKE": {
                return lk;
            }
            case "NOT LIKE": {
                return nlk;
            }
            case "IN": {
                return in;
            }
            case "NOT IN": {
                return nin;
            }
        }
        throw new IllegalArgumentException("Invalid comparison operator: " + op);
    }
}

