/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.expression.snel;

import java.util.function.Function;
import org.noear.solon.expression.Expression;
import org.noear.solon.expression.exception.EvaluationException;
import org.noear.solon.expression.snel.LogicalOp;

public class LogicalNode
implements Expression<Boolean> {
    private LogicalOp operator;
    private Expression left;
    private Expression right;

    public LogicalOp getOperator() {
        return this.operator;
    }

    public Expression getLeft() {
        return this.left;
    }

    public Expression getRight() {
        return this.right;
    }

    public LogicalNode(LogicalOp operator, Expression left, Expression right) {
        this.operator = operator;
        this.left = left;
        this.right = right;
    }

    @Override
    public Boolean eval(Function context) {
        Boolean leftValue = (Boolean)this.left.eval(context);
        if (leftValue == null) {
            throw new EvaluationException("Logical left value is null");
        }
        Boolean rightValue = null;
        if (this.right != null && (rightValue = (Boolean)this.right.eval(context)) == null) {
            throw new EvaluationException("Logical right value is null");
        }
        if (this.operator == LogicalOp.and) {
            return leftValue != false && rightValue != false;
        }
        if (this.operator == LogicalOp.or) {
            return leftValue != false || rightValue != false;
        }
        return leftValue == false;
    }

    public String toString() {
        return "(" + this.left + " " + this.operator.getCode() + " " + this.right + ")";
    }
}

