/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.expression.snel;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.noear.solon.expression.Expression;
import org.noear.solon.expression.Parser;
import org.noear.solon.expression.exception.CompilationException;
import org.noear.solon.expression.snel.ArithmeticNode;
import org.noear.solon.expression.snel.ArithmeticOp;
import org.noear.solon.expression.snel.ComparisonNode;
import org.noear.solon.expression.snel.ComparisonOp;
import org.noear.solon.expression.snel.ConstantNode;
import org.noear.solon.expression.snel.LogicalNode;
import org.noear.solon.expression.snel.LogicalOp;
import org.noear.solon.expression.snel.MethodNode;
import org.noear.solon.expression.snel.PropertyNode;
import org.noear.solon.expression.snel.TernaryNode;
import org.noear.solon.expression.snel.VariableNode;

public class SnelEvaluateParser
implements Parser {
    private static final SnelEvaluateParser INSTANCE = new SnelEvaluateParser();
    private final Map<String, Expression> exprCached = new ConcurrentHashMap<String, Expression>();

    public static SnelEvaluateParser getInstance() {
        return INSTANCE;
    }

    public Expression parse(String expr, boolean cached) {
        if (cached) {
            return this.exprCached.computeIfAbsent(expr, this::parseDo);
        }
        return this.parseDo(expr);
    }

    protected Expression parseDo(String expr) {
        return this.parseDo(new StringReader(expr));
    }

    protected Expression parseDo(Reader reader) {
        ParserState state = new ParserState(reader);
        Expression result = this.parseTernaryExpression(state);
        if (state.getCurrentChar() != -1) {
            throw new CompilationException("Unexpected trailing character: " + (char)state.getCurrentChar());
        }
        return result;
    }

    private Expression parseTernaryExpression(ParserState state) {
        Expression condition = this.parseLogicalOrExpression(state);
        if (this.eat(state, '?')) {
            Expression trueExpr = this.parseTernaryExpression(state);
            this.require(state, ':', "Expected ':' in ternary expression");
            Expression falseExpr = this.parseTernaryExpression(state);
            return new TernaryNode(condition, trueExpr, falseExpr);
        }
        return condition;
    }

    private Expression parseLogicalOrExpression(ParserState state) {
        Expression left = this.parseLogicalAndExpression(state);
        state.skipWhitespace();
        while (this.eat(state, "OR") || this.eat(state, "||")) {
            left = new LogicalNode(LogicalOp.or, left, this.parseLogicalAndExpression(state));
        }
        return left;
    }

    private Expression parseLogicalAndExpression(ParserState state) {
        Expression left = this.parseLogicalNotExpression(state);
        state.skipWhitespace();
        while (this.eat(state, "AND") || this.eat(state, "&&")) {
            left = new LogicalNode(LogicalOp.and, left, this.parseLogicalNotExpression(state));
        }
        return left;
    }

    private Expression parseLogicalNotExpression(ParserState state) {
        if (this.eat(state, "NOT")) {
            return new LogicalNode(LogicalOp.not, this.parseComparisonExpression(state), null);
        }
        return this.parseComparisonExpression(state);
    }

    private Expression parseComparisonExpression(ParserState state) {
        Expression left = this.parseAdditiveExpression(state);
        state.skipWhitespace();
        if (this.isComparisonOperatorStart(state.getCurrentChar())) {
            String op = this.parseComparisonOperator(state);
            return new ComparisonNode(ComparisonOp.parse(op), left, this.parseAdditiveExpression(state));
        }
        if (this.eat(state, "IN")) {
            return new ComparisonNode(ComparisonOp.in, left, this.parseListExpression(state));
        }
        if (this.eat(state, "LIKE")) {
            return new ComparisonNode(ComparisonOp.lk, left, this.parseAdditiveExpression(state));
        }
        if (this.eat(state, "NOT")) {
            if (this.eat(state, "IN")) {
                return new ComparisonNode(ComparisonOp.nin, left, this.parseListExpression(state));
            }
            if (this.eat(state, "LIKE")) {
                return new ComparisonNode(ComparisonOp.nlk, left, this.parseAdditiveExpression(state));
            }
            throw new CompilationException("Invalid NOT expression");
        }
        return left;
    }

    private Expression parseAdditiveExpression(ParserState state) {
        Expression left = this.parseMultiplicativeExpression(state);
        while (true) {
            if (this.eat(state, '+')) {
                left = new ArithmeticNode(ArithmeticOp.add, left, this.parseMultiplicativeExpression(state));
                continue;
            }
            if (!this.eat(state, '-')) break;
            left = new ArithmeticNode(ArithmeticOp.sub, left, this.parseMultiplicativeExpression(state));
        }
        return left;
    }

    private Expression parseMultiplicativeExpression(ParserState state) {
        Expression left = this.parsePrimaryExpression(state);
        while (true) {
            if (this.eat(state, '*')) {
                left = new ArithmeticNode(ArithmeticOp.mul, left, this.parsePrimaryExpression(state));
                continue;
            }
            if (this.eat(state, '/')) {
                left = new ArithmeticNode(ArithmeticOp.div, left, this.parsePrimaryExpression(state));
                continue;
            }
            if (!this.eat(state, '%')) break;
            left = new ArithmeticNode(ArithmeticOp.mod, left, this.parsePrimaryExpression(state));
        }
        return left;
    }

    private Expression parsePrimaryExpression(ParserState state) {
        state.skipWhitespace();
        if (this.eat(state, '(')) {
            Expression expr = this.parseTernaryExpression(state);
            this.eat(state, ')');
            return expr;
        }
        if (state.isNumber()) {
            return new ConstantNode(this.parseNumber(state));
        }
        if (state.isString()) {
            return new ConstantNode(this.parseString(state));
        }
        if (state.isArray()) {
            return this.parseListExpression(state);
        }
        if (this.checkKeyword(state, "true")) {
            return new ConstantNode(true);
        }
        if (this.checkKeyword(state, "false")) {
            return new ConstantNode(false);
        }
        if (this.checkKeyword(state, "null")) {
            return new ConstantNode(null);
        }
        return this.parseVariableOrMethodCall(state);
    }

    private Expression parseVariableOrMethodCall(ParserState state) {
        Expression expr;
        block4: {
            String identifier = this.parseIdentifier(state);
            expr = new VariableNode(identifier);
            while (true) {
                state.skipWhitespace();
                if (this.eat(state, '.')) {
                    String prop = this.parseIdentifier(state);
                    expr = new PropertyNode(expr, prop);
                    continue;
                }
                if (this.eat(state, '[')) {
                    Expression propExpr = this.parseLogicalOrExpression(state);
                    this.eat(state, ']');
                    expr = new PropertyNode(expr, propExpr);
                    continue;
                }
                if (!this.eat(state, '(')) break block4;
                List<Expression> args = this.parseMethodArguments(state);
                this.eat(state, ')');
                if (expr instanceof PropertyNode) {
                    PropertyNode propertyNode = (PropertyNode)expr;
                    expr = new MethodNode(propertyNode.getTarget(), propertyNode.getPropertyName(), args);
                    continue;
                }
                if (!(expr instanceof VariableNode)) break;
                expr = new MethodNode(expr, identifier, args);
            }
            throw new CompilationException("Invalid method call target: " + expr);
        }
        return expr;
    }

    private List<Expression> parseMethodArguments(ParserState state) {
        ArrayList<Expression> args = new ArrayList<Expression>();
        while (state.getCurrentChar() != 41) {
            args.add(this.parseLogicalOrExpression(state));
            if (!this.eat(state, ',')) continue;
        }
        return args;
    }

    private boolean isComparisonOperatorStart(int c) {
        return c == 62 || c == 60 || c == 61 || c == 33;
    }

    private String parseComparisonOperator(ParserState state) {
        StringBuilder sb = new StringBuilder();
        sb.append((char)state.getCurrentChar());
        state.nextChar();
        if (state.getCurrentChar() == 61) {
            sb.append((char)state.getCurrentChar());
            state.nextChar();
        }
        return sb.toString();
    }

    private Expression parseListExpression(ParserState state) {
        if (this.eat(state, '[')) {
            ArrayList<Object> list = new ArrayList<Object>();
            while (state.getCurrentChar() != 93) {
                list.add(this.parseValue(state));
                if (!this.eat(state, ',')) continue;
            }
            this.eat(state, ']');
            return new ConstantNode(list);
        }
        return this.parseTernaryExpression(state);
    }

    private Object parseValue(ParserState state) {
        state.skipWhitespace();
        if (state.isString()) {
            return this.parseString(state);
        }
        if (state.isNumber()) {
            return this.parseNumber(state);
        }
        if (this.checkKeyword(state, "true")) {
            return true;
        }
        if (this.checkKeyword(state, "false")) {
            return false;
        }
        if (this.checkKeyword(state, "null")) {
            return null;
        }
        return this.parseVariableOrMethodCall(state);
    }

    private String parseString(ParserState state) {
        char quote = (char)state.getCurrentChar();
        state.nextChar();
        StringBuilder sb = new StringBuilder();
        while (state.getCurrentChar() != quote) {
            sb.append((char)state.getCurrentChar());
            state.nextChar();
        }
        state.nextChar();
        return sb.toString();
    }

    private Number parseNumber(ParserState state) {
        StringBuilder sb = new StringBuilder();
        boolean isFloat = false;
        boolean isDouble = false;
        boolean isLong = false;
        while (state.isNumber() || state.getCurrentChar() == 46) {
            if (state.getCurrentChar() == 46) {
                isDouble = true;
            }
            sb.append((char)state.getCurrentChar());
            state.nextChar();
        }
        if (Character.toUpperCase(state.getCurrentChar()) == 76) {
            isLong = true;
            state.nextChar();
        } else if (Character.toUpperCase(state.getCurrentChar()) == 70) {
            isFloat = true;
            isDouble = false;
            state.nextChar();
        } else if (Character.toUpperCase(state.getCurrentChar()) == 68) {
            isDouble = true;
            state.nextChar();
        }
        String numberStr = sb.toString();
        try {
            if (isDouble) {
                return Double.parseDouble(numberStr);
            }
            if (isFloat) {
                return Float.valueOf(Float.parseFloat(numberStr));
            }
            if (isLong) {
                return Long.parseLong(numberStr);
            }
            return Integer.parseInt(numberStr);
        }
        catch (NumberFormatException e) {
            throw new CompilationException("Invalid number format: " + numberStr, e);
        }
    }

    private String parseIdentifier(ParserState state) {
        StringBuilder sb = new StringBuilder();
        while (state.isIdentifier()) {
            sb.append((char)state.getCurrentChar());
            state.nextChar();
        }
        return sb.toString();
    }

    private boolean eat(ParserState state, String expected) {
        state.skipWhitespace();
        for (int i = 0; i < expected.length(); ++i) {
            if (state.getCurrentChar() != expected.charAt(i)) {
                return false;
            }
            state.nextChar();
        }
        return true;
    }

    private boolean eat(ParserState state, char expected) {
        state.skipWhitespace();
        if (state.getCurrentChar() == expected) {
            state.nextChar();
            return true;
        }
        return false;
    }

    private void require(ParserState state, char expected, String errorMessage) {
        if (!this.eat(state, expected)) {
            throw new CompilationException(errorMessage);
        }
    }

    private boolean checkKeyword(ParserState state, String keyword) {
        state.mark();
        for (int i = 0; i < keyword.length(); ++i) {
            if (state.getCurrentChar() != keyword.charAt(i)) {
                state.reset();
                return false;
            }
            state.nextChar();
        }
        if (state.isIdentifier()) {
            state.reset();
            return false;
        }
        return true;
    }

    private static class ParserState {
        private final BufferedReader reader;
        private int ch;
        private int position = 0;
        private int markedCh = 0;
        private int markedPosition = 0;

        public ParserState(Reader reader) {
            this.reader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
            this.nextChar();
        }

        public int getCurrentChar() {
            return this.ch;
        }

        public void nextChar() {
            try {
                this.ch = this.reader.read();
                ++this.position;
            }
            catch (IOException e) {
                throw new CompilationException("Read error at position " + this.position, e);
            }
        }

        public void skipWhitespace() {
            while (Character.isWhitespace(this.ch)) {
                this.nextChar();
            }
        }

        public boolean isString() {
            return this.ch == 39 || this.ch == 34;
        }

        public boolean isNumber() {
            return Character.isDigit(this.ch) || this.ch == 45;
        }

        public boolean isArray() {
            return this.ch == 91;
        }

        public boolean isIdentifier() {
            return Character.isLetterOrDigit(this.ch) || this.ch == 95;
        }

        public void mark() {
            try {
                this.reader.mark(this.position);
                this.markedCh = this.ch;
                this.markedPosition = this.position;
            }
            catch (IOException e) {
                throw new CompilationException(e);
            }
        }

        public void reset() {
            try {
                this.reader.reset();
                this.ch = this.markedCh;
                this.position = this.markedPosition;
            }
            catch (IOException e) {
                throw new CompilationException(e);
            }
        }

        public String toString() {
            return "ParserState{ch='" + (char)this.ch + "', position=" + this.position + '}';
        }
    }
}

