/*
 * Decompiled with CFR 0.152.
 */
package com.layjava.docs.javadoc.solon;

import com.layjava.docs.javadoc.solon.JacksonSerializer;
import com.layjava.docs.javadoc.solon.OpenApi2Builder;
import io.swagger.models.Swagger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.LoadBalance;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.util.PathUtil;
import org.noear.solon.docs.DocDocket;
import org.noear.solon.docs.models.ApiGroupResource;
import org.noear.solon.docs.util.BasicAuthUtil;

public class OpenApi2Utils {
    public static String getApiGroupResourceJson() throws IOException {
        return OpenApi2Utils.getApiGroupResourceJson("/swagger/v2");
    }

    public static String getApiGroupResourceJson(String resourceUri) throws IOException {
        List list = Solon.context().getWrapsOfType(DocDocket.class);
        List resourceList = list.stream().filter(bw -> Utils.isNotEmpty((String)bw.name())).map(bw -> {
            DocDocket docDocket = (DocDocket)bw.raw();
            if (docDocket.isEnable()) {
                String group = bw.name();
                String groupName = docDocket.groupName();
                String url = resourceUri + "?group=" + group;
                if (docDocket.upstream() == null) {
                    return new ApiGroupResource(groupName, "2.0", url, "");
                }
                return new ApiGroupResource(groupName, "2.0", url, docDocket.upstream().getContextPath());
            }
            return null;
        }).filter(r -> r != null).collect(Collectors.toList());
        return JacksonSerializer.getInstance().serialize(resourceList);
    }

    public static String getApiJson(Context ctx, String group) throws IOException {
        DocDocket docket = (DocDocket)Solon.context().getBean(group);
        if (docket == null) {
            return null;
        }
        if (!BasicAuthUtil.basicAuth((Context)ctx, (DocDocket)docket)) {
            BasicAuthUtil.response401((Context)ctx);
            return null;
        }
        if (!docket.globalResponseCodes().containsKey(200)) {
            docket.globalResponseCodes().put(200, "");
        }
        if (docket.upstream() == null) {
            Swagger swagger = new OpenApi2Builder(docket).build();
            if (docket.serializer() == null) {
                return JacksonSerializer.getInstance().serialize(swagger);
            }
            return (String)docket.serializer().serialize((Object)swagger);
        }
        String host = docket.upstream().getService();
        if (!host.contains("://")) {
            host = LoadBalance.get((String)host).getServer();
        }
        String url = PathUtil.mergePath((String)host, (String)docket.upstream().getUri()).substring(1);
        return OpenApi2Utils.httpGet(url, docket);
    }

    public static String httpGet(String urlStr, DocDocket docket) throws IOException {
        Iterator iterator;
        HttpURLConnection connection = (HttpURLConnection)new URL(urlStr).openConnection();
        if (docket.basicAuth().size() > 0 && (iterator = docket.basicAuth().entrySet().iterator()).hasNext()) {
            Map.Entry kv = iterator.next();
            String auth = BasicAuthUtil.base64EncodeToStr((String)((String)kv.getKey()), (String)((String)kv.getValue()));
            connection.setRequestProperty("Authorization", "Basic " + auth);
        }
        connection.setRequestMethod("GET");
        int responseCode = connection.getResponseCode();
        if (responseCode == 200) {
            try (BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                String inputLine;
                StringBuilder response = new StringBuilder();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                String string = response.toString();
                return string;
            }
        }
        throw new SocketException("HTTP GET failed: " + responseCode);
    }
}

