/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.tran;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Stack;
import javax.sql.DataSource;
import org.noear.solon.core.util.RunnableEx;
import org.noear.solon.data.annotation.Transaction;
import org.noear.solon.data.tran.TranEntity;
import org.noear.solon.data.tran.TranExecutor;
import org.noear.solon.data.tran.TranListener;
import org.noear.solon.data.tran.TranManager;
import org.noear.solon.data.tran.TranNode;
import org.noear.solon.data.tran.TranPolicy;
import org.noear.solon.data.tran.impl.DbTran;
import org.noear.solon.data.tran.impl.TranDbImpl;
import org.noear.solon.data.tran.impl.TranDbNewImpl;
import org.noear.solon.data.tran.impl.TranMandatoryImpl;
import org.noear.solon.data.tran.impl.TranNeverImpl;
import org.noear.solon.data.tran.impl.TranNotImpl;
import org.noear.solon.util.ScopeLocal;

public class TranExecutorDefault
implements TranExecutor {
    public static final TranExecutorDefault global = new TranExecutorDefault();
    protected final ScopeLocal<Stack<TranEntity>> LOCAL = ScopeLocal.newInstance(TranExecutorDefault.class);
    protected TranNode tranNot = new TranNotImpl();
    protected TranNode tranNever = new TranNeverImpl();
    protected TranNode tranMandatory = new TranMandatoryImpl();

    protected TranExecutorDefault() {
    }

    @Override
    public boolean inTrans() {
        return TranManager.current() != null;
    }

    @Override
    public boolean inTransAndReadOnly() {
        DbTran tran = TranManager.current();
        return tran != null && tran.getMeta().readOnly();
    }

    @Override
    public Connection getConnection(DataSource ds) throws SQLException {
        DbTran tran = TranManager.current();
        if (tran == null) {
            return ds.getConnection();
        }
        return tran.getConnection(ds);
    }

    @Override
    public void listen(TranListener listener) throws IllegalStateException {
        if (listener == null) {
            return;
        }
        DbTran tran = TranManager.current();
        if (tran == null) {
            throw new IllegalStateException("The current tran is not active");
        }
        tran.listen(listener);
    }

    @Override
    public void execute(Transaction meta, RunnableEx runnable) throws Throwable {
        if (meta == null) {
            runnable.run();
            return;
        }
        switch (meta.policy()) {
            case supports: {
                runnable.run();
                return;
            }
            case not_supported: {
                this.tranNot.apply(runnable);
                return;
            }
            case never: {
                this.tranNever.apply(runnable);
                return;
            }
            case mandatory: {
                this.tranMandatory.apply(runnable);
                return;
            }
        }
        Stack stack = (Stack)this.LOCAL.get();
        if (stack == null) {
            this.forRoot(meta, runnable);
        } else {
            this.forNotRoot(stack, meta, runnable);
        }
    }

    protected void forRoot(Transaction meta, RunnableEx runnable) throws Throwable {
        TranNode tran = this.create(meta);
        this.LOCAL.withOrThrow(new Stack(), () -> this.applyDo((Stack)this.LOCAL.get(), tran, meta, runnable));
    }

    protected void forNotRoot(Stack<TranEntity> stack, Transaction meta, RunnableEx runnable) throws Throwable {
        switch (meta.policy()) {
            case required: {
                runnable.run();
                return;
            }
            case requires_new: {
                TranNode tran = this.create(meta);
                this.applyDo(stack, tran, meta, runnable);
                return;
            }
            case nested: {
                TranNode tran = this.create(meta);
                if (stack != null && !stack.isEmpty()) {
                    stack.peek().tran.add(tran);
                }
                this.applyDo(stack, tran, meta, runnable);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyDo(Stack<TranEntity> stack, TranNode tran, Transaction meta, RunnableEx runnable) throws Throwable {
        if (meta.policy().code <= TranPolicy.nested.code) {
            try {
                stack.push(new TranEntity(tran, meta));
                tran.apply(runnable);
            }
            finally {
                stack.pop();
            }
        } else {
            tran.apply(runnable);
        }
    }

    protected TranNode create(Transaction meta) {
        if (meta.policy() == TranPolicy.not_supported) {
            return this.tranNot;
        }
        if (meta.policy() == TranPolicy.never) {
            return this.tranNever;
        }
        if (meta.policy() == TranPolicy.mandatory) {
            return this.tranMandatory;
        }
        if (meta.policy() == TranPolicy.requires_new || meta.policy() == TranPolicy.nested) {
            return new TranDbNewImpl(meta);
        }
        return new TranDbImpl(meta);
    }
}

