/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.datasource;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.noear.solon.core.BeanBuilder;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.data.annotation.Ds;
import org.noear.solon.data.datasource.DsBuildHandler;
import org.noear.solon.data.datasource.DsUtils;
import org.noear.solon.lang.Preview;

@Preview(value="3.3")
public class DsBuilder<T extends Annotation>
implements BeanBuilder<T> {
    private static final DsBuilder<Ds> _default = new DsBuilder<Ds>(Ds::value);
    protected final List<DsBuildHandler> handlers = new ArrayList<DsBuildHandler>();
    protected final Function<T, String> nameMapper;

    public static DsBuilder<Ds> getDefault() {
        return _default;
    }

    public DsBuilder(Function<T, String> nameMapper) {
        this.nameMapper = nameMapper;
    }

    public void addHandler(DsBuildHandler handler) {
        this.handlers.add(handler);
    }

    public void doBuild(Class<?> clz, BeanWrap bw, T anno) throws Throwable {
        DsUtils.observeDs(bw.context(), this.nameMapper.apply(anno), dsWrap -> this.doBuildHandle(clz, (BeanWrap)dsWrap));
    }

    protected boolean doBuildHandle(Class<?> clz, BeanWrap dsWrap) {
        for (DsBuildHandler handler : this.handlers) {
            if (!handler.doHandle(clz, dsWrap)) continue;
            return true;
        }
        return false;
    }
}

