/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.integration;

import java.util.function.Consumer;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.aspect.Interceptor;
import org.noear.solon.core.event.AppPluginLoadEndEvent;
import org.noear.solon.core.event.EventListener;
import org.noear.solon.data.annotation.Cache;
import org.noear.solon.data.annotation.CachePut;
import org.noear.solon.data.annotation.CacheRemove;
import org.noear.solon.data.annotation.Ds;
import org.noear.solon.data.annotation.Tran;
import org.noear.solon.data.annotation.Transaction;
import org.noear.solon.data.cache.CacheLib;
import org.noear.solon.data.cache.CacheService;
import org.noear.solon.data.cache.CacheServiceWrapConsumer;
import org.noear.solon.data.cache.LocalCacheFactoryImpl;
import org.noear.solon.data.cache.LocalCacheService;
import org.noear.solon.data.cache.interceptor.CacheInterceptor;
import org.noear.solon.data.cache.interceptor.CachePutInterceptor;
import org.noear.solon.data.cache.interceptor.CacheRemoveInterceptor;
import org.noear.solon.data.datasource.DsInjector;
import org.noear.solon.data.datasource.RoutingDataSource;
import org.noear.solon.data.integration.DataSourcesBuilder;
import org.noear.solon.data.tran.TranManager;
import org.noear.solon.data.tran.interceptor.TranInterceptor;
import org.noear.solon.data.tran.interceptor.TransactionInterceptor;

public class DataPlugin
implements Plugin {
    public void start(AppContext context) {
        CacheLib.cacheFactoryAdd("local", new LocalCacheFactoryImpl());
        if (context.app().enableTransaction()) {
            TranManager.routing(RoutingDataSource.class, r -> r.determineCurrentTarget());
            context.beanInterceptorAdd(Tran.class, (Interceptor)TranInterceptor.instance, 120);
            context.beanInterceptorAdd(Transaction.class, (Interceptor)TransactionInterceptor.instance, 120);
        }
        if (context.app().enableCaching()) {
            CacheLib.cacheServiceAddIfAbsent("", LocalCacheService.instance);
            context.subWrapsOfType(CacheService.class, (Consumer)new CacheServiceWrapConsumer());
            context.lifecycle(-94, () -> {
                if (!context.hasWrap(CacheService.class)) {
                    context.wrapAndPut(CacheService.class, (Object)LocalCacheService.instance);
                }
            });
            context.beanInterceptorAdd(CachePut.class, (Interceptor)new CachePutInterceptor(), 110);
            context.beanInterceptorAdd(CacheRemove.class, (Interceptor)new CacheRemoveInterceptor(), 110);
            context.beanInterceptorAdd(Cache.class, (Interceptor)new CacheInterceptor(), 111);
        }
        context.beanInjectorAdd(Ds.class, DsInjector.getDefault());
        context.app().onEvent(AppPluginLoadEndEvent.class, (EventListener)new DataSourcesBuilder());
    }
}

