/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.datasource;

import io.r2dbc.spi.ConnectionFactories;
import io.r2dbc.spi.ConnectionFactory;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.BeanWrap;

public class R2dbcConnectionFactory
implements DataSource {
    private final String r2dbcUrl;

    public R2dbcConnectionFactory(String r2dbcUrl) {
        this.r2dbcUrl = r2dbcUrl;
    }

    public ConnectionFactory build() {
        return ConnectionFactories.get((String)this.r2dbcUrl);
    }

    public void register(AppContext context, String name, boolean typed) {
        BeanWrap dsBw = context.wrap(name, (Object)this.build(), typed);
        context.putWrap(name, dsBw);
        if (typed) {
            context.putWrap(ConnectionFactory.class, dsBw);
        }
        context.beanPublish(dsBw);
        context.aot().registerEntityType(dsBw.rawClz(), null);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return null;
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return null;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return null;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }
}

