/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sql;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.noear.solon.core.util.RankEntity;
import org.noear.solon.data.sql.SqlCommand;
import org.noear.solon.data.sql.bound.RowConverterFactory;
import org.noear.solon.data.sql.impl.DefaultConverter;
import org.noear.solon.data.sql.intercept.SqlCallable;
import org.noear.solon.data.sql.intercept.SqlCommandInterceptor;
import org.noear.solon.data.sql.intercept.SqlCommandInvocation;

public class SqlConfiguration {
    private static List<RankEntity<SqlCommandInterceptor>> interceptorList = new ArrayList<RankEntity<SqlCommandInterceptor>>();
    private static RowConverterFactory converter = new DefaultConverter();

    public static void addInterceptor(SqlCommandInterceptor interceptor, int index) {
        interceptorList.add((RankEntity<SqlCommandInterceptor>)new RankEntity((Object)interceptor, index));
        Collections.sort(interceptorList);
    }

    public static Object doIntercept(SqlCommand command, SqlCallable callable) throws SQLException {
        return new SqlCommandInvocation(command, interceptorList, callable).invoke();
    }

    public static RowConverterFactory getConverter() {
        return converter;
    }

    public static void setConverter(RowConverterFactory converter) {
        if (converter != null) {
            SqlConfiguration.converter = converter;
        }
    }
}

