/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sql.impl;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.noear.solon.Solon;
import org.noear.solon.data.sql.SqlCommand;
import org.noear.solon.data.sql.SqlConfiguration;
import org.noear.solon.data.sql.SqlQuerier;
import org.noear.solon.data.sql.bound.RowConverter;
import org.noear.solon.data.sql.bound.RowIterator;
import org.noear.solon.data.sql.bound.StatementBinder;
import org.noear.solon.data.sql.impl.DefaultBinder;
import org.noear.solon.data.sql.impl.SimpleRowIterator;
import org.noear.solon.data.sql.impl.StatementHolder;
import org.noear.solon.data.tran.TranUtils;

public class SimpleSqlQuerier
implements SqlQuerier {
    private static final DefaultBinder DEFAULT_BINDER = new DefaultBinder();
    private final DataSource dataSource;
    private final String commandText;
    private SqlCommand command;

    public SimpleSqlQuerier(DataSource dataSource, String sql) {
        this.dataSource = dataSource;
        this.commandText = sql;
    }

    @Override
    public SqlQuerier params(Object ... args) {
        this.command = new SqlCommand<Object[]>(this.dataSource, this.commandText, args, DEFAULT_BINDER);
        return this;
    }

    @Override
    public <S> SqlQuerier params(S args, StatementBinder<S> binder) {
        this.command = new SqlCommand<S>(this.dataSource, this.commandText, args, binder);
        return this;
    }

    @Override
    public SqlQuerier params(Collection<Object[]> argsList) {
        this.command = new SqlCommand<Object[]>(this.dataSource, this.commandText, argsList, DEFAULT_BINDER);
        return this;
    }

    @Override
    public <S> SqlQuerier params(Collection<S> argsList, Supplier<StatementBinder<S>> binderSupplier) {
        this.command = new SqlCommand<S>(this.dataSource, this.commandText, argsList, binderSupplier.get());
        return this;
    }

    @Override
    public <T> T queryValue() throws SQLException {
        return (T)this.queryRow((ResultSet rs) -> rs.getObject(1));
    }

    @Override
    public <T> List<T> queryValueList() throws SQLException {
        return this.queryRowList((ResultSet rs) -> rs.getObject(1));
    }

    @Override
    public <T> T queryRow(Class<T> tClass) throws SQLException {
        return this.queryRow(SqlConfiguration.getConverter().create(tClass));
    }

    @Override
    public <T> T queryRow(RowConverter<T> converter) throws SQLException {
        return (T)SqlConfiguration.doIntercept(this.command, () -> this.queryRowDo(converter));
    }

    protected <T> Object queryRowDo(RowConverter<T> converter) throws SQLException {
        try (StatementHolder holder = this.buildStatement(this.command, false, false);){
            holder.rsts = holder.stmt.executeQuery();
            if (holder.rsts.next()) {
                T t = converter.convert(holder.rsts);
                return t;
            }
            Object var4_5 = null;
            return var4_5;
        }
    }

    @Override
    public <T> List<T> queryRowList(Class<T> tClass) throws SQLException {
        return this.queryRowList(SqlConfiguration.getConverter().create(tClass));
    }

    @Override
    public <T> List<T> queryRowList(RowConverter<T> converter) throws SQLException {
        return (List)SqlConfiguration.doIntercept(this.command, () -> this.queryRowListDo(converter));
    }

    protected <T> List<T> queryRowListDo(RowConverter<T> converter) throws SQLException {
        try (StatementHolder holder = this.buildStatement(this.command, false, false);){
            holder.rsts = holder.stmt.executeQuery();
            ArrayList<T> list = new ArrayList<T>();
            while (holder.rsts.next()) {
                list.add(converter.convert(holder.rsts));
            }
            ArrayList<T> arrayList = list.size() > 0 ? list : null;
            return arrayList;
        }
    }

    @Override
    public <T> RowIterator<T> queryRowIterator(int fetchSize, Class<T> tClass) throws SQLException {
        return this.queryRowIterator(fetchSize, SqlConfiguration.getConverter().create(tClass));
    }

    @Override
    public <T> RowIterator<T> queryRowIterator(int fetchSize, RowConverter<T> converter) throws SQLException {
        return (RowIterator)SqlConfiguration.doIntercept(this.command, () -> this.queryRowIteratorDo(fetchSize, converter));
    }

    protected <T> RowIterator<T> queryRowIteratorDo(int fetchSize, RowConverter<T> converter) throws SQLException {
        StatementHolder holder = this.buildStatement(this.command, false, true);
        holder.stmt.setFetchSize(fetchSize);
        holder.rsts = holder.stmt.executeQuery();
        return new SimpleRowIterator<T>(holder, converter);
    }

    @Override
    public int update() throws SQLException {
        return (Integer)SqlConfiguration.doIntercept(this.command, this::updateDo);
    }

    protected int updateDo() throws SQLException {
        try (StatementHolder holder = this.buildStatement(this.command, false, false);){
            int n = holder.stmt.executeUpdate();
            return n;
        }
    }

    @Override
    public <T> T updateReturnKey() throws SQLException {
        return (T)SqlConfiguration.doIntercept(this.command, this::updateReturnKeyDo);
    }

    protected Object updateReturnKeyDo() throws SQLException {
        try (StatementHolder holder = this.buildStatement(this.command, true, false);){
            holder.stmt.executeUpdate();
            holder.rsts = holder.stmt.getGeneratedKeys();
            if (holder.rsts.next()) {
                Object object = holder.rsts.getObject(1);
                return object;
            }
            Object var3_4 = null;
            return var3_4;
        }
    }

    @Override
    public int[] updateBatch() throws SQLException {
        return (int[])SqlConfiguration.doIntercept(this.command, this::updateBatchDo);
    }

    protected int[] updateBatchDo() throws SQLException {
        try (StatementHolder holder = this.buildStatement(this.command, false, false);){
            int[] nArray = holder.stmt.executeBatch();
            return nArray;
        }
    }

    @Override
    public <T> List<T> updateBatchReturnKeys() throws SQLException {
        return (List)SqlConfiguration.doIntercept(this.command, this::updateBatchReturnKeysDo);
    }

    protected <T> List<T> updateBatchReturnKeysDo() throws SQLException {
        try (StatementHolder holder = this.buildStatement(this.command, true, false);){
            holder.stmt.executeBatch();
            holder.rsts = holder.stmt.getGeneratedKeys();
            ArrayList<Object> keyList = new ArrayList<Object>();
            while (holder.rsts.next()) {
                keyList.add(holder.rsts.getObject(1));
            }
            ArrayList<Object> arrayList = keyList;
            return arrayList;
        }
    }

    protected StatementHolder buildStatement(SqlCommand cmd, boolean returnKeys, boolean isStream) throws SQLException {
        StatementHolder holder = new StatementHolder();
        holder.conn = this.getConnection();
        holder.stmt = isStream ? (cmd.getSql().startsWith("{call") ? holder.conn.prepareCall(cmd.getSql(), 1003, 1007) : holder.conn.prepareStatement(cmd.getSql(), 1003, 1007)) : (returnKeys ? holder.conn.prepareStatement(cmd.getSql(), 1) : (cmd.getSql().startsWith("{call") ? holder.conn.prepareCall(cmd.getSql()) : holder.conn.prepareStatement(cmd.getSql())));
        cmd.fill(holder.stmt);
        return holder;
    }

    protected Connection getConnection() throws SQLException {
        if (Solon.app() == null) {
            return this.dataSource.getConnection();
        }
        return TranUtils.getConnectionProxy((DataSource)this.dataSource);
    }
}

