/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sql;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import org.noear.solon.data.sql.bound.StatementBinder;

public class SqlCommand<T> {
    private StatementBinder<T> binder;
    private String sql;
    private T args;
    private Collection<T> argsColl;
    private long startTime;

    public SqlCommand(String sql, T args, StatementBinder<T> binder) {
        this.sql = sql;
        this.args = args;
        this.argsColl = null;
        this.binder = binder;
        this.startTime = System.currentTimeMillis();
    }

    public SqlCommand(String sql, Collection<T> argsColl, StatementBinder<T> binder) {
        this.sql = sql;
        this.args = null;
        this.argsColl = argsColl;
        this.binder = binder;
        this.startTime = System.currentTimeMillis();
    }

    public boolean isBatch() {
        return this.argsColl != null;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public String getSql() {
        return this.sql;
    }

    public void setArgs(T args) {
        this.argsColl = null;
        this.args = args;
    }

    public T getArgs() {
        return this.args;
    }

    public void setArgsColl(Collection<T> argsColl) {
        this.argsColl = argsColl;
        this.args = null;
    }

    public Collection<T> getArgsColl() {
        return this.argsColl;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public StatementBinder<T> getBinder() {
        return this.binder;
    }

    public void fill(PreparedStatement stmt) throws SQLException {
        if (this.argsColl == null) {
            this.binder.setValues(stmt, this.args);
        } else {
            for (T row : this.argsColl) {
                this.binder.setValues(stmt, row);
                stmt.addBatch();
            }
        }
    }

    public String toString() {
        return this.sql;
    }
}

