/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sql.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.sql.DataSource;
import org.noear.solon.Solon;
import org.noear.solon.data.sql.Row;
import org.noear.solon.data.sql.RowIterator;
import org.noear.solon.data.sql.RowList;
import org.noear.solon.data.sql.SqlExecutor;
import org.noear.solon.data.sql.impl.CommandHolder;
import org.noear.solon.data.sql.impl.SimpleRowIterator;
import org.noear.solon.data.sql.impl.SimpleRowList;
import org.noear.solon.data.tran.TranUtils;

public class SimpleSqlExecutor
implements SqlExecutor {
    private final DataSource dataSource;
    private final String sql;
    private final Object[] args;

    public SimpleSqlExecutor(DataSource dataSource, String sql, Object[] args) {
        this.dataSource = dataSource;
        this.sql = sql;
        this.args = args;
    }

    @Override
    public <T> T queryValue() throws SQLException {
        try (CommandHolder holder = this.buildCommand(this.sql, this.args, false, false);){
            holder.rsts = holder.stmt.executeQuery();
            if (holder.rsts.next()) {
                Object object = holder.rsts.getObject(1);
                return (T)object;
            }
            T t = null;
            return t;
        }
    }

    @Override
    public <T> List<T> queryValueList() throws SQLException {
        try (CommandHolder holder = this.buildCommand(this.sql, this.args, false, false);){
            holder.rsts = holder.stmt.executeQuery();
            ArrayList<Object> list = new ArrayList<Object>();
            while (holder.rsts.next()) {
                list.add(holder.rsts.getObject(1));
            }
            ArrayList<Object> arrayList = list.size() > 0 ? list : null;
            return arrayList;
        }
    }

    @Override
    public Row queryRow() throws SQLException {
        try (CommandHolder holder = this.buildCommand(this.sql, this.args, false, false);){
            holder.rsts = holder.stmt.executeQuery();
            if (holder.rsts.next()) {
                Row row = holder.getRow();
                return row;
            }
            Row row = null;
            return row;
        }
    }

    @Override
    public RowList queryRowList() throws SQLException {
        try (CommandHolder holder = this.buildCommand(this.sql, this.args, false, false);){
            holder.rsts = holder.stmt.executeQuery();
            SimpleRowList rowList = new SimpleRowList();
            while (holder.rsts.next()) {
                rowList.add(holder.getRow());
            }
            SimpleRowList simpleRowList = rowList.size() > 0 ? rowList : null;
            return simpleRowList;
        }
    }

    @Override
    public RowIterator queryRowIterator(int fetchSize) throws SQLException {
        CommandHolder holder = this.buildCommand(this.sql, this.args, false, true);
        holder.stmt.setFetchSize(fetchSize);
        holder.rsts = holder.stmt.executeQuery();
        return new SimpleRowIterator(holder);
    }

    @Override
    public int update() throws SQLException {
        try (CommandHolder holder = this.buildCommand(this.sql, this.args, false, false);){
            int n = holder.stmt.executeUpdate();
            return n;
        }
    }

    @Override
    public int[] updateBatch(Collection<Object[]> argsList) throws SQLException {
        try (CommandHolder holder = this.buildCommand(this.sql, argsList, false, false);){
            int[] nArray = holder.stmt.executeBatch();
            return nArray;
        }
    }

    @Override
    public <T> T updateReturnKey() throws SQLException {
        try (CommandHolder holder = this.buildCommand(this.sql, this.args, true, false);){
            holder.stmt.executeUpdate();
            holder.rsts = holder.stmt.getGeneratedKeys();
            if (holder.rsts.next()) {
                Object object = holder.rsts.getObject(1);
                return (T)object;
            }
            T t = null;
            return t;
        }
    }

    protected CommandHolder buildCommand(String sql, Object args, boolean returnKeys, boolean isStream) throws SQLException {
        CommandHolder holder = new CommandHolder();
        holder.conn = this.getConnection();
        holder.stmt = isStream ? (sql.startsWith("{call") ? holder.conn.prepareCall(sql, 1003, 1007) : holder.conn.prepareStatement(sql, 1003, 1007)) : (returnKeys ? holder.conn.prepareStatement(sql, 1) : (sql.startsWith("{call") ? holder.conn.prepareCall(sql) : holder.conn.prepareStatement(sql)));
        if (args instanceof Collection) {
            Collection argsList = (Collection)args;
            for (Object[] row : argsList) {
                for (int i = 0; i < row.length; ++i) {
                    this.setObject(holder.stmt, i + 1, row[i]);
                }
                holder.stmt.addBatch();
            }
        } else {
            Object[] row = (Object[])args;
            for (int i = 0; i < row.length; ++i) {
                this.setObject(holder.stmt, i + 1, row[i]);
            }
        }
        return holder;
    }

    protected Connection getConnection() throws SQLException {
        if (Solon.app() == null) {
            return this.dataSource.getConnection();
        }
        return TranUtils.getConnectionProxy((DataSource)this.dataSource);
    }

    protected void setObject(PreparedStatement stmt, int columnIdx, Object val) throws SQLException {
        if (val == null) {
            stmt.setNull(columnIdx, 0);
        } else if (val instanceof Date) {
            if (val instanceof java.sql.Date) {
                stmt.setDate(columnIdx, (java.sql.Date)val);
            } else if (val instanceof Timestamp) {
                stmt.setTimestamp(columnIdx, (Timestamp)val);
            } else {
                Date v1 = (Date)val;
                stmt.setTimestamp(columnIdx, new Timestamp(v1.getTime()));
            }
        } else {
            stmt.setObject(columnIdx, val);
        }
    }
}

