/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.core.sqlBuilder;

import java.util.HashSet;
import java.util.List;
import org.noear.solon.data.sqlink.base.SqLinkConfig;
import org.noear.solon.data.sqlink.base.expression.AsName;
import org.noear.solon.data.sqlink.base.expression.ISqlExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlJoinExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlSetExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlTableExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlUpdateExpression;
import org.noear.solon.data.sqlink.base.expression.JoinType;
import org.noear.solon.data.sqlink.base.expression.SqlExpressionFactory;
import org.noear.solon.data.sqlink.base.session.SqlValue;
import org.noear.solon.data.sqlink.core.sqlBuilder.ISqlBuilder;
import org.noear.solon.data.sqlink.core.visitor.ExpressionUtil;

public class UpdateSqlBuilder
implements ISqlBuilder {
    private final SqLinkConfig config;
    private final SqlExpressionFactory factory;
    private final ISqlUpdateExpression update;

    public UpdateSqlBuilder(SqLinkConfig config, ISqlUpdateExpression update) {
        this.config = config;
        this.update = update;
        this.factory = config.getSqlExpressionFactory();
    }

    public void addJoin(JoinType joinType, ISqlTableExpression table, ISqlExpression on) {
        ISqlJoinExpression join2;
        String first = ExpressionUtil.getFirst(table.getMainTableClass());
        HashSet<String> stringSet = new HashSet<String>(this.update.getJoins().getJoins().size() + 1);
        stringSet.add(this.update.getFrom().getAsName().getName());
        for (ISqlJoinExpression join2 : this.update.getJoins().getJoins()) {
            stringSet.add(join2.getAsName().getName());
        }
        AsName asName = ExpressionUtil.doGetAsName(first, stringSet);
        join2 = this.factory.join(joinType, table, on, asName);
        this.update.addJoin(join2);
    }

    public void addSet(ISqlSetExpression set) {
        this.update.addSet(set);
    }

    public void addWhere(ISqlExpression where) {
        this.update.addWhere(where);
    }

    public boolean hasWhere() {
        return !this.update.getWhere().isEmpty();
    }

    public boolean hasSet() {
        return !this.update.getSets().isEmpty();
    }

    @Override
    public String getSql() {
        return this.getSqlAndValue(null);
    }

    @Override
    public String getSqlAndValue(List<SqlValue> sqlValues) {
        return this.update.getSqlAndValue(this.config, sqlValues);
    }

    @Override
    public SqLinkConfig getConfig() {
        return this.config;
    }

    public ISqlUpdateExpression getUpdate() {
        return this.update;
    }
}

