/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.base.expression.impl;

import java.util.List;
import org.noear.solon.data.sqlink.base.SqLinkConfig;
import org.noear.solon.data.sqlink.base.expression.ISqlCollectedValueExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlColumnExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlSetExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlSingleValueExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlValueExpression;
import org.noear.solon.data.sqlink.base.metaData.FieldMetaData;
import org.noear.solon.data.sqlink.base.session.SqlValue;
import org.noear.solon.data.sqlink.base.sqlExt.ISqlKeywords;
import org.noear.solon.data.sqlink.base.toBean.handler.ITypeHandler;

public class SqlSetExpression
implements ISqlSetExpression {
    private final ISqlColumnExpression column;
    private final ISqlExpression value;

    SqlSetExpression(ISqlColumnExpression column, ISqlExpression value) {
        this.column = column;
        this.value = value;
    }

    @Override
    public ISqlColumnExpression getColumn() {
        return this.column;
    }

    @Override
    public ISqlExpression getValue() {
        return this.value;
    }

    @Override
    public String getSqlAndValue(SqLinkConfig config, List<SqlValue> values) {
        String set = this.column.getSqlAndValue(config, values) + " = ";
        FieldMetaData fieldMetaData = this.column.getFieldMetaData();
        ITypeHandler<?> typeHandler = fieldMetaData.getTypeHandler();
        if (this.value instanceof ISqlValueExpression) {
            if (this.value instanceof ISqlSingleValueExpression) {
                ISqlSingleValueExpression sqlSingleValueExpression = (ISqlSingleValueExpression)this.value;
                Object value1 = sqlSingleValueExpression.getValue();
                if (value1 instanceof ISqlKeywords) {
                    ISqlKeywords iSqlKeywords = (ISqlKeywords)value1;
                    return set + iSqlKeywords.getKeyword(config);
                }
                if (values != null) {
                    values.add(new SqlValue(value1, typeHandler, fieldMetaData.getOnPut()));
                }
                return set + "?";
            }
            if (values != null) {
                ISqlCollectedValueExpression sqlCollectedValueExpression = (ISqlCollectedValueExpression)this.value;
                values.add(new SqlValue(sqlCollectedValueExpression.getCollection(), typeHandler, fieldMetaData.getOnPut()));
            }
            return set + "?";
        }
        return set + this.value.getSqlAndValue(config, values);
    }
}

