/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.base.expression.impl;

import java.util.ArrayList;
import java.util.List;
import org.noear.solon.data.sqlink.api.crud.read.TreeCte;
import org.noear.solon.data.sqlink.base.SqLinkConfig;
import org.noear.solon.data.sqlink.base.SqLinkDialect;
import org.noear.solon.data.sqlink.base.expression.AsName;
import org.noear.solon.data.sqlink.base.expression.ISqlColumnExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlConstStringExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlQueryableExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlRecursionExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlSelectExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlWhereExpression;
import org.noear.solon.data.sqlink.base.expression.JoinType;
import org.noear.solon.data.sqlink.base.expression.SqlExpressionFactory;
import org.noear.solon.data.sqlink.base.expression.SqlOperator;
import org.noear.solon.data.sqlink.base.metaData.MetaData;
import org.noear.solon.data.sqlink.base.metaData.MetaDataCache;
import org.noear.solon.data.sqlink.base.session.SqlValue;

public class SqlRecursionExpression
implements ISqlRecursionExpression {
    protected final ISqlQueryableExpression queryable;
    protected final String parentId;
    protected final String childId;
    protected final int level;

    public SqlRecursionExpression(ISqlQueryableExpression queryable, String parentId, String childId, int level) {
        this.queryable = queryable;
        this.parentId = parentId;
        this.childId = childId;
        this.level = level;
    }

    @Override
    public ISqlQueryableExpression getQueryable() {
        return this.queryable;
    }

    @Override
    public String recursionKeyword() {
        return "";
    }

    @Override
    public String withTableName() {
        MetaData treeCteMetaData = MetaDataCache.getMetaData(TreeCte.class);
        return treeCteMetaData.getTableName();
    }

    @Override
    public String parentId() {
        return this.parentId;
    }

    @Override
    public String childId() {
        return this.childId;
    }

    @Override
    public int level() {
        return this.level;
    }

    @Override
    public String getSqlAndValue(SqLinkConfig config, List<SqlValue> values) {
        SqlExpressionFactory factory = config.getSqlExpressionFactory();
        SqLinkDialect dialect = config.getDisambiguation();
        ISqlQueryableExpression queryCopy = this.queryable.copy(config);
        ISqlSelectExpression selectCopy = queryCopy.getSelect().copy(config);
        Class<?> mainTableClass = queryCopy.getMainTableClass();
        AsName AsWct1 = new AsName("wct1");
        AsName AsWct2 = new AsName("wct2");
        for (ISqlExpression column : selectCopy.getColumns()) {
            if (!(column instanceof ISqlColumnExpression)) continue;
            ISqlColumnExpression iSqlColumnExpression = (ISqlColumnExpression)column;
            iSqlColumnExpression.setTableAsName(AsWct2);
        }
        ISqlQueryableExpression wct = factory.queryable(selectCopy, factory.from(factory.table(TreeCte.class), AsWct1));
        wct.addJoin(factory.join(JoinType.INNER, factory.table(mainTableClass), factory.binary(SqlOperator.EQ, factory.constString(dialect.disambiguation("wct2") + "." + this.parentId), factory.constString(dialect.disambiguation("wct1") + "." + this.childId)), AsWct2));
        this.tryLevel(config, queryCopy.getSelect(), wct.getSelect(), wct.getWhere());
        ArrayList<String> templates = new ArrayList<String>();
        String s = this.recursionKeyword();
        if (!s.isEmpty()) {
            templates.add(s);
        }
        templates.add(dialect.disambiguationTableName(this.withTableName()));
        templates.add("AS");
        templates.add("(" + queryCopy.getSqlAndValue(config, values));
        templates.add("UNION ALL");
        templates.add(wct.getSqlAndValue(config, values) + ")");
        return String.join((CharSequence)" ", templates);
    }

    protected void tryLevel(SqLinkConfig config, ISqlSelectExpression s1, ISqlSelectExpression s2, ISqlWhereExpression where) {
        if (this.level > 0) {
            SqlExpressionFactory factory = config.getSqlExpressionFactory();
            SqLinkDialect dialect = config.getDisambiguation();
            s1.addColumn(factory.as(factory.constString("0"), "cte_level"));
            ISqlConstStringExpression wct1_cte_level = factory.constString(dialect.disambiguation("wct1") + "." + dialect.disambiguation("cte_level"));
            s2.addColumn(factory.as(factory.binary(SqlOperator.PLUS, wct1_cte_level, factory.constString("1")), "cte_level"));
            where.addCondition(factory.binary(SqlOperator.LT, wct1_cte_level, factory.constString(String.valueOf(this.level))));
        }
    }
}

