/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.core.sqlBuilder;

import java.util.ArrayList;
import java.util.List;
import org.noear.solon.data.sqlink.base.SqLinkConfig;
import org.noear.solon.data.sqlink.base.expression.ISqlLimitExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlOrderByExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlOrderExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlQueryableExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlUnionExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlUnionsExpression;
import org.noear.solon.data.sqlink.base.metaData.FieldMetaData;
import org.noear.solon.data.sqlink.base.session.SqlValue;
import org.noear.solon.data.sqlink.core.sqlBuilder.ISqlBuilder;

public class UnionBuilder
implements ISqlBuilder {
    private final SqLinkConfig config;
    private final ISqlQueryableExpression queryable;
    private final ISqlUnionsExpression unions;
    private final ISqlOrderByExpression orderBy;
    private final ISqlLimitExpression limit;

    public UnionBuilder(SqLinkConfig config, ISqlQueryableExpression queryable, ISqlUnionsExpression unions, ISqlOrderByExpression orderBy, ISqlLimitExpression limit) {
        this.config = config;
        this.queryable = queryable;
        this.unions = unions;
        this.orderBy = orderBy;
        this.limit = limit;
    }

    public void addUnion(ISqlUnionExpression unionExpression) {
        this.unions.addUnion(unionExpression);
    }

    public void addOrder(ISqlOrderExpression orderExpression) {
        this.orderBy.addOrder(orderExpression);
    }

    public void addLimit(long offset, long rows) {
        this.limit.setOffset(offset);
        this.limit.setRows(rows);
    }

    public boolean isSingle() {
        return this.queryable.getSelect().isSingle();
    }

    public List<FieldMetaData> getMappingData() {
        return this.queryable.getMappingData();
    }

    public <T> Class<T> getTargetClass() {
        return this.queryable.getMainTableClass();
    }

    @Override
    public SqLinkConfig getConfig() {
        return this.config;
    }

    @Override
    public String getSql() {
        String limitSql;
        ArrayList<String> strings = new ArrayList<String>(4);
        strings.add("(" + this.queryable.getSql(this.config) + ")");
        strings.add(this.unions.getSql(this.config));
        String orderBySql = this.orderBy.getSql(this.config);
        if (!orderBySql.isEmpty()) {
            strings.add(orderBySql);
        }
        if (!(limitSql = this.limit.getSql(this.config)).isEmpty()) {
            strings.add(limitSql);
        }
        return String.join((CharSequence)" ", strings);
    }

    @Override
    public String getSqlAndValue(List<SqlValue> values) {
        String limitSql;
        ArrayList<String> strings = new ArrayList<String>(4);
        strings.add("(" + this.queryable.getSqlAndValue(this.config, values) + ")");
        strings.add(this.unions.getSqlAndValue(this.config, values));
        String orderBySql = this.orderBy.getSqlAndValue(this.config, values);
        if (!orderBySql.isEmpty()) {
            strings.add(orderBySql);
        }
        if (!(limitSql = this.limit.getSqlAndValue(this.config, values)).isEmpty()) {
            strings.add(limitSql);
        }
        return String.join((CharSequence)" ", strings);
    }
}

