/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.core.visitor;

import io.github.kiryu1223.expressionTree.expressions.AssignExpression;
import io.github.kiryu1223.expressionTree.expressions.BinaryExpression;
import io.github.kiryu1223.expressionTree.expressions.BlockExpression;
import io.github.kiryu1223.expressionTree.expressions.ConditionalExpression;
import io.github.kiryu1223.expressionTree.expressions.ConstantExpression;
import io.github.kiryu1223.expressionTree.expressions.DeepFindVisitor;
import io.github.kiryu1223.expressionTree.expressions.Expression;
import io.github.kiryu1223.expressionTree.expressions.FieldSelectExpression;
import io.github.kiryu1223.expressionTree.expressions.Kind;
import io.github.kiryu1223.expressionTree.expressions.LambdaExpression;
import io.github.kiryu1223.expressionTree.expressions.MethodCallExpression;
import io.github.kiryu1223.expressionTree.expressions.NewExpression;
import io.github.kiryu1223.expressionTree.expressions.OperatorType;
import io.github.kiryu1223.expressionTree.expressions.ParameterExpression;
import io.github.kiryu1223.expressionTree.expressions.ParensExpression;
import io.github.kiryu1223.expressionTree.expressions.ReferenceExpression;
import io.github.kiryu1223.expressionTree.expressions.ResultThrowVisitor;
import io.github.kiryu1223.expressionTree.expressions.StaticClassExpression;
import io.github.kiryu1223.expressionTree.expressions.UnaryExpression;
import io.github.kiryu1223.expressionTree.expressions.VariableExpression;
import io.github.kiryu1223.expressionTree.expressions.Visitor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.noear.solon.data.sqlink.api.Result;
import org.noear.solon.data.sqlink.api.crud.read.EndQuery;
import org.noear.solon.data.sqlink.api.crud.read.LQuery;
import org.noear.solon.data.sqlink.api.crud.read.group.Grouper;
import org.noear.solon.data.sqlink.api.crud.read.group.IAggregation;
import org.noear.solon.data.sqlink.base.DbType;
import org.noear.solon.data.sqlink.base.SqLinkConfig;
import org.noear.solon.data.sqlink.base.expression.ISqlColumnExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlConditionsExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlGroupByExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlQueryableExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlRealTableExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlSelectExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlSetExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlSetsExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlSingleValueExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlValueExpression;
import org.noear.solon.data.sqlink.base.expression.SqlExpressionFactory;
import org.noear.solon.data.sqlink.base.expression.SqlOperator;
import org.noear.solon.data.sqlink.base.metaData.FieldMetaData;
import org.noear.solon.data.sqlink.base.metaData.MetaData;
import org.noear.solon.data.sqlink.base.metaData.MetaDataCache;
import org.noear.solon.data.sqlink.base.metaData.NavigateData;
import org.noear.solon.data.sqlink.base.sqlExt.BaseSqlExtension;
import org.noear.solon.data.sqlink.base.sqlExt.SqlExtensionExpression;
import org.noear.solon.data.sqlink.base.sqlExt.SqlOperatorMethod;
import org.noear.solon.data.sqlink.core.SubQuery;
import org.noear.solon.data.sqlink.core.exception.SqLinkException;
import org.noear.solon.data.sqlink.core.exception.SqLinkIllegalExpressionException;
import org.noear.solon.data.sqlink.core.exception.SqlFuncExtNotFoundException;
import org.noear.solon.data.sqlink.core.visitor.ExpressionUtil;
import org.noear.solon.data.sqlink.core.visitor.ParamMatcher;
import org.noear.solon.data.sqlink.core.visitor.methods.AggregateMethods;
import org.noear.solon.data.sqlink.core.visitor.methods.BigNumberMethods;
import org.noear.solon.data.sqlink.core.visitor.methods.LogicExpression;
import org.noear.solon.data.sqlink.core.visitor.methods.MathMethods;
import org.noear.solon.data.sqlink.core.visitor.methods.StringMethods;
import org.noear.solon.data.sqlink.core.visitor.methods.TemporalMethods;

public class SqlVisitor
extends ResultThrowVisitor<ISqlExpression> {
    protected Map<ParameterExpression, String> asNameMap = new HashMap<ParameterExpression, String>();
    protected Set<String> asNameSet = new HashSet<String>();
    protected final SqLinkConfig config;
    protected final SqlExpressionFactory factory;
    protected final ISqlQueryableExpression sqlQueryableExpression;

    public SqlVisitor(SqLinkConfig config, ISqlQueryableExpression sqlQueryableExpression) {
        this.config = config;
        this.factory = config.getSqlExpressionFactory();
        this.sqlQueryableExpression = sqlQueryableExpression;
    }

    public SqlVisitor(SqLinkConfig config) {
        this(config, null);
    }

    public ISqlExpression visit(LambdaExpression<?> lambda) {
        String as;
        List parameters = lambda.getParameters();
        for (ParameterExpression parameter : parameters) {
            MetaData metaData = MetaDataCache.getMetaData(parameter.getType());
            as = this.doGetAsName(metaData.getTableName().substring(0, 1).toLowerCase());
            this.asNameMap.put(parameter, as);
        }
        ISqlExpression visit = (ISqlExpression)this.visit(lambda.getBody());
        for (ParameterExpression parameter : parameters) {
            as = this.asNameMap.remove(parameter);
            this.asNameSet.remove(as);
        }
        return visit;
    }

    protected String doGetAsName(String as) {
        return this.doGetAsName(as, 0);
    }

    protected String doGetAsName(String as, int offset) {
        String next;
        String string = next = offset == 0 ? as : as + offset;
        if (this.asNameSet.contains(next)) {
            return this.doGetAsName(as, offset + 1);
        }
        this.asNameSet.add(next);
        return next;
    }

    public ISqlExpression visit(AssignExpression assignExpression) {
        ISqlExpression left = (ISqlExpression)this.visit(assignExpression.getLeft());
        if (left instanceof ISqlColumnExpression) {
            ISqlColumnExpression sqlColumnExpression = (ISqlColumnExpression)left;
            ISqlExpression right = (ISqlExpression)this.visit(assignExpression.getRight());
            return this.factory.set(sqlColumnExpression, right);
        }
        throw new SqLinkException("\u8868\u8fbe\u5f0f\u4e2d\u4e0d\u80fd\u51fa\u73b0\u975elambda\u5165\u53c2\u4e3a\u8d4b\u503c\u5bf9\u8c61\u7684\u8bed\u53e5");
    }

    public ISqlExpression visit(FieldSelectExpression fieldSelect) {
        if (ExpressionUtil.isProperty(this.asNameMap, fieldSelect)) {
            ParameterExpression parameter = (ParameterExpression)fieldSelect.getExpr();
            Field field = fieldSelect.getField();
            MetaData metaData = MetaDataCache.getMetaData(field.getDeclaringClass());
            return this.factory.column(metaData.getFieldMetaDataByFieldName(field.getName()), this.asNameMap.get(parameter));
        }
        if (ExpressionUtil.isGroupKey(this.asNameMap, fieldSelect.getExpr())) {
            LinkedHashMap<String, ISqlExpression> columns = this.sqlQueryableExpression.getGroupBy().getColumns();
            return (ISqlExpression)columns.get(fieldSelect.getField().getName());
        }
        return this.checkAndReturnValue(fieldSelect);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ISqlExpression visit(MethodCallExpression methodCall) {
        if (ExpressionUtil.isEquals(methodCall)) {
            return this.factory.binary(SqlOperator.EQ, (ISqlExpression)this.visit(methodCall.getExpr()), (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0)));
        }
        if (IAggregation.class.isAssignableFrom(methodCall.getMethod().getDeclaringClass())) {
            String name = methodCall.getMethod().getName();
            List args = methodCall.getArgs();
            switch (name) {
                case "count": {
                    return AggregateMethods.count(this.config, args.isEmpty() ? null : (ISqlExpression)this.visit((Expression)args.get(0)));
                }
                case "sum": {
                    return AggregateMethods.sum(this.config, (ISqlExpression)this.visit((Expression)args.get(0)));
                }
                case "avg": {
                    return AggregateMethods.avg(this.config, (ISqlExpression)this.visit((Expression)args.get(0)));
                }
                case "max": {
                    return AggregateMethods.max(this.config, (ISqlExpression)this.visit((Expression)args.get(0)));
                }
                case "min": {
                    return AggregateMethods.min(this.config, (ISqlExpression)this.visit((Expression)args.get(0)));
                }
                case "groupConcat": {
                    ArrayList<ISqlExpression> visit = new ArrayList<ISqlExpression>();
                    for (Expression arg : args) {
                        visit.add((ISqlExpression)this.visit(arg));
                    }
                    return AggregateMethods.groupConcat(this.config, visit);
                }
            }
            throw new SqLinkException("\u4e0d\u652f\u6301\u7684\u805a\u5408\u51fd\u6570:" + name);
        }
        if (ExpressionUtil.isSqlExtensionExpressionMethod(methodCall.getMethod())) {
            Method sqlFunction = methodCall.getMethod();
            SqlExtensionExpression sqlFuncExt = this.getSqlFuncExt((SqlExtensionExpression[])sqlFunction.getAnnotationsByType(SqlExtensionExpression.class));
            List args = methodCall.getArgs();
            ArrayList<ISqlExpression> expressions = new ArrayList<ISqlExpression>(args.size());
            if (sqlFuncExt.extension() != BaseSqlExtension.class) {
                for (Expression arg : args) {
                    expressions.add((ISqlExpression)this.visit(arg));
                }
                BaseSqlExtension sqlExtension = BaseSqlExtension.getCache(sqlFuncExt.extension());
                return sqlExtension.parse(this.config, sqlFunction, expressions);
            }
            ArrayList<String> strings = new ArrayList<String>();
            List methodParameters = Arrays.stream(methodCall.getMethod().getParameters()).collect(Collectors.toList());
            ParamMatcher match = this.match(sqlFuncExt.template());
            List<String> functions = match.remainder;
            List<String> params = match.bracesContent;
            for (int i = 0; i < functions.size(); ++i) {
                int index;
                strings.add(functions.get(i));
                if (i >= params.size()) continue;
                String param = params.get(i);
                Parameter targetParam = methodParameters.stream().filter(f -> f.getName().equals(param)).findFirst().orElseThrow(() -> new SqLinkException("\u65e0\u6cd5\u5728" + sqlFuncExt.template() + "\u4e2d\u627e\u5230" + param));
                if (targetParam.isVarArgs()) {
                    for (index = methodParameters.indexOf(targetParam); index < args.size(); ++index) {
                        expressions.add((ISqlExpression)this.visit((Expression)args.get(index)));
                        if (index >= args.size() - 1) continue;
                        strings.add(sqlFuncExt.separator());
                    }
                    continue;
                }
                expressions.add((ISqlExpression)this.visit((Expression)args.get(index)));
            }
            return this.factory.template(strings, expressions);
        }
        if (ExpressionUtil.isSqlOperatorMethod(methodCall.getMethod())) {
            Method method = methodCall.getMethod();
            List args = methodCall.getArgs();
            SqlOperatorMethod operatorMethod = method.getAnnotation(SqlOperatorMethod.class);
            SqlOperator operator = operatorMethod.value();
            if (operator == SqlOperator.BETWEEN) {
                ISqlExpression thiz = (ISqlExpression)this.visit((Expression)args.get(0));
                ISqlExpression min = (ISqlExpression)this.visit((Expression)args.get(1));
                ISqlExpression max = (ISqlExpression)this.visit((Expression)args.get(2));
                return this.factory.binary(SqlOperator.BETWEEN, thiz, this.factory.binary(SqlOperator.AND, min, max));
            }
            if (operator.isLeft() || operator == SqlOperator.POSTINC || operator == SqlOperator.POSTDEC) {
                ISqlExpression visit = (ISqlExpression)this.visit((Expression)args.get(0));
                if (!(visit instanceof ISqlQueryableExpression)) return this.factory.unary(operator, visit);
                visit = this.factory.unary(operator, visit);
                return this.factory.unary(operator, visit);
            }
            ISqlExpression left = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
            ISqlExpression right = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(1));
            if (left instanceof ISqlQueryableExpression) {
                left = this.factory.parens(left);
            }
            if (!(right instanceof ISqlQueryableExpression)) return this.factory.binary(operator, left, right);
            right = this.factory.parens(right);
            return this.factory.binary(operator, left, right);
        }
        if (SubQuery.class.isAssignableFrom(methodCall.getMethod().getDeclaringClass())) {
            Method method = methodCall.getMethod();
            if (!method.getName().equals("subQuery")) return this.checkAndReturnValue(methodCall);
            Expression expression = (Expression)methodCall.getArgs().get(0);
            ISqlExpression visit = (ISqlExpression)this.visit(expression);
            if (visit instanceof ISqlColumnExpression) {
                ISqlColumnExpression columnExpression = (ISqlColumnExpression)visit;
                return this.columnToQuery(columnExpression);
            }
            if (!(visit instanceof ISqlQueryableExpression)) throw new SqLinkException("\u4e0d\u652f\u6301\u7684\u8868\u8fbe\u5f0f:" + methodCall);
            ISqlQueryableExpression queryableExpression = (ISqlQueryableExpression)visit;
            return this.queryToQuery(queryableExpression, method);
        }
        if (LQuery.class.isAssignableFrom(methodCall.getMethod().getDeclaringClass()) || EndQuery.class.isAssignableFrom(methodCall.getMethod().getDeclaringClass())) {
            Method method = methodCall.getMethod();
            if (method.getName().equals("count")) {
                ISqlExpression visit = (ISqlExpression)this.visit(methodCall.getExpr());
                if (!(visit instanceof ISqlQueryableExpression)) {
                    throw new SqLinkException("\u4e0d\u652f\u6301\u7684\u8868\u8fbe\u5f0f:" + methodCall);
                }
                ISqlQueryableExpression queryable = (ISqlQueryableExpression)visit;
                ISqlExpression column = null;
                if (!methodCall.getArgs().isEmpty()) {
                    column = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                }
                queryable.setSelect(this.factory.select(Collections.singletonList(AggregateMethods.count(this.config, column)), Long.TYPE));
                return queryable;
            }
            if (method.getName().equals("sum")) {
                ISqlExpression visit = (ISqlExpression)this.visit(methodCall.getExpr());
                if (!(visit instanceof ISqlQueryableExpression)) {
                    throw new SqLinkException("\u4e0d\u652f\u6301\u7684\u8868\u8fbe\u5f0f:" + methodCall);
                }
                ISqlQueryableExpression queryable = (ISqlQueryableExpression)visit;
                ISqlExpression column = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                queryable.setSelect(this.factory.select(Collections.singletonList(AggregateMethods.sum(this.config, column)), BigDecimal.class));
                return queryable;
            }
            if (method.getName().equals("avg")) {
                ISqlExpression visit = (ISqlExpression)this.visit(methodCall.getExpr());
                if (!(visit instanceof ISqlQueryableExpression)) {
                    throw new SqLinkException("\u4e0d\u652f\u6301\u7684\u8868\u8fbe\u5f0f:" + methodCall);
                }
                ISqlQueryableExpression queryable = (ISqlQueryableExpression)visit;
                ISqlExpression column = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                queryable.setSelect(this.factory.select(Collections.singletonList(AggregateMethods.avg(this.config, column)), BigDecimal.class));
                return queryable;
            }
            if (method.getName().equals("min")) {
                ISqlExpression visit = (ISqlExpression)this.visit(methodCall.getExpr());
                if (!(visit instanceof ISqlQueryableExpression)) {
                    throw new SqLinkException("\u4e0d\u652f\u6301\u7684\u8868\u8fbe\u5f0f:" + methodCall);
                }
                ISqlQueryableExpression queryable = (ISqlQueryableExpression)visit;
                ISqlExpression column = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                queryable.setSelect(this.factory.select(Collections.singletonList(AggregateMethods.min(this.config, column)), BigDecimal.class));
                return queryable;
            }
            if (method.getName().equals("max")) {
                ISqlExpression visit = (ISqlExpression)this.visit(methodCall.getExpr());
                if (!(visit instanceof ISqlQueryableExpression)) {
                    throw new SqLinkException("\u4e0d\u652f\u6301\u7684\u8868\u8fbe\u5f0f:" + methodCall);
                }
                ISqlQueryableExpression queryable = (ISqlQueryableExpression)visit;
                ISqlExpression column = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                queryable.setSelect(this.factory.select(Collections.singletonList(AggregateMethods.max(this.config, column)), BigDecimal.class));
                return queryable;
            }
            if (method.getName().equals("any")) {
                ISqlExpression visit = (ISqlExpression)this.visit(methodCall.getExpr());
                if (!(visit instanceof ISqlQueryableExpression)) {
                    throw new SqLinkException("\u4e0d\u652f\u6301\u7684\u8868\u8fbe\u5f0f:" + methodCall);
                }
                ISqlQueryableExpression queryable = (ISqlQueryableExpression)visit;
                List args = methodCall.getArgs();
                if (!args.isEmpty()) {
                    Expression expression = (Expression)args.get(0);
                    ISqlExpression cond = (ISqlExpression)this.visit(expression);
                    queryable.addWhere(cond);
                }
                queryable.setSelect(this.factory.select(Collections.singletonList(this.factory.constString("1")), Integer.TYPE));
                return this.factory.unary(SqlOperator.EXISTS, queryable);
            }
            if (method.getName().equals("where")) {
                ISqlExpression visit = (ISqlExpression)this.visit(methodCall.getExpr());
                if (!(visit instanceof ISqlQueryableExpression)) {
                    throw new SqLinkException("\u4e0d\u652f\u6301\u7684\u8868\u8fbe\u5f0f:" + methodCall);
                }
                ISqlQueryableExpression queryable = (ISqlQueryableExpression)visit;
                ISqlExpression cond = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                queryable.addWhere(cond);
                return queryable;
            }
            if (method.getName().equals("select")) {
                throw new SqLinkException("\u8fc7\u4e8e\u590d\u6742\u7684\u8868\u8fbe\u5f0f:" + methodCall);
            }
            if (method.getName().equals("endSelect")) {
                ISqlExpression visit = (ISqlExpression)this.visit(methodCall.getExpr());
                if (!(visit instanceof ISqlQueryableExpression)) {
                    throw new SqLinkException("\u4e0d\u652f\u6301\u7684\u8868\u8fbe\u5f0f:" + methodCall);
                }
                ISqlQueryableExpression queryable = (ISqlQueryableExpression)visit;
                ISqlExpression select = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                queryable.setSelect(this.factory.select(Collections.singletonList(select), queryable.getMainTableClass()));
                MetaData mainMetaDate = MetaDataCache.getMetaData(queryable.getMainTableClass());
                String as = this.doGetAsName(mainMetaDate.getTableName().substring(0, 1).toLowerCase());
                this.asNameSet.remove(as);
                return this.factory.queryable(queryable.getSelect(), this.factory.from(queryable, as));
            }
            if (method.getName().equals("distinct")) {
                ISqlExpression visit = (ISqlExpression)this.visit(methodCall.getExpr());
                if (!(visit instanceof ISqlQueryableExpression)) {
                    throw new SqLinkException("\u4e0d\u652f\u6301\u7684\u8868\u8fbe\u5f0f:" + methodCall);
                }
                ISqlQueryableExpression queryable = (ISqlQueryableExpression)visit;
                List args = methodCall.getArgs();
                if (args.isEmpty()) {
                    queryable.setDistinct(true);
                    return queryable;
                } else {
                    ISqlExpression value = (ISqlExpression)this.visit((Expression)args.get(0));
                    if (!(value instanceof ISqlSingleValueExpression)) throw new SqLinkException("\u4e0d\u652f\u6301\u7684\u8868\u8fbe\u5f0f:" + methodCall);
                    ISqlSingleValueExpression iSqlSingleValueExpression = (ISqlSingleValueExpression)value;
                    queryable.setDistinct((Boolean)iSqlSingleValueExpression.getValue());
                }
                return queryable;
            }
            if (method.getName().equals("orderBy")) {
                ISqlExpression visit = (ISqlExpression)this.visit(methodCall.getExpr());
                if (!(visit instanceof ISqlQueryableExpression)) {
                    throw new SqLinkException("\u4e0d\u652f\u6301\u7684\u8868\u8fbe\u5f0f:" + methodCall);
                }
                ISqlQueryableExpression queryable = (ISqlQueryableExpression)visit;
                List args = methodCall.getArgs();
                ISqlExpression orderByColumn = (ISqlExpression)this.visit((Expression)args.get(0));
                if (args.size() > 1) {
                    ISqlExpression value = (ISqlExpression)this.visit((Expression)args.get(1));
                    if (!(value instanceof ISqlSingleValueExpression)) throw new SqLinkException("\u4e0d\u652f\u6301\u7684\u8868\u8fbe\u5f0f:" + methodCall);
                    ISqlSingleValueExpression iSqlSingleValueExpression = (ISqlSingleValueExpression)value;
                    queryable.addOrder(this.factory.order(orderByColumn, (Boolean)iSqlSingleValueExpression.getValue()));
                    return queryable;
                } else {
                    queryable.addOrder(this.factory.order(orderByColumn));
                }
                return queryable;
            }
            if (method.getName().equals("groupBy")) {
                throw new SqLinkException("\u8fc7\u4e8e\u590d\u6742\u7684\u8868\u8fbe\u5f0f:" + methodCall);
            }
            if (method.getName().equals("having")) {
                throw new SqLinkException("\u8fc7\u4e8e\u590d\u6742\u7684\u8868\u8fbe\u5f0f:" + methodCall);
            }
            if (method.getName().equals("limit")) {
                ISqlExpression visit = (ISqlExpression)this.visit(methodCall.getExpr());
                if (!(visit instanceof ISqlQueryableExpression)) {
                    throw new SqLinkException("\u4e0d\u652f\u6301\u7684\u8868\u8fbe\u5f0f:" + methodCall);
                }
                ISqlQueryableExpression queryable = (ISqlQueryableExpression)visit;
                List args = methodCall.getArgs();
                if (args.size() == 1) {
                    ISqlExpression rows = (ISqlExpression)this.visit((Expression)args.get(0));
                    if (!(rows instanceof ISqlSingleValueExpression)) throw new SqLinkException("\u4e0d\u652f\u6301\u7684\u8868\u8fbe\u5f0f:" + methodCall);
                    ISqlSingleValueExpression iSqlSingleValueExpression = (ISqlSingleValueExpression)rows;
                    queryable.setLimit(0L, (Long)iSqlSingleValueExpression.getValue());
                    return queryable;
                } else {
                    if (args.size() != 2) return queryable;
                    ISqlExpression offset = (ISqlExpression)this.visit((Expression)args.get(0));
                    ISqlExpression rows = (ISqlExpression)this.visit((Expression)args.get(1));
                    if (!(rows instanceof ISqlSingleValueExpression) || !(offset instanceof ISqlSingleValueExpression)) throw new SqLinkException("\u4e0d\u652f\u6301\u7684\u8868\u8fbe\u5f0f:" + methodCall);
                    ISqlSingleValueExpression rowsValue = (ISqlSingleValueExpression)rows;
                    ISqlSingleValueExpression offsetValue = (ISqlSingleValueExpression)offset;
                    queryable.setLimit((Long)offsetValue.getValue(), (Long)rowsValue.getValue());
                }
                return queryable;
            }
            if (!method.getName().equals("toList")) return this.checkAndReturnValue(methodCall);
            ISqlExpression visit = (ISqlExpression)this.visit(methodCall.getExpr());
            if (visit instanceof ISqlQueryableExpression) return visit;
            throw new SqLinkException("\u4e0d\u652f\u6301\u7684\u8868\u8fbe\u5f0f:" + methodCall);
        }
        if (Collection.class.isAssignableFrom(methodCall.getMethod().getDeclaringClass())) {
            Method method = methodCall.getMethod();
            if (method.getName().equals("contains")) {
                ISqlExpression left = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                ISqlExpression right = (ISqlExpression)this.visit(methodCall.getExpr());
                return this.factory.binary(SqlOperator.IN, left, right);
            }
            if (method.getName().equals("size")) {
                ISqlExpression left = (ISqlExpression)this.visit(methodCall.getExpr());
                if (!(left instanceof ISqlColumnExpression)) throw new SqLinkException(String.format("\u610f\u5916\u7684sql\u8868\u8fbe\u5f0f\u7c7b\u578b:%s \u8868\u8fbe\u5f0f\u4e3a:%s", left.getClass(), methodCall));
                ISqlColumnExpression columnExpression = (ISqlColumnExpression)left;
                ISqlQueryableExpression query = this.columnToQuery(columnExpression);
                query.setSelect(this.factory.select(Collections.singletonList(AggregateMethods.count(this.config, this.factory.constString("*"))), Long.TYPE));
                return query;
            }
            if (!method.getName().equals("isEmpty")) return this.checkAndReturnValue(methodCall);
            ISqlExpression left = (ISqlExpression)this.visit(methodCall.getExpr());
            if (!(left instanceof ISqlColumnExpression)) throw new SqLinkException(String.format("\u610f\u5916\u7684sql\u8868\u8fbe\u5f0f\u7c7b\u578b:%s \u8868\u8fbe\u5f0f\u4e3a:%s", left.getClass(), methodCall));
            ISqlColumnExpression columnExpression = (ISqlColumnExpression)left;
            ISqlQueryableExpression query = this.columnToQuery(columnExpression);
            query.setSelect(this.factory.select(Collections.singletonList(this.factory.constString("1")), Integer.TYPE));
            return this.factory.unary(SqlOperator.NOT, this.factory.unary(SqlOperator.EXISTS, query));
        }
        if (String.class.isAssignableFrom(methodCall.getMethod().getDeclaringClass())) {
            Method method = methodCall.getMethod();
            if (Modifier.isStatic(method.getModifiers())) {
                switch (method.getName()) {
                    case "join": {
                        ISqlExpression delimiter = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                        if (method.isVarArgs()) {
                            ArrayList<ISqlExpression> args = new ArrayList<ISqlExpression>(methodCall.getArgs().size() - 1);
                            for (int i = 1; i < methodCall.getArgs().size(); ++i) {
                                args.add((ISqlExpression)this.visit((Expression)methodCall.getArgs().get(i)));
                            }
                            return StringMethods.joinArray(this.config, delimiter, args);
                        }
                        ISqlExpression elements = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(1));
                        return StringMethods.joinList(this.config, delimiter, elements);
                    }
                }
                return this.checkAndReturnValue(methodCall);
            }
            switch (method.getName()) {
                case "contains": {
                    ISqlExpression left = (ISqlExpression)this.visit(methodCall.getExpr());
                    ISqlExpression right = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                    return StringMethods.contains(this.config, left, right);
                }
                case "startsWith": {
                    ISqlExpression left = (ISqlExpression)this.visit(methodCall.getExpr());
                    ISqlExpression right = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                    return StringMethods.startsWith(this.config, left, right);
                }
                case "endsWith": {
                    ISqlExpression left = (ISqlExpression)this.visit(methodCall.getExpr());
                    ISqlExpression right = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                    return StringMethods.endsWith(this.config, left, right);
                }
                case "length": {
                    ISqlExpression left = (ISqlExpression)this.visit(methodCall.getExpr());
                    return StringMethods.length(this.config, left);
                }
                case "toUpperCase": {
                    ISqlExpression left = (ISqlExpression)this.visit(methodCall.getExpr());
                    return StringMethods.toUpperCase(this.config, left);
                }
                case "toLowerCase": {
                    ISqlExpression left = (ISqlExpression)this.visit(methodCall.getExpr());
                    return StringMethods.toLowerCase(this.config, left);
                }
                case "concat": {
                    ISqlExpression left = (ISqlExpression)this.visit(methodCall.getExpr());
                    ISqlExpression right = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                    return StringMethods.concat(this.config, left, right);
                }
                case "trim": {
                    ISqlExpression left = (ISqlExpression)this.visit(methodCall.getExpr());
                    return StringMethods.trim(this.config, left);
                }
                case "isEmpty": {
                    ISqlExpression left = (ISqlExpression)this.visit(methodCall.getExpr());
                    return StringMethods.isEmpty(this.config, left);
                }
                case "indexOf": {
                    if (method.getParameterTypes()[0] == String.class) {
                        ISqlExpression thisStr = (ISqlExpression)this.visit(methodCall.getExpr());
                        ISqlExpression subStr = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                        if (method.getParameterCount() == 1) {
                            return StringMethods.indexOf(this.config, thisStr, subStr);
                        }
                        ISqlExpression fromIndex = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(1));
                        return StringMethods.indexOf(this.config, thisStr, subStr, fromIndex);
                    }
                }
                case "replace": {
                    ISqlExpression thisStr = (ISqlExpression)this.visit(methodCall.getExpr());
                    ISqlExpression oldStr = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                    ISqlExpression newStr = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(1));
                    return StringMethods.replace(this.config, thisStr, oldStr, newStr);
                }
                case "substring": {
                    ISqlExpression thisStr = (ISqlExpression)this.visit(methodCall.getExpr());
                    ISqlExpression beginIndex = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                    if (method.getParameterCount() == 1) {
                        return StringMethods.substring(this.config, thisStr, beginIndex);
                    }
                    ISqlExpression endIndex = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(1));
                    return StringMethods.substring(this.config, thisStr, beginIndex, endIndex);
                }
            }
            return this.checkAndReturnValue(methodCall);
        }
        if (Math.class.isAssignableFrom(methodCall.getMethod().getDeclaringClass())) {
            Method method = methodCall.getMethod();
            switch (method.getName()) {
                case "abs": {
                    ISqlExpression arg = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                    return this.factory.template(Arrays.asList("ABS(", ")"), Collections.singletonList(arg));
                }
                case "cos": {
                    ISqlExpression arg = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                    return this.factory.template(Arrays.asList("COS(", ")"), Collections.singletonList(arg));
                }
                case "acos": {
                    ISqlExpression arg = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                    return this.factory.template(Arrays.asList("ACOS(", ")"), Collections.singletonList(arg));
                }
                case "sin": {
                    ISqlExpression arg = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                    return this.factory.template(Arrays.asList("SIN(", ")"), Collections.singletonList(arg));
                }
                case "asin": {
                    ISqlExpression arg = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                    return this.factory.template(Arrays.asList("ASIN(", ")"), Collections.singletonList(arg));
                }
                case "tan": {
                    ISqlExpression arg = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                    return this.factory.template(Arrays.asList("TAN(", ")"), Collections.singletonList(arg));
                }
                case "atan": {
                    ISqlExpression arg = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                    return this.factory.template(Arrays.asList("ATAN(", ")"), Collections.singletonList(arg));
                }
                case "atan2": {
                    ISqlExpression arg1 = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                    ISqlExpression arg2 = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(1));
                    return MathMethods.atan2(this.config, arg1, arg2);
                }
                case "toDegrees": {
                    ISqlExpression arg = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                    return MathMethods.toDegrees(this.config, arg);
                }
                case "toRadians": {
                    ISqlExpression arg = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                    return MathMethods.toRadians(this.config, arg);
                }
                case "exp": {
                    ISqlExpression arg = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                    return this.factory.template(Arrays.asList("EXP(", ")"), Collections.singletonList(arg));
                }
                case "floor": {
                    ISqlExpression arg = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                    return this.factory.template(Arrays.asList("FLOOR(", ")"), Collections.singletonList(arg));
                }
                case "log": {
                    ISqlExpression arg = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                    return MathMethods.log(this.config, arg);
                }
                case "log10": {
                    ISqlExpression arg = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                    return MathMethods.log10(this.config, arg);
                }
                case "random": {
                    return MathMethods.random(this.config);
                }
                case "round": {
                    ISqlExpression arg = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                    return MathMethods.round(this.config, arg);
                }
                case "pow": {
                    ISqlExpression arg1 = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                    ISqlExpression arg2 = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(1));
                    return this.factory.template(Arrays.asList("POWER(", ",", ")"), Arrays.asList(arg1, arg2));
                }
                case "signum": {
                    ISqlExpression arg = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                    return this.factory.template(Arrays.asList("SIGN(", ")"), Collections.singletonList(arg));
                }
                case "sqrt": {
                    ISqlExpression arg = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                    return this.factory.template(Arrays.asList("SQRT(", ")"), Collections.singletonList(arg));
                }
            }
            return this.checkAndReturnValue(methodCall);
        }
        if (BigDecimal.class.isAssignableFrom(methodCall.getMethod().getDeclaringClass()) || BigInteger.class.isAssignableFrom(methodCall.getMethod().getDeclaringClass())) {
            Method method = methodCall.getMethod();
            switch (method.getName()) {
                case "add": {
                    if (method.getParameterCount() == 1) {
                        ISqlExpression left = (ISqlExpression)this.visit(methodCall.getExpr());
                        ISqlExpression right = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                        return this.factory.binary(SqlOperator.PLUS, left, right);
                    }
                }
                case "subtract": {
                    if (method.getParameterCount() == 1) {
                        ISqlExpression left = (ISqlExpression)this.visit(methodCall.getExpr());
                        ISqlExpression right = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                        return this.factory.binary(SqlOperator.MINUS, left, right);
                    }
                }
                case "multiply": {
                    if (method.getParameterCount() == 1) {
                        ISqlExpression left = (ISqlExpression)this.visit(methodCall.getExpr());
                        ISqlExpression right = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                        return this.factory.binary(SqlOperator.MUL, left, right);
                    }
                }
                case "divide": {
                    if (method.getParameterCount() == 1) {
                        ISqlExpression left = (ISqlExpression)this.visit(methodCall.getExpr());
                        ISqlExpression right = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                        return this.factory.binary(SqlOperator.DIV, left, right);
                    }
                }
                case "remainder": {
                    if (method.getParameterCount() != 1) return this.checkAndReturnValue(methodCall);
                    ISqlExpression left = (ISqlExpression)this.visit(methodCall.getExpr());
                    ISqlExpression right = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                    return BigNumberMethods.remainder(this.config, left, right);
                }
            }
            return this.checkAndReturnValue(methodCall);
        }
        if (Temporal.class.isAssignableFrom(methodCall.getMethod().getDeclaringClass())) {
            Method method = methodCall.getMethod();
            switch (method.getName()) {
                case "isAfter": {
                    ISqlExpression left = (ISqlExpression)this.visit(methodCall.getExpr());
                    ISqlExpression right = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                    return TemporalMethods.isAfter(this.config, left, right);
                }
                case "isBefore": {
                    ISqlExpression left = (ISqlExpression)this.visit(methodCall.getExpr());
                    ISqlExpression right = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                    return TemporalMethods.isBefore(this.config, left, right);
                }
                case "isEqual": {
                    ISqlExpression left = (ISqlExpression)this.visit(methodCall.getExpr());
                    ISqlExpression right = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                    return TemporalMethods.isEqual(this.config, left, right);
                }
            }
            return this.checkAndReturnValue(methodCall);
        }
        if (Objects.class.isAssignableFrom(methodCall.getMethod().getDeclaringClass())) {
            Method method = methodCall.getMethod();
            if (method.getName().equals("equals")) {
                List args = methodCall.getArgs();
                return this.factory.binary(SqlOperator.EQ, (ISqlExpression)this.visit((Expression)args.get(0)), (ISqlExpression)this.visit((Expression)args.get(1)));
            }
            if (!method.getName().equals("nonNull")) return this.checkAndReturnValue(methodCall);
            return LogicExpression.notNullExpression(this.config, (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0)));
        }
        if (ExpressionUtil.isProperty(this.asNameMap, methodCall)) {
            if (ExpressionUtil.isGetter(methodCall.getMethod())) {
                ParameterExpression parameter = (ParameterExpression)methodCall.getExpr();
                Method getter = methodCall.getMethod();
                MetaData metaData = MetaDataCache.getMetaData(getter.getDeclaringClass());
                return this.factory.column(metaData.getFieldMetaDataByGetter(getter), this.asNameMap.get(parameter));
            }
            if (!ExpressionUtil.isSetter(methodCall.getMethod())) return this.checkAndReturnValue(methodCall);
            ParameterExpression parameter = (ParameterExpression)methodCall.getExpr();
            Method setter = methodCall.getMethod();
            MetaData metaData = MetaDataCache.getMetaData(setter.getDeclaringClass());
            FieldMetaData fieldMetaData = metaData.getFieldMetaDataBySetter(setter);
            ISqlColumnExpression columnExpression = this.factory.column(fieldMetaData, this.asNameMap.get(parameter));
            ISqlExpression value = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
            return this.factory.set(columnExpression, value);
        }
        ISqlExpression left = (ISqlExpression)this.visit(methodCall.getExpr());
        if (left instanceof ISqlColumnExpression) {
            Method method = methodCall.getMethod();
            if (!ExpressionUtil.isGetter(method)) return this.checkAndReturnValue(methodCall);
            ISqlColumnExpression columnExpression = (ISqlColumnExpression)left;
            ISqlQueryableExpression changed = this.columnToQuery(columnExpression);
            return this.queryToQuery(changed, method);
        }
        if (!(left instanceof ISqlQueryableExpression)) return this.checkAndReturnValue(methodCall);
        Method method = methodCall.getMethod();
        if (!ExpressionUtil.isGetter(method)) return this.checkAndReturnValue(methodCall);
        ISqlQueryableExpression queryableExpression = (ISqlQueryableExpression)left;
        return this.queryToQuery(queryableExpression, method);
    }

    public ISqlExpression visit(BinaryExpression binary) {
        ISqlExpression left = (ISqlExpression)this.visit(binary.getLeft());
        ISqlExpression right = (ISqlExpression)this.visit(binary.getRight());
        if (left instanceof ISqlQueryableExpression) {
            left = this.factory.parens(left);
        }
        if (right instanceof ISqlQueryableExpression) {
            right = this.factory.parens(right);
        }
        return this.factory.binary(SqlOperator.valueOf(binary.getOperatorType().name()), left, right);
    }

    public ISqlExpression visit(UnaryExpression unary) {
        return this.factory.unary(SqlOperator.valueOf(unary.getOperatorType().name()), (ISqlExpression)this.visit(unary.getOperand()));
    }

    public ISqlExpression visit(ConditionalExpression conditional) {
        ISqlExpression cond = (ISqlExpression)this.visit(conditional.getCondition());
        ISqlExpression truePart = (ISqlExpression)this.visit(conditional.getTruePart());
        ISqlExpression falsePart = (ISqlExpression)this.visit(conditional.getFalsePart());
        return LogicExpression.IfExpression(this.config, cond, truePart, falsePart);
    }

    public ISqlExpression visit(ParensExpression parens) {
        return this.factory.parens((ISqlExpression)this.visit(parens.getExpr()));
    }

    public ISqlExpression visit(StaticClassExpression staticClass) {
        return this.factory.type(staticClass.getType());
    }

    public ISqlExpression visit(ConstantExpression constant) {
        return this.factory.AnyValue(constant.getValue());
    }

    public ISqlExpression visit(ReferenceExpression reference) {
        return this.factory.AnyValue(reference.getValue());
    }

    public ISqlExpression visit(NewExpression newExpression) {
        BlockExpression classBody = newExpression.getClassBody();
        if (classBody == null) {
            return this.checkAndReturnValue(newExpression);
        }
        Class type = newExpression.getType();
        if (Grouper.class.isAssignableFrom(type)) {
            LinkedHashMap<String, ISqlExpression> contextMap = new LinkedHashMap<String, ISqlExpression>();
            for (Expression expression : classBody.getExpressions()) {
                if (expression.getKind() != Kind.Variable) continue;
                VariableExpression variableExpression = (VariableExpression)expression;
                String name = variableExpression.getName();
                Expression init = variableExpression.getInit();
                if (init == null) continue;
                ISqlExpression sqlExpression = (ISqlExpression)this.visit(init);
                contextMap.put(name, sqlExpression);
            }
            return this.factory.groupBy(contextMap);
        }
        if (Result.class.isAssignableFrom(type)) {
            ArrayList<ISqlExpression> expressions = new ArrayList<ISqlExpression>();
            for (Expression expression : classBody.getExpressions()) {
                if (expression.getKind() != Kind.Variable) continue;
                VariableExpression variable = (VariableExpression)expression;
                String name = variable.getName();
                Expression init = variable.getInit();
                if (init == null) continue;
                ISqlExpression context = (ISqlExpression)this.visit(variable.getInit());
                context = this.boxTheBool(variable.getInit(), context);
                this.setAs(expressions, context, name);
            }
            return this.factory.select(expressions, newExpression.getType());
        }
        return this.checkAndReturnValue(newExpression);
    }

    public ISqlExpression visit(ParameterExpression parameter) {
        if (this.asNameMap.containsKey(parameter)) {
            Class type = parameter.getType();
            MetaData metaData = MetaDataCache.getMetaData(type);
            ArrayList<ISqlExpression> expressions = new ArrayList<ISqlExpression>();
            for (FieldMetaData pm : metaData.getNotIgnorePropertys()) {
                expressions.add(this.factory.column(pm, this.asNameMap.get(parameter)));
            }
            return this.factory.select(expressions, parameter.getType());
        }
        throw new SqLinkException(String.format("\u975elambda\u5185\u90e8\u7684ParameterExpression,\u540d\u79f0:%s \u7c7b\u578b:%s ", parameter.getName(), parameter.getType()));
    }

    public ISqlExpression visit(BlockExpression blockExpression) {
        ArrayList<ISqlSetExpression> sqlSetExpressions = new ArrayList<ISqlSetExpression>();
        for (Expression expression : blockExpression.getExpressions()) {
            ISqlExpression visit = (ISqlExpression)this.visit(expression);
            if (visit instanceof ISqlSetExpression) {
                sqlSetExpressions.add((ISqlSetExpression)visit);
                continue;
            }
            throw new SqLinkException(String.format("\u610f\u5916\u7684sql\u8868\u8fbe\u5f0f\u7c7b\u578b:%s \u8868\u8fbe\u5f0f\u4e3a:%s", visit.getClass(), expression));
        }
        ISqlSetsExpression sets = this.factory.sets();
        sets.addSet(sqlSetExpressions);
        return sets;
    }

    protected ISqlValueExpression checkAndReturnValue(MethodCallExpression expression) {
        Method method = expression.getMethod();
        if (ExpressionUtil.isVoid(method.getReturnType()) || this.hasParameter((Expression)expression)) {
            throw new SqLinkIllegalExpressionException((Expression)expression);
        }
        return this.factory.AnyValue(expression.getValue());
    }

    protected ISqlValueExpression checkAndReturnValue(FieldSelectExpression expression) {
        if (this.hasParameter((Expression)expression)) {
            throw new SqLinkIllegalExpressionException((Expression)expression);
        }
        return this.factory.AnyValue(expression.getValue());
    }

    protected ISqlValueExpression checkAndReturnValue(NewExpression expression) {
        if (this.hasParameter((Expression)expression)) {
            throw new SqLinkIllegalExpressionException((Expression)expression);
        }
        return this.factory.AnyValue(expression.getValue());
    }

    protected boolean hasParameter(Expression expression) {
        final AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        expression.accept((Visitor)new DeepFindVisitor(){

            public void visit(ParameterExpression parameterExpression) {
                atomicBoolean.set(true);
            }
        });
        return atomicBoolean.get();
    }

    protected SqlExtensionExpression getSqlFuncExt(SqlExtensionExpression[] sqlExtensionExpressions) {
        DbType dbType = this.config.getDbType();
        Optional<SqlExtensionExpression> first = Arrays.stream(sqlExtensionExpressions).filter(a -> a.dbType() == dbType).findFirst();
        if (!first.isPresent()) {
            Optional<SqlExtensionExpression> any = Arrays.stream(sqlExtensionExpressions).filter(a -> a.dbType() == DbType.Any).findFirst();
            if (any.isPresent()) {
                return any.get();
            }
            throw new SqlFuncExtNotFoundException(dbType);
        }
        return first.get();
    }

    protected ParamMatcher match(String input) {
        ParamMatcher paramMatcher = new ParamMatcher();
        List<String> bracesContent = paramMatcher.bracesContent;
        List<String> remainder = paramMatcher.remainder;
        Pattern pattern = Pattern.compile("\\{([^}]+)}");
        Matcher matcher = pattern.matcher(input);
        int lastIndex = 0;
        while (matcher.find()) {
            if (lastIndex < matcher.start()) {
                remainder.add(input.substring(lastIndex, matcher.start()));
            }
            bracesContent.add(matcher.group(1));
            lastIndex = matcher.end();
        }
        if (lastIndex < input.length()) {
            remainder.add(input.substring(lastIndex));
        }
        if (input.startsWith("{")) {
            remainder.add(0, "");
        }
        if (input.endsWith("}")) {
            remainder.add("");
        }
        return paramMatcher;
    }

    protected ISqlQueryableExpression columnToQuery(ISqlColumnExpression columnExpression) {
        String subTableAsName;
        ISqlRealTableExpression table;
        FieldMetaData fieldMetaData = columnExpression.getFieldMetaData();
        ISqlConditionsExpression condition = null;
        String mainTableAsName = columnExpression.getTableAsName();
        if (fieldMetaData.hasNavigate()) {
            NavigateData navigateData = fieldMetaData.getNavigateData();
            Class<?> targetType = navigateData.getNavigateTargetType();
            table = this.factory.table(targetType);
            MetaData targetMetaData = MetaDataCache.getMetaData(targetType);
            subTableAsName = this.doGetAsName(targetMetaData.getTableName().toLowerCase().substring(0, 1));
            condition = this.factory.condition();
            FieldMetaData targetFieldMetaData = targetMetaData.getFieldMetaDataByFieldName(navigateData.getTargetFieldName());
            FieldMetaData selfFieldMetaData = MetaDataCache.getMetaData(fieldMetaData.getParentType()).getFieldMetaDataByFieldName(navigateData.getSelfFieldName());
            condition.addCondition(this.factory.binary(SqlOperator.EQ, this.factory.column(targetFieldMetaData, subTableAsName), this.factory.column(selfFieldMetaData, mainTableAsName)));
        } else {
            Type genericType = fieldMetaData.getGenericType();
            table = this.factory.table(ExpressionUtil.getTargetType(genericType));
            subTableAsName = this.doGetAsName(MetaDataCache.getMetaData(table.getMainTableClass()).getTableName().toLowerCase().substring(0, 1));
        }
        this.asNameSet.remove(subTableAsName);
        ISqlQueryableExpression queryable = this.factory.queryable(this.factory.from(table, subTableAsName));
        if (condition != null) {
            queryable.addWhere(condition);
        }
        return queryable;
    }

    protected ISqlQueryableExpression queryToQuery(ISqlQueryableExpression left, Method method) {
        MetaData metaData = MetaDataCache.getMetaData(method.getDeclaringClass());
        FieldMetaData fieldMetaData = metaData.getFieldMetaDataByGetter(method);
        if (!fieldMetaData.hasNavigate()) {
            throw new SqLinkException(String.format("\u6ca1\u6709\u5728%s.%s\u4e0a\u627e\u5230\u4e0e%s\u7684\u5173\u8054\u5173\u7cfb", method.getDeclaringClass(), fieldMetaData.getProperty(), method.getReturnType()));
        }
        NavigateData navigateData = fieldMetaData.getNavigateData();
        Class<?> targetType = navigateData.getNavigateTargetType();
        FieldMetaData leftFieldDate = metaData.getFieldMetaDataByFieldName(navigateData.getSelfFieldName());
        String leftAsName = left.getFrom().getAsName();
        left.setSelect(this.factory.select(Collections.singletonList(this.factory.column(leftFieldDate, leftAsName)), targetType));
        MetaData targetMetaData = MetaDataCache.getMetaData(targetType);
        String targetAs = this.doGetAsName(targetMetaData.getTableName().substring(0, 1).toLowerCase());
        this.asNameSet.remove(targetAs);
        ISqlQueryableExpression targetQuery = this.factory.queryable(this.factory.from(this.factory.table(targetType), targetAs));
        ISqlConditionsExpression condition = this.factory.condition();
        targetQuery.addWhere(condition);
        FieldMetaData targetFieldMetaDate = targetMetaData.getFieldMetaDataByFieldName(navigateData.getTargetFieldName());
        condition.addCondition(this.factory.binary(SqlOperator.EQ, this.factory.column(targetFieldMetaDate, targetAs), this.factory.column(leftFieldDate, leftAsName)));
        return targetQuery;
    }

    protected void setAs(List<ISqlExpression> contexts, ISqlExpression expression, String name) {
        if (expression instanceof ISqlColumnExpression) {
            ISqlColumnExpression sqlColumn = (ISqlColumnExpression)expression;
            if (!sqlColumn.getFieldMetaData().getColumn().equals(name)) {
                contexts.add(this.factory.as(expression, name));
            } else {
                contexts.add(expression);
            }
        } else {
            contexts.add(this.factory.as(expression, name));
        }
    }

    protected ISqlExpression boxTheBool(Expression init, ISqlExpression result) {
        if (init instanceof MethodCallExpression) {
            MethodCallExpression methodCall = (MethodCallExpression)init;
            return this.boxTheBool(ExpressionUtil.isBool(methodCall.getMethod().getReturnType()), result);
        }
        if (init instanceof UnaryExpression) {
            UnaryExpression unary = (UnaryExpression)init;
            return this.boxTheBool(unary.getOperatorType() == OperatorType.NOT, result);
        }
        return result;
    }

    protected ISqlExpression boxTheBool(boolean condition, ISqlExpression result) {
        if (!condition) {
            return result;
        }
        switch (this.config.getDbType()) {
            case SQLServer: 
            case Oracle: {
                return LogicExpression.IfExpression(this.config, result, this.factory.constString("1"), this.factory.constString("0"));
            }
        }
        return result;
    }

    public ISqlSelectExpression toSelect(LambdaExpression<?> lambda) {
        ISqlSelectExpression selectExpression;
        Object expression = this.visit((LambdaExpression)lambda);
        if (expression instanceof ISqlSelectExpression) {
            selectExpression = (ISqlSelectExpression)expression;
        } else {
            SqlExpressionFactory factory = this.config.getSqlExpressionFactory();
            if (ExpressionUtil.isBool(lambda.getReturnType())) {
                switch (this.config.getDbType()) {
                    case SQLServer: 
                    case Oracle: {
                        expression = LogicExpression.IfExpression(this.config, (ISqlExpression)expression, factory.constString("1"), factory.constString("0"));
                    }
                }
            }
            selectExpression = factory.select(Collections.singletonList(expression), lambda.getReturnType(), true, false);
        }
        return selectExpression;
    }

    public ISqlGroupByExpression toGroup(LambdaExpression<?> lambda) {
        Object expression = this.visit((LambdaExpression)lambda);
        if (!(expression instanceof ISqlGroupByExpression)) {
            throw new SqLinkException(String.format("\u610f\u5916\u7684\u7c7b\u578b:%s \u8868\u8fbe\u5f0f\u4e3a:%s", expression.getClass(), lambda));
        }
        ISqlGroupByExpression group = (ISqlGroupByExpression)expression;
        return group;
    }

    public ISqlColumnExpression toColumn(LambdaExpression<?> lambda) {
        Object expression = this.visit((LambdaExpression)lambda);
        if (!(expression instanceof ISqlColumnExpression)) {
            throw new SqLinkException(String.format("\u610f\u5916\u7684\u7c7b\u578b:%s \u8868\u8fbe\u5f0f\u4e3a:%s", expression.getClass(), lambda));
        }
        ISqlColumnExpression column = (ISqlColumnExpression)expression;
        return column;
    }
}

