/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.base.expression.impl;

import java.util.ArrayList;
import java.util.List;
import org.noear.solon.data.sqlink.base.SqLinkConfig;
import org.noear.solon.data.sqlink.base.expression.ISqlExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlFromExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlJoinExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlJoinsExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlSetExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlSetsExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlUpdateExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlWhereExpression;
import org.noear.solon.data.sqlink.base.session.SqlValue;

public class SqlUpdateExpression
implements ISqlUpdateExpression {
    protected final ISqlFromExpression from;
    protected final ISqlJoinsExpression joins;
    protected final ISqlSetsExpression sets;
    protected final ISqlWhereExpression where;

    public SqlUpdateExpression(ISqlFromExpression from, ISqlJoinsExpression joins, ISqlSetsExpression sets, ISqlWhereExpression where) {
        this.from = from;
        this.joins = joins;
        this.sets = sets;
        this.where = where;
    }

    @Override
    public ISqlFromExpression getFrom() {
        return this.from;
    }

    @Override
    public ISqlJoinsExpression getJoins() {
        return this.joins;
    }

    @Override
    public ISqlSetsExpression getSets() {
        return this.sets;
    }

    @Override
    public ISqlWhereExpression getWhere() {
        return this.where;
    }

    @Override
    public void addJoin(ISqlJoinExpression join) {
        this.joins.addJoin(join);
    }

    @Override
    public void addSet(ISqlSetExpression set) {
        this.sets.addSet(set);
    }

    @Override
    public void addWhere(ISqlExpression where) {
        this.where.addCondition(where);
    }

    @Override
    public String getSqlAndValue(SqLinkConfig config, List<SqlValue> values) {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add("UPDATE");
        strings.add(this.from.getTableName());
        strings.add("AS");
        strings.add(this.from.getAsName());
        if (!this.joins.isEmpty()) {
            strings.add(this.joins.getSqlAndValue(config, values));
        }
        strings.add(this.sets.getSqlAndValue(config, values));
        if (!this.where.isEmpty()) {
            strings.add(this.where.getSqlAndValue(config, values));
        }
        return String.join((CharSequence)" ", strings);
    }
}

