/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.base.toBean.Include;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.noear.solon.data.sqlink.base.SqLinkConfig;
import org.noear.solon.data.sqlink.base.expression.ISqlBinaryExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlColumnExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlConstStringExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlLimitExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlOrderByExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlQueryableExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlWhereExpression;
import org.noear.solon.data.sqlink.base.expression.JoinType;
import org.noear.solon.data.sqlink.base.expression.SqlExpressionFactory;
import org.noear.solon.data.sqlink.base.expression.SqlOperator;
import org.noear.solon.data.sqlink.base.metaData.FieldMetaData;
import org.noear.solon.data.sqlink.base.metaData.IMappingTable;
import org.noear.solon.data.sqlink.base.metaData.MetaData;
import org.noear.solon.data.sqlink.base.metaData.MetaDataCache;
import org.noear.solon.data.sqlink.base.metaData.NavigateData;
import org.noear.solon.data.sqlink.base.session.SqlSession;
import org.noear.solon.data.sqlink.base.session.SqlValue;
import org.noear.solon.data.sqlink.base.toBean.Include.IncludeFactory;
import org.noear.solon.data.sqlink.base.toBean.Include.IncludeSet;
import org.noear.solon.data.sqlink.base.toBean.build.ObjectBuilder;
import org.noear.solon.data.sqlink.core.visitor.ExpressionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncludeBuilder<T> {
    protected static final Logger log = LoggerFactory.getLogger(IncludeBuilder.class);
    protected final SqLinkConfig config;
    protected final Class<T> targetClass;
    protected final Collection<T> sources;
    protected final List<IncludeSet> includes;
    protected final ISqlQueryableExpression queryable;
    protected final SqlExpressionFactory factory;
    protected final SqlSession session;

    public IncludeBuilder(SqLinkConfig config, SqlSession session, Class<T> targetClass, Collection<T> sources, List<IncludeSet> includes, ISqlQueryableExpression queryable) {
        this.config = config;
        this.targetClass = targetClass;
        this.sources = sources;
        this.includes = includes;
        this.queryable = queryable;
        this.factory = config.getSqlExpressionFactory();
        this.session = session;
    }

    public void include() throws InvocationTargetException, IllegalAccessException {
        MetaData targetClassMetaData = MetaDataCache.getMetaData(this.targetClass);
        HashMap<FieldMetaData, Map<Object, List<T>>> cache = new HashMap<FieldMetaData, Map<Object, List<T>>>();
        for (IncludeSet include : this.includes) {
            NavigateData navigateData = include.getColumnExpression().getFieldMetaData().getNavigateData();
            Class<?> navigateTargetType = navigateData.getNavigateTargetType();
            FieldMetaData selfFieldMetaData = targetClassMetaData.getFieldMetaDataByFieldName(navigateData.getSelfFieldName());
            FieldMetaData targetFieldMetaData = MetaDataCache.getMetaData(navigateTargetType).getFieldMetaDataByFieldName(navigateData.getTargetFieldName());
            FieldMetaData includeFieldMetaData = include.getColumnExpression().getFieldMetaData();
            Map<Object, List<T>> sourcesMapList = (Map<Object, List<T>>)cache.get(selfFieldMetaData);
            if (sourcesMapList == null) {
                sourcesMapList = this.getMapList(selfFieldMetaData);
                cache.put(selfFieldMetaData, sourcesMapList);
            }
            switch (navigateData.getRelationType()) {
                case OneToOne: {
                    this.oneToOne(sourcesMapList, include, navigateData, selfFieldMetaData, targetFieldMetaData, includeFieldMetaData);
                    break;
                }
                case OneToMany: {
                    this.oneToMany(sourcesMapList, include, navigateData, selfFieldMetaData, targetFieldMetaData, includeFieldMetaData);
                    break;
                }
                case ManyToOne: {
                    this.manyToOne(sourcesMapList, include, navigateData, selfFieldMetaData, targetFieldMetaData, includeFieldMetaData);
                    break;
                }
                case ManyToMany: {
                    this.manyToMany(sourcesMapList, include, navigateData, selfFieldMetaData, targetFieldMetaData, includeFieldMetaData);
                }
            }
        }
    }

    protected void oneToOne(Map<Object, List<T>> sourcesMapList, IncludeSet include, NavigateData navigateData, FieldMetaData selfFieldMetaData, FieldMetaData targetFieldMetaData, FieldMetaData includeFieldMetaData) throws InvocationTargetException, IllegalAccessException {
        Class<?> navigateTargetType = navigateData.getNavigateTargetType();
        String tempQueryAsName = ExpressionUtil.getAsName(navigateTargetType);
        ISqlQueryableExpression tempQueryable = this.factory.queryable(navigateTargetType, tempQueryAsName);
        String warpQueryAsName = ExpressionUtil.getAsName(this.queryable.getMainTableClass());
        ISqlQueryableExpression warpQueryable = this.factory.queryable(this.queryable, warpQueryAsName);
        warpQueryable.setSelect(this.factory.select(Collections.singletonList(this.factory.column(selfFieldMetaData, warpQueryAsName)), selfFieldMetaData.getType(), true, false));
        tempQueryable.addWhere(this.factory.binary(SqlOperator.IN, this.factory.column(targetFieldMetaData, tempQueryAsName), warpQueryable));
        if (include.hasCond()) {
            ISqlExpression cond = include.getCond();
            if (cond instanceof ISqlQueryableExpression) {
                ISqlQueryableExpression queryableExpression = (ISqlQueryableExpression)cond;
                tempQueryable = this.warpItQueryable(tempQueryable, targetFieldMetaData, navigateTargetType, queryableExpression);
            } else {
                tempQueryable.addWhere(this.factory.parens(cond));
            }
        }
        ArrayList<SqlValue> values = new ArrayList<SqlValue>();
        String sql = tempQueryable.getSqlAndValue(this.config, values);
        this.tryPrint(sql);
        List<FieldMetaData> mappingData = tempQueryable.getMappingData();
        Map objectMap = this.session.executeQuery(r -> ObjectBuilder.start(r, (Class)ExpressionUtil.cast(navigateTargetType), mappingData, false, this.config).createMap(targetFieldMetaData.getColumn()), sql, values);
        for (Map.Entry objectEntry : objectMap.entrySet()) {
            Object key = objectEntry.getKey();
            Object value = objectEntry.getValue();
            for (T t : sourcesMapList.get(key)) {
                includeFieldMetaData.getSetter().invoke(t, value);
            }
        }
        this.round(include, navigateTargetType, objectMap.values(), tempQueryable, new Object[0]);
    }

    protected void oneToMany(Map<Object, List<T>> sourcesMapList, IncludeSet include, NavigateData navigateData, FieldMetaData selfFieldMetaData, FieldMetaData targetFieldMetaData, FieldMetaData includeFieldMetaData) throws InvocationTargetException, IllegalAccessException {
        Class<?> navigateTargetType = navigateData.getNavigateTargetType();
        String tempQueryAsName = ExpressionUtil.getAsName(navigateTargetType);
        ISqlQueryableExpression tempQueryable = this.factory.queryable(navigateTargetType, tempQueryAsName);
        String warpQueryAsName = ExpressionUtil.getAsName(this.queryable.getMainTableClass());
        ISqlQueryableExpression warpQueryable = this.factory.queryable(this.queryable, warpQueryAsName);
        warpQueryable.setSelect(this.factory.select(Collections.singletonList(this.factory.column(selfFieldMetaData, warpQueryAsName)), selfFieldMetaData.getType(), true, false));
        tempQueryable.addWhere(this.factory.binary(SqlOperator.IN, this.factory.column(targetFieldMetaData, tempQueryAsName), warpQueryable));
        if (include.hasCond()) {
            ISqlExpression cond = include.getCond();
            if (cond instanceof ISqlQueryableExpression) {
                ISqlQueryableExpression queryableExpression = (ISqlQueryableExpression)cond;
                tempQueryable = this.warpItQueryable(tempQueryable, targetFieldMetaData, navigateTargetType, queryableExpression);
            } else {
                tempQueryable.addWhere(this.factory.parens(cond));
            }
        }
        ArrayList<SqlValue> values = new ArrayList<SqlValue>();
        String sql = tempQueryable.getSqlAndValue(this.config, values);
        this.tryPrint(sql);
        List<FieldMetaData> mappingData = tempQueryable.getMappingData();
        Map targetMap = this.session.executeQuery(r -> ObjectBuilder.start(r, (Class)ExpressionUtil.cast(navigateTargetType), mappingData, false, this.config).createMapList(targetFieldMetaData.getColumn()), sql, values);
        boolean isSet = Set.class.isAssignableFrom(navigateData.getCollectionWrapperType());
        for (Map.Entry objectListEntry : targetMap.entrySet()) {
            Object key = objectListEntry.getKey();
            List value = (List)objectListEntry.getValue();
            for (T t : sourcesMapList.get(key)) {
                if (isSet) {
                    includeFieldMetaData.getSetter().invoke(t, new HashSet(value));
                    continue;
                }
                includeFieldMetaData.getSetter().invoke(t, value);
            }
        }
        this.round(include, navigateTargetType, targetMap.values(), tempQueryable);
    }

    protected void manyToOne(Map<Object, List<T>> sourcesMapList, IncludeSet include, NavigateData navigateData, FieldMetaData selfFieldMetaData, FieldMetaData targetFieldMetaData, FieldMetaData includeFieldMetaData) throws InvocationTargetException, IllegalAccessException {
        Class<?> navigateTargetType = navigateData.getNavigateTargetType();
        String tempQueryAsName = ExpressionUtil.getAsName(navigateTargetType);
        ISqlQueryableExpression tempQueryable = this.factory.queryable(navigateTargetType, tempQueryAsName);
        String warpQueryAsName = ExpressionUtil.getAsName(this.queryable.getMainTableClass());
        ISqlQueryableExpression warpQueryable = this.factory.queryable(this.queryable, warpQueryAsName);
        warpQueryable.setSelect(this.factory.select(Collections.singletonList(this.factory.column(selfFieldMetaData, warpQueryAsName)), selfFieldMetaData.getType(), true, false));
        tempQueryable.addWhere(this.factory.binary(SqlOperator.IN, this.factory.column(targetFieldMetaData, tempQueryAsName), warpQueryable));
        if (include.hasCond()) {
            ISqlExpression cond = include.getCond();
            if (cond instanceof ISqlQueryableExpression) {
                ISqlQueryableExpression queryableExpression = (ISqlQueryableExpression)cond;
                tempQueryable = this.warpItQueryable(tempQueryable, targetFieldMetaData, navigateTargetType, queryableExpression);
            } else {
                tempQueryable.addWhere(this.factory.parens(cond));
            }
        }
        ArrayList<SqlValue> values = new ArrayList<SqlValue>();
        String sql = tempQueryable.getSqlAndValue(this.config, values);
        this.tryPrint(sql);
        List<FieldMetaData> mappingData = tempQueryable.getMappingData();
        Map objectMap = this.session.executeQuery(r -> ObjectBuilder.start(r, (Class)ExpressionUtil.cast(navigateTargetType), mappingData, false, this.config).createMap(targetFieldMetaData.getColumn()), sql, values);
        for (Map.Entry objectEntry : objectMap.entrySet()) {
            Object key = objectEntry.getKey();
            Object value = objectEntry.getValue();
            List<T> ts = sourcesMapList.get(key);
            for (T t : ts) {
                includeFieldMetaData.getSetter().invoke(t, value);
            }
        }
        this.round(include, navigateTargetType, objectMap.values(), tempQueryable, new Object[0]);
    }

    protected void manyToMany(Map<Object, List<T>> sourcesMapList, IncludeSet include, NavigateData navigateData, FieldMetaData selfFieldMetaData, FieldMetaData targetFieldMetaData, FieldMetaData includeFieldMetaData) throws InvocationTargetException, IllegalAccessException {
        Class<?> navigateTargetType = navigateData.getNavigateTargetType();
        Class<? extends IMappingTable> mappingTableType = navigateData.getMappingTableType();
        MetaData mappingTableMetadata = MetaDataCache.getMetaData(mappingTableType);
        String selfMappingPropertyName = navigateData.getSelfMappingFieldName();
        FieldMetaData selfMappingFieldMetaData = mappingTableMetadata.getFieldMetaDataByFieldName(selfMappingPropertyName);
        String targetMappingPropertyName = navigateData.getTargetMappingFieldName();
        FieldMetaData targetMappingFieldMetaData = mappingTableMetadata.getFieldMetaDataByFieldName(targetMappingPropertyName);
        String tempQueryAsName = ExpressionUtil.getAsName(navigateTargetType);
        ISqlQueryableExpression tempQueryable = this.factory.queryable(navigateTargetType, tempQueryAsName);
        String mappingTableAsName = ExpressionUtil.getAsName(mappingTableType);
        mappingTableAsName = mappingTableAsName.equals(tempQueryAsName) ? mappingTableAsName + 1 : mappingTableAsName;
        tempQueryable.addJoin(this.factory.join(JoinType.LEFT, this.factory.table(mappingTableType), this.factory.binary(SqlOperator.EQ, this.factory.column(targetFieldMetaData, tempQueryAsName), this.factory.column(targetMappingFieldMetaData, mappingTableAsName)), mappingTableAsName));
        String warpQueryAsName = ExpressionUtil.getAsName(this.queryable.getMainTableClass());
        ISqlQueryableExpression warpQueryable = this.factory.queryable(this.queryable, warpQueryAsName);
        warpQueryable.setSelect(this.factory.select(Collections.singletonList(this.factory.column(selfFieldMetaData, warpQueryable.getFrom().getAsName())), selfFieldMetaData.getType(), true, false));
        tempQueryable.addWhere(this.factory.binary(SqlOperator.IN, this.factory.column(selfMappingFieldMetaData, mappingTableAsName), warpQueryable));
        tempQueryable.getSelect().getColumns().add(this.factory.column(selfMappingFieldMetaData, mappingTableAsName));
        if (include.hasCond()) {
            ISqlExpression cond = include.getCond();
            if (cond instanceof ISqlQueryableExpression) {
                ISqlQueryableExpression queryableExpression = (ISqlQueryableExpression)cond;
                tempQueryable = this.warpItQueryable(tempQueryable, selfMappingFieldMetaData, navigateTargetType, queryableExpression, this.factory.column(selfMappingFieldMetaData, mappingTableAsName));
            } else {
                tempQueryable.addWhere(this.factory.parens(cond));
            }
        }
        ArrayList<SqlValue> values = new ArrayList<SqlValue>();
        String sql = tempQueryable.getSqlAndValue(this.config, values);
        this.tryPrint(sql);
        List<FieldMetaData> mappingData = tempQueryable.getMappingData();
        Map targetMap = this.session.executeQuery(r -> ObjectBuilder.start(r, (Class)ExpressionUtil.cast(navigateTargetType), mappingData, false, this.config).createMapListByAnotherKey(selfMappingFieldMetaData), sql, values);
        boolean isSet = Set.class.isAssignableFrom(navigateData.getCollectionWrapperType());
        for (Map.Entry objectEntry : targetMap.entrySet()) {
            Object key = objectEntry.getKey();
            List value = (List)objectEntry.getValue();
            List<T> ts = sourcesMapList.get(key);
            for (T t : ts) {
                if (isSet) {
                    includeFieldMetaData.getSetter().invoke(t, new HashSet(value));
                    continue;
                }
                includeFieldMetaData.getSetter().invoke(t, value);
            }
        }
        this.round(include, navigateTargetType, targetMap.values(), tempQueryable);
    }

    protected <K> Map<K, T> getMap(FieldMetaData fieldMetaData) throws InvocationTargetException, IllegalAccessException {
        HashMap<Object, T> sourcesMap = new HashMap<Object, T>();
        for (T source : this.sources) {
            Object selfKey = fieldMetaData.getGetter().invoke(source, new Object[0]);
            sourcesMap.put(selfKey, source);
        }
        return sourcesMap;
    }

    protected <Key> Map<Key, List<T>> getMapList(FieldMetaData fieldMetaData) throws InvocationTargetException, IllegalAccessException {
        HashMap sourcesMapList = new HashMap();
        for (T source : this.sources) {
            Object selfKey = fieldMetaData.getGetter().invoke(source, new Object[0]);
            if (!sourcesMapList.containsKey(selfKey)) {
                ArrayList<T> list = new ArrayList<T>();
                list.add(source);
                sourcesMapList.put(selfKey, list);
                continue;
            }
            ((List)sourcesMapList.get(selfKey)).add(source);
        }
        return sourcesMapList;
    }

    protected ISqlQueryableExpression warpItQueryable(ISqlQueryableExpression querySqlBuilder, FieldMetaData targetFieldMetaData, Class<?> navigateTargetType, ISqlQueryableExpression virtualTableContext) {
        return this.warpItQueryable(querySqlBuilder, targetFieldMetaData, navigateTargetType, virtualTableContext, null);
    }

    protected ISqlQueryableExpression warpItQueryable(ISqlQueryableExpression queryableExpression, FieldMetaData targetFieldMetaData, Class<?> navigateTargetType, ISqlQueryableExpression virtualTableContext, ISqlColumnExpression another) {
        ISqlOrderByExpression orderBy = virtualTableContext.getOrderBy();
        ISqlWhereExpression where = virtualTableContext.getWhere();
        ISqlLimitExpression limit = virtualTableContext.getLimit();
        if (!where.isEmpty()) {
            for (ISqlExpression condition : where.getConditions().getConditions()) {
                queryableExpression.addWhere(condition);
            }
        }
        String windowAsName = ExpressionUtil.getAsName(queryableExpression.getMainTableClass());
        ISqlQueryableExpression window = this.factory.queryable(queryableExpression, windowAsName);
        ArrayList<ISqlExpression> selects = new ArrayList<ISqlExpression>(2);
        selects.add(this.factory.constString(window.getFrom().getAsName() + ".*"));
        ArrayList<ISqlExpression> rowNumberParams = new ArrayList<ISqlExpression>();
        rowNumberParams.add(this.factory.column(targetFieldMetaData, windowAsName));
        rowNumberParams.addAll(orderBy.getSqlOrders());
        ArrayList<String> rowNumberFunction = new ArrayList<String>();
        this.rowNumber(rowNumberFunction, rowNumberParams);
        String rank = "-rank-";
        selects.add(this.factory.as(this.factory.template(rowNumberFunction, rowNumberParams), rank));
        window.setSelect(this.factory.select(selects, navigateTargetType));
        String window2AsName = ExpressionUtil.getAsName(window.getMainTableClass());
        ISqlQueryableExpression window2 = this.factory.queryable(window, window2AsName);
        if (another != null) {
            window2.getSelect().getColumns().add(another);
        }
        if (limit.onlyHasRows()) {
            ISqlConstStringExpression _rank_ = this.factory.constString(this.config.getDisambiguation().disambiguation(rank));
            window2.addWhere(this.factory.binary(SqlOperator.LE, _rank_, this.factory.value(limit.getRows())));
        } else if (limit.hasRowsAndOffset()) {
            ISqlConstStringExpression _rank_ = this.factory.constString(this.config.getDisambiguation().disambiguation(rank));
            ISqlBinaryExpression right = this.factory.binary(SqlOperator.LE, _rank_, this.factory.value(limit.getOffset() + limit.getRows()));
            ISqlBinaryExpression left = this.factory.binary(SqlOperator.GT, _rank_, this.factory.value(limit.getOffset()));
            window2.addWhere(this.factory.binary(SqlOperator.AND, left, right));
        }
        return window2;
    }

    protected void round(IncludeSet include, Class<?> navigateTargetType, Collection<?> sources, ISqlQueryableExpression main, Object ... os) throws InvocationTargetException, IllegalAccessException {
        if (!include.getIncludeSets().isEmpty()) {
            IncludeFactory includeFactory = this.config.getIncludeFactory();
            includeFactory.getBuilder(this.config, this.session, (Class)ExpressionUtil.cast(navigateTargetType), sources, include.getIncludeSets(), main).include();
        }
    }

    protected void round(IncludeSet include, Class<?> navigateTargetType, Collection<List<Object>> sources, ISqlQueryableExpression main) throws InvocationTargetException, IllegalAccessException {
        if (!include.getIncludeSets().isEmpty()) {
            List collect = sources.stream().flatMap(o -> o.stream()).collect(Collectors.toList());
            IncludeFactory includeFactory = this.config.getIncludeFactory();
            includeFactory.getBuilder(this.config, this.session, (Class)ExpressionUtil.cast(navigateTargetType), collect, include.getIncludeSets(), main).include();
        }
    }

    private void tryPrint(String sql) {
        if (this.config.isPrintSql()) {
            log.info("includeQuery: ==> {}", (Object)sql);
        }
    }

    protected void rowNumber(List<String> rowNumberFunction, List<ISqlExpression> rowNumberParams) {
        rowNumberFunction.add("ROW_NUMBER() OVER (PARTITION BY ");
        if (rowNumberParams.size() > 1) {
            rowNumberFunction.add(" ORDER BY ");
        }
        for (int i = 0; i < rowNumberParams.size(); ++i) {
            if (i >= rowNumberParams.size() - 2) continue;
            rowNumberFunction.add(",");
        }
        rowNumberFunction.add(")");
    }
}

