/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.core.visitor;

import io.github.kiryu1223.expressionTree.expressions.Expression;
import io.github.kiryu1223.expressionTree.expressions.FieldSelectExpression;
import java.util.LinkedHashMap;
import org.noear.solon.data.sqlink.base.SqLinkConfig;
import org.noear.solon.data.sqlink.base.expression.ISqlExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlGroupByExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlQueryableExpression;
import org.noear.solon.data.sqlink.core.visitor.ExpressionUtil;
import org.noear.solon.data.sqlink.core.visitor.SqlVisitor;

public class HavingVisitor
extends SqlVisitor {
    private final ISqlQueryableExpression queryable;

    public HavingVisitor(SqLinkConfig config, ISqlQueryableExpression queryable) {
        super(config);
        this.queryable = queryable;
    }

    @Override
    public ISqlExpression visit(FieldSelectExpression fieldSelect) {
        if (ExpressionUtil.isGroupKey(this.parameters, (Expression)fieldSelect)) {
            ISqlGroupByExpression groupBy = this.queryable.getGroupBy();
            return groupBy.getColumns().get("key");
        }
        if (ExpressionUtil.isGroupKey(this.parameters, fieldSelect.getExpr())) {
            LinkedHashMap<String, ISqlExpression> columns = this.queryable.getGroupBy().getColumns();
            return (ISqlExpression)columns.get(fieldSelect.getField().getName());
        }
        return super.visit(fieldSelect);
    }

    @Override
    protected SqlVisitor getSelf() {
        return new HavingVisitor(this.config, this.queryable);
    }
}

