/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.base.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import org.noear.solon.data.sqlink.base.expression.ISqlAsExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlBinaryExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlCollectedValueExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlColumnExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlConditionsExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlConstStringExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlFromExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlGroupByExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlHavingExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlJoinExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlJoinsExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlLimitExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlOrderByExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlOrderExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlParensExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlQueryableExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlRealTableExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlSelectExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlSetExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlSetsExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlSingleValueExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlTableExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlTemplateExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlTypeExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlUnaryExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlValueExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlWhereExpression;
import org.noear.solon.data.sqlink.base.expression.JoinType;
import org.noear.solon.data.sqlink.base.expression.SqlOperator;
import org.noear.solon.data.sqlink.base.metaData.FieldMetaData;
import org.noear.solon.data.sqlink.base.metaData.MetaData;
import org.noear.solon.data.sqlink.base.metaData.MetaDataCache;

public interface SqlExpressionFactory {
    public ISqlAsExpression as(ISqlExpression var1, String var2);

    default public ISqlColumnExpression column(FieldMetaData fieldMetaData) {
        return this.column(fieldMetaData, 0);
    }

    public ISqlColumnExpression column(FieldMetaData var1, int var2);

    public ISqlConditionsExpression condition();

    default public ISqlFromExpression from(ISqlTableExpression sqlTable) {
        return this.from(sqlTable, 0);
    }

    public ISqlFromExpression from(ISqlTableExpression var1, int var2);

    public ISqlGroupByExpression groupBy();

    default public ISqlGroupByExpression groupBy(LinkedHashMap<String, ISqlExpression> columns) {
        ISqlGroupByExpression groupByExpression = this.groupBy();
        groupByExpression.setColumns(columns);
        return groupByExpression;
    }

    public ISqlHavingExpression having();

    public ISqlJoinExpression join(JoinType var1, ISqlTableExpression var2, ISqlExpression var3, int var4);

    public ISqlJoinsExpression Joins();

    public ISqlLimitExpression limit();

    default public ISqlLimitExpression limit(long offset, long rows) {
        ISqlLimitExpression limit = this.limit();
        limit.setOffset(offset);
        limit.setRows(rows);
        return limit;
    }

    public ISqlOrderByExpression orderBy();

    default public ISqlOrderExpression order(ISqlExpression expression) {
        return this.order(expression, true);
    }

    public ISqlOrderExpression order(ISqlExpression var1, boolean var2);

    default public ISqlQueryableExpression queryable(Class<?> target) {
        return this.queryable(this.from(this.table(target), 0));
    }

    default public ISqlQueryableExpression queryable(ISqlFromExpression from) {
        return this.queryable(this.select(from.getSqlTableExpression().getTableClass()), from, this.Joins(), this.where(), this.groupBy(), this.having(), this.orderBy(), this.limit());
    }

    default public ISqlQueryableExpression queryable(ISqlTableExpression table) {
        return this.queryable(this.from(table));
    }

    public ISqlQueryableExpression queryable(ISqlSelectExpression var1, ISqlFromExpression var2, ISqlJoinsExpression var3, ISqlWhereExpression var4, ISqlGroupByExpression var5, ISqlHavingExpression var6, ISqlOrderByExpression var7, ISqlLimitExpression var8);

    public ISqlRealTableExpression table(Class<?> var1);

    default public ISqlSelectExpression select(Class<?> target) {
        return this.select(this.getColumnByClass(target), target, false, false);
    }

    default public ISqlSelectExpression select(List<ISqlExpression> column, Class<?> target) {
        return this.select(column, target, false, false);
    }

    public ISqlSelectExpression select(List<ISqlExpression> var1, Class<?> var2, boolean var3, boolean var4);

    default public ISqlWhereExpression where() {
        return this.where(this.condition());
    }

    public ISqlWhereExpression where(ISqlConditionsExpression var1);

    public ISqlSetExpression set(ISqlColumnExpression var1, ISqlExpression var2);

    public ISqlSetsExpression sets();

    default public ISqlValueExpression AnyValue(Object value) {
        if (value instanceof Collection) {
            return this.value((Collection)value);
        }
        return this.value(value);
    }

    public ISqlSingleValueExpression value(Object var1);

    public ISqlCollectedValueExpression value(Collection<?> var1);

    public ISqlTemplateExpression template(List<String> var1, List<? extends ISqlExpression> var2);

    public ISqlBinaryExpression binary(SqlOperator var1, ISqlExpression var2, ISqlExpression var3);

    public ISqlUnaryExpression unary(SqlOperator var1, ISqlExpression var2);

    public ISqlParensExpression parens(ISqlExpression var1);

    public ISqlConstStringExpression constString(String var1);

    public ISqlTypeExpression type(Class<?> var1);

    default public List<ISqlExpression> getColumnByClass(Class<?> target) {
        MetaData metaData = MetaDataCache.getMetaData(target);
        List<FieldMetaData> property = metaData.getNotIgnorePropertys();
        ArrayList<ISqlExpression> columns = new ArrayList<ISqlExpression>(property.size());
        for (FieldMetaData data : property) {
            columns.add(this.column(data, 0));
        }
        return columns;
    }
}

