/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.core;

import org.noear.solon.data.sqlink.api.client.SQLinkClient;
import org.noear.solon.data.sqlink.base.DbType;
import org.noear.solon.data.sqlink.base.IDialect;
import org.noear.solon.data.sqlink.base.dataSource.DataSourceManager;
import org.noear.solon.data.sqlink.base.session.DefaultSqlSessionFactory;
import org.noear.solon.data.sqlink.base.session.SqlSessionFactory;
import org.noear.solon.data.sqlink.base.toBean.beancreator.BeanCreatorFactory;
import org.noear.solon.data.sqlink.base.toBean.handler.ITypeHandler;
import org.noear.solon.data.sqlink.base.toBean.handler.TypeHandlerManager;
import org.noear.solon.data.sqlink.base.transaction.DefaultTransactionManager;
import org.noear.solon.data.sqlink.base.transaction.TransactionManager;
import org.noear.solon.data.sqlink.core.Config;
import org.noear.solon.data.sqlink.core.Option;

public class SQLink {
    private DbType dbType = DbType.MySQL;
    private IDialect dialect;
    private Option option = new Option();
    private DataSourceManager dataSourceManager;
    private TransactionManager transactionManager;
    private SqlSessionFactory sqlSessionFactory;
    private BeanCreatorFactory beanCreatorFactory;

    private SQLink() {
    }

    public SQLinkClient build() {
        if (this.dataSourceManager == null) {
            throw new NullPointerException("dataSourceManager is null");
        }
        if (this.transactionManager == null) {
            this.transactionManager = new DefaultTransactionManager(this.dataSourceManager);
        }
        if (this.sqlSessionFactory == null) {
            this.sqlSessionFactory = new DefaultSqlSessionFactory(this.dataSourceManager, this.transactionManager);
        }
        if (this.beanCreatorFactory == null) {
            this.beanCreatorFactory = new BeanCreatorFactory();
        }
        Config config = new Config(this.option, this.dbType, this.transactionManager, this.dataSourceManager, this.sqlSessionFactory, this.beanCreatorFactory);
        if (this.dialect != null) {
            config.setDisambiguation(this.dialect);
        }
        return new SQLinkClient(config);
    }

    public static SQLink bootStrap() {
        return new SQLink();
    }

    public SQLink setDataSourceManager(DataSourceManager dataSourceManager) {
        this.dataSourceManager = dataSourceManager;
        return this;
    }

    public SQLink setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
        return this;
    }

    public SQLink setSqlSessionFactory(SqlSessionFactory sqlSessionFactory) {
        this.sqlSessionFactory = sqlSessionFactory;
        return this;
    }

    public SQLink setDbType(DbType dbType) {
        this.dbType = dbType;
        return this;
    }

    public SQLink setOption(Option option) {
        this.option = option;
        return this;
    }

    public SQLink setFastCreatorFactory(BeanCreatorFactory beanCreatorFactory) {
        this.beanCreatorFactory = beanCreatorFactory;
        return this;
    }

    public SQLink addTypeHandler(ITypeHandler<?> iTypeHandler) {
        TypeHandlerManager.set(iTypeHandler);
        return this;
    }

    public SQLink setDialect(IDialect dialect) {
        this.dialect = dialect;
        return this;
    }
}

