/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.base.metaData;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.noear.solon.data.sqlink.base.annotation.Column;
import org.noear.solon.data.sqlink.base.annotation.EmptyTable;
import org.noear.solon.data.sqlink.base.annotation.IgnoreColumn;
import org.noear.solon.data.sqlink.base.annotation.Navigate;
import org.noear.solon.data.sqlink.base.annotation.Table;
import org.noear.solon.data.sqlink.base.annotation.UseTypeHandler;
import org.noear.solon.data.sqlink.base.metaData.NavigateData;
import org.noear.solon.data.sqlink.base.metaData.PropertyMetaData;
import org.noear.solon.data.sqlink.base.toBean.handler.ITypeHandler;
import org.noear.solon.data.sqlink.base.toBean.handler.TypeHandlerManager;
import org.noear.solon.data.sqlink.core.visitor.ExpressionUtil;

public class MetaData {
    private final List<PropertyMetaData> propertys = new ArrayList<PropertyMetaData>();
    private final Class<?> type;
    private final Constructor<?> constructor;
    private final String tableName;
    private final String schema;
    private final boolean isEmptyTable;

    public MetaData(Class<?> type) {
        try {
            this.type = type;
            this.constructor = !type.isAnonymousClass() ? type.getConstructor(new Class[0]) : null;
            Table table = type.getAnnotation(Table.class);
            this.tableName = table == null || table.value().isEmpty() ? type.getSimpleName() : table.value();
            this.schema = table == null ? "" : table.schema();
            this.isEmptyTable = type.isAnnotationPresent(EmptyTable.class);
            for (PropertyDescriptor descriptor : this.propertyDescriptors(type)) {
                boolean isPrimaryKey;
                String property = descriptor.getName();
                Field field = type.getDeclaredField(property);
                Column column = field.getAnnotation(Column.class);
                String columnStr = column == null || column.value().isEmpty() ? property : column.value();
                UseTypeHandler useTypeHandler = field.getAnnotation(UseTypeHandler.class);
                boolean isUseTypeHandler = useTypeHandler != null;
                ITypeHandler typeHandler = useTypeHandler == null ? TypeHandlerManager.get(field.getGenericType()) : TypeHandlerManager.getByHandlerType((Class)ExpressionUtil.cast(useTypeHandler.value()));
                NavigateData navigateData = null;
                Navigate navigate = field.getAnnotation(Navigate.class);
                boolean bl = isPrimaryKey = column != null && column.primaryKey();
                if (navigate != null) {
                    if (Collection.class.isAssignableFrom(field.getType())) {
                        Type genericType = field.getGenericType();
                        Class navigateTargetType = (Class)((ParameterizedType)genericType).getActualTypeArguments()[0];
                        navigateData = new NavigateData(navigate, navigateTargetType, field.getType());
                    } else {
                        Class<?> navigateTargetType = field.getType();
                        navigateData = new NavigateData(navigate, navigateTargetType, null);
                    }
                }
                boolean ignoreColumn = field.getAnnotation(IgnoreColumn.class) != null || navigateData != null;
                this.propertys.add(new PropertyMetaData(property, columnStr, descriptor.getReadMethod(), descriptor.getWriteMethod(), field, isUseTypeHandler, typeHandler, ignoreColumn, navigateData, isPrimaryKey));
            }
        }
        catch (NoSuchFieldException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private PropertyDescriptor[] propertyDescriptors(Class<?> c) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(c, Object.class);
            return beanInfo.getPropertyDescriptors();
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
    }

    public List<PropertyMetaData> getPropertys() {
        return this.propertys;
    }

    public List<PropertyMetaData> getNotIgnorePropertys() {
        return this.propertys.stream().filter(f -> !f.isIgnoreColumn()).collect(Collectors.toList());
    }

    public PropertyMetaData getPropertyMetaDataByFieldName(String key) {
        return this.propertys.stream().filter(f -> f.getProperty().equals(key)).findFirst().orElseThrow(() -> new RuntimeException(key));
    }

    public PropertyMetaData getPropertyMetaDataByColumnName(String asName) {
        return this.propertys.stream().filter(f -> f.getColumn().equals(asName)).findFirst().orElseThrow(() -> new RuntimeException(asName));
    }

    public PropertyMetaData getPropertyMetaDataByGetter(Method getter) {
        return this.getPropertyMetaDataByColumnName(this.getColumnNameByGetter(getter));
    }

    public PropertyMetaData getPropertyMetaDataBySetter(Method setter) {
        return this.getPropertyMetaDataByColumnName(this.getColumnNameBySetter(setter));
    }

    public String getColumnNameByGetter(Method getter) {
        return this.propertys.stream().filter(f -> f.getGetter().equals(getter)).findFirst().orElseThrow(() -> new RuntimeException(getter.toGenericString())).getColumn();
    }

    public String getColumnNameBySetter(Method setter) {
        return this.propertys.stream().filter(f -> f.getSetter().equals(setter)).findFirst().orElseThrow(() -> new RuntimeException(setter.toGenericString())).getColumn();
    }

    public PropertyMetaData getPrimary() {
        return this.propertys.stream().filter(f -> f.isPrimaryKey()).findFirst().orElse(null);
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getSchema() {
        return this.schema;
    }

    public boolean isEmptyTable() {
        return this.isEmptyTable;
    }

    public Constructor<?> getConstructor() {
        return this.constructor;
    }
}

