/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.core.sqlExt.oracle;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.noear.solon.data.sqlink.base.DbType;
import org.noear.solon.data.sqlink.base.IConfig;
import org.noear.solon.data.sqlink.base.expression.ISqlExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlSingleValueExpression;
import org.noear.solon.data.sqlink.base.sqlExt.BaseSqlExtension;
import org.noear.solon.data.sqlink.core.exception.SQLinkIntervalException;

public class OracleAddOrSubDateExtension
extends BaseSqlExtension {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ISqlExpression parse(IConfig config, Method sqlFunc, List<ISqlExpression> args) {
        ArrayList<String> templates = new ArrayList<String>();
        ArrayList<ISqlExpression> sqlExpressions = new ArrayList<ISqlExpression>();
        if (sqlFunc.getParameterCount() == 2) {
            templates.add("(");
            sqlExpressions.add(args.get(0));
            ISqlExpression num = args.get(1);
            if (!(num instanceof ISqlSingleValueExpression)) throw new SQLinkIntervalException(DbType.Oracle);
            ISqlSingleValueExpression valueExpression = (ISqlSingleValueExpression)num;
            if (sqlFunc.getName().equals("addDate")) {
                templates.add(" + INTERVAL '" + valueExpression.getValue() + "' DAY)");
                return config.getSqlExpressionFactory().template(templates, sqlExpressions);
            } else {
                templates.add(" - INTERVAL '" + valueExpression.getValue() + "' DAY)");
            }
            return config.getSqlExpressionFactory().template(templates, sqlExpressions);
        } else {
            templates.add("(");
            sqlExpressions.add(args.get(0));
            sqlExpressions.add(args.get(1));
            ISqlExpression num = args.get(2);
            if (!(num instanceof ISqlSingleValueExpression)) throw new SQLinkIntervalException(DbType.Oracle);
            ISqlSingleValueExpression valueExpression = (ISqlSingleValueExpression)num;
            if (sqlFunc.getName().equals("addDate")) {
                templates.add(" + INTERVAL '" + valueExpression.getValue() + "' ");
            } else {
                templates.add(" - INTERVAL '" + valueExpression.getValue() + "' ");
            }
            templates.add(")");
        }
        return config.getSqlExpressionFactory().template(templates, sqlExpressions);
    }
}

