/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.core.api.crud.update;

import io.github.kiryu1223.expressionTree.expressions.ExprTree;
import io.github.kiryu1223.expressionTree.expressions.LambdaExpression;
import java.util.ArrayList;
import org.noear.solon.data.sqlink.base.IConfig;
import org.noear.solon.data.sqlink.base.expression.ISqlExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlRealTableExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlSetExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlSetsExpression;
import org.noear.solon.data.sqlink.base.expression.JoinType;
import org.noear.solon.data.sqlink.base.expression.SqlExpressionFactory;
import org.noear.solon.data.sqlink.base.session.SqlSession;
import org.noear.solon.data.sqlink.core.api.crud.CRUD;
import org.noear.solon.data.sqlink.core.sqlBuilder.UpdateSqlBuilder;
import org.noear.solon.data.sqlink.core.visitor.NormalVisitor;
import org.noear.solon.data.sqlink.core.visitor.SetVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateBase
extends CRUD {
    public static final Logger log = LoggerFactory.getLogger(UpdateBase.class);
    private final UpdateSqlBuilder sqlBuilder;

    public UpdateBase(IConfig config, Class<?> target) {
        this.sqlBuilder = new UpdateSqlBuilder(config, target);
    }

    public UpdateBase(UpdateSqlBuilder sqlBuilder) {
        this.sqlBuilder = sqlBuilder;
    }

    protected UpdateSqlBuilder getSqlBuilder() {
        return this.sqlBuilder;
    }

    @Override
    protected IConfig getConfig() {
        return this.sqlBuilder.getConfig();
    }

    @Override
    public String toSql() {
        return this.sqlBuilder.getSql();
    }

    public long executeRows() {
        IConfig config = this.getConfig();
        this.checkHasWhere();
        ArrayList<Object> values = new ArrayList<Object>();
        String sql = this.sqlBuilder.getSqlAndValue(values);
        this.tryPrintSql(log, sql);
        SqlSession session = config.getSqlSessionFactory().getSession();
        return session.executeUpdate(sql, values);
    }

    private void checkHasWhere() {
        if (this.getConfig().isIgnoreUpdateNoWhere()) {
            return;
        }
        if (!this.sqlBuilder.hasWhere()) {
            throw new RuntimeException("UPDATE\u6ca1\u6709\u6761\u4ef6");
        }
    }

    protected void join(JoinType joinType, Class<?> target, ExprTree<?> expr) {
        SqlExpressionFactory factory = this.getConfig().getSqlExpressionFactory();
        NormalVisitor normalVisitor = new NormalVisitor(this.getConfig());
        Object on = normalVisitor.visit(expr.getTree());
        ISqlRealTableExpression table = factory.table(target);
        this.getSqlBuilder().addJoin(target, joinType, table, (ISqlExpression)on);
    }

    protected void set(LambdaExpression<?> lambda) {
        SetVisitor setVisitor = new SetVisitor(this.getConfig());
        Object expression = setVisitor.visit((LambdaExpression)lambda);
        if (expression instanceof ISqlSetsExpression) {
            ISqlSetsExpression sqlSetsExpression = (ISqlSetsExpression)expression;
            this.sqlBuilder.addSet(sqlSetsExpression);
        } else if (expression instanceof ISqlSetExpression) {
            ISqlSetExpression sqlSetExpression = (ISqlSetExpression)expression;
            this.sqlBuilder.addSet(sqlSetExpression);
        }
    }

    protected void where(LambdaExpression<?> lambda) {
        NormalVisitor normalVisitor = new NormalVisitor(this.getConfig());
        Object expression = normalVisitor.visit((LambdaExpression)lambda);
        this.sqlBuilder.addWhere((ISqlExpression)expression);
    }
}

