/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.core.visitor;

import io.github.kiryu1223.expressionTree.expressions.AssignExpression;
import io.github.kiryu1223.expressionTree.expressions.BinaryExpression;
import io.github.kiryu1223.expressionTree.expressions.ConditionalExpression;
import io.github.kiryu1223.expressionTree.expressions.ConstantExpression;
import io.github.kiryu1223.expressionTree.expressions.DeepFindVisitor;
import io.github.kiryu1223.expressionTree.expressions.Expression;
import io.github.kiryu1223.expressionTree.expressions.FieldSelectExpression;
import io.github.kiryu1223.expressionTree.expressions.LambdaExpression;
import io.github.kiryu1223.expressionTree.expressions.MethodCallExpression;
import io.github.kiryu1223.expressionTree.expressions.NewExpression;
import io.github.kiryu1223.expressionTree.expressions.ParameterExpression;
import io.github.kiryu1223.expressionTree.expressions.ParensExpression;
import io.github.kiryu1223.expressionTree.expressions.ReferenceExpression;
import io.github.kiryu1223.expressionTree.expressions.ResultThrowVisitor;
import io.github.kiryu1223.expressionTree.expressions.StaticClassExpression;
import io.github.kiryu1223.expressionTree.expressions.UnaryExpression;
import io.github.kiryu1223.expressionTree.expressions.Visitor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.math.BigDecimal;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.noear.solon.data.sqlink.base.DbType;
import org.noear.solon.data.sqlink.base.IConfig;
import org.noear.solon.data.sqlink.base.expression.ISqlColumnExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlValueExpression;
import org.noear.solon.data.sqlink.base.expression.SqlExpressionFactory;
import org.noear.solon.data.sqlink.base.expression.SqlOperator;
import org.noear.solon.data.sqlink.base.metaData.MetaData;
import org.noear.solon.data.sqlink.base.metaData.MetaDataCache;
import org.noear.solon.data.sqlink.base.sqlExt.BaseSqlExtension;
import org.noear.solon.data.sqlink.base.sqlExt.SqlExtensionExpression;
import org.noear.solon.data.sqlink.base.sqlExt.SqlOperatorMethod;
import org.noear.solon.data.sqlink.core.api.crud.read.group.IAggregation;
import org.noear.solon.data.sqlink.core.exception.IllegalExpressionException;
import org.noear.solon.data.sqlink.core.exception.SQLinkException;
import org.noear.solon.data.sqlink.core.exception.SqlFuncExtNotFoundException;
import org.noear.solon.data.sqlink.core.visitor.ExpressionUtil;
import org.noear.solon.data.sqlink.core.visitor.ParamMatcher;
import org.noear.solon.data.sqlink.core.visitor.methods.BigDecimalMethods;
import org.noear.solon.data.sqlink.core.visitor.methods.LogicExpression;
import org.noear.solon.data.sqlink.core.visitor.methods.MathMethods;
import org.noear.solon.data.sqlink.core.visitor.methods.StringMethods;
import org.noear.solon.data.sqlink.core.visitor.methods.TemporalMethods;

public abstract class SqlVisitor
extends ResultThrowVisitor<ISqlExpression> {
    protected List<ParameterExpression> parameters;
    protected final IConfig config;
    protected final int offset;
    protected final SqlExpressionFactory factory;

    protected SqlVisitor(IConfig config) {
        this(config, 0);
    }

    public SqlVisitor(IConfig config, int offset) {
        this.config = config;
        this.offset = offset;
        this.factory = config.getSqlExpressionFactory();
    }

    public ISqlExpression visit(LambdaExpression<?> lambda) {
        if (this.parameters == null) {
            this.parameters = lambda.getParameters();
            return (ISqlExpression)this.visit(lambda.getBody());
        }
        SqlVisitor self = this.getSelf();
        return self.visit((LambdaExpression)lambda);
    }

    public ISqlExpression visit(AssignExpression assignExpression) {
        ISqlExpression left = (ISqlExpression)this.visit(assignExpression.getLeft());
        if (left instanceof ISqlColumnExpression) {
            ISqlColumnExpression sqlColumnExpression = (ISqlColumnExpression)left;
            ISqlExpression right = (ISqlExpression)this.visit(assignExpression.getRight());
            return this.factory.set(sqlColumnExpression, right);
        }
        throw new SQLinkException("\u8868\u8fbe\u5f0f\u4e2d\u4e0d\u80fd\u51fa\u73b0\u975elambda\u5165\u53c2\u4e3a\u8d4b\u503c\u5bf9\u8c61\u7684\u8bed\u53e5");
    }

    public ISqlExpression visit(FieldSelectExpression fieldSelect) {
        if (ExpressionUtil.isProperty(this.parameters, fieldSelect)) {
            ParameterExpression parameter = (ParameterExpression)fieldSelect.getExpr();
            int index = this.parameters.indexOf(parameter) + this.offset;
            Field field = fieldSelect.getField();
            MetaData metaData = MetaDataCache.getMetaData(field.getDeclaringClass());
            return this.factory.column(metaData.getPropertyMetaDataByFieldName(field.getName()), index);
        }
        return this.checkAndReturnValue(fieldSelect);
    }

    public ISqlExpression visit(MethodCallExpression methodCall) {
        if (IAggregation.class.isAssignableFrom(methodCall.getMethod().getDeclaringClass())) {
            String name;
            switch (name = methodCall.getMethod().getName()) {
                case "count": {
                    if (methodCall.getMethod().getParameterCount() == 0) {
                        return this.factory.template(Collections.singletonList("COUNT(*)"), Collections.emptyList());
                    }
                }
                case "sum": 
                case "avg": 
                case "max": 
                case "min": {
                    ArrayList<Object> args = new ArrayList<Object>(methodCall.getArgs().size());
                    for (Expression arg : methodCall.getArgs()) {
                        args.add(this.visit(arg));
                    }
                    ArrayList<String> strings = new ArrayList<String>(args.size() + 1);
                    strings.add(name.toUpperCase() + "(");
                    for (int i = 0; i < args.size() - 1; ++i) {
                        strings.add(",");
                    }
                    strings.add(")");
                    return this.factory.template(strings, args);
                }
            }
            throw new IllegalExpressionException((Expression)methodCall);
        }
        if (ExpressionUtil.isSqlExtensionExpressionMethod(methodCall.getMethod())) {
            Method sqlFunction = methodCall.getMethod();
            SqlExtensionExpression sqlFuncExt = this.getSqlFuncExt((SqlExtensionExpression[])sqlFunction.getAnnotationsByType(SqlExtensionExpression.class));
            List args = methodCall.getArgs();
            ArrayList<ISqlExpression> expressions = new ArrayList<ISqlExpression>(args.size());
            if (sqlFuncExt.extension() != BaseSqlExtension.class) {
                for (Expression arg : args) {
                    expressions.add((ISqlExpression)this.visit(arg));
                }
                BaseSqlExtension sqlExtension = BaseSqlExtension.getCache(sqlFuncExt.extension());
                return sqlExtension.parse(this.config, sqlFunction, expressions);
            }
            ArrayList<String> strings = new ArrayList<String>();
            List methodParameters = Arrays.stream(methodCall.getMethod().getParameters()).collect(Collectors.toList());
            ParamMatcher match = this.match(sqlFuncExt.template());
            List<String> functions = match.remainder;
            List<String> params = match.bracesContent;
            for (int i = 0; i < functions.size(); ++i) {
                int index;
                strings.add(functions.get(i));
                if (i >= params.size()) continue;
                String param = params.get(i);
                Parameter targetParam = methodParameters.stream().filter(f -> f.getName().equals(param)).findFirst().orElseThrow(() -> new SQLinkException("\u65e0\u6cd5\u5728" + sqlFuncExt.template() + "\u4e2d\u627e\u5230" + param));
                if (targetParam.isVarArgs()) {
                    for (index = methodParameters.indexOf(targetParam); index < args.size(); ++index) {
                        expressions.add((ISqlExpression)this.visit((Expression)args.get(index)));
                        if (index >= args.size() - 1) continue;
                        strings.add(sqlFuncExt.separator());
                    }
                    continue;
                }
                expressions.add((ISqlExpression)this.visit((Expression)args.get(index)));
            }
            return this.factory.template(strings, expressions);
        }
        if (List.class.isAssignableFrom(methodCall.getMethod().getDeclaringClass())) {
            Method method = methodCall.getMethod();
            if (method.getName().equals("contains")) {
                ISqlExpression left = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                ISqlExpression right = (ISqlExpression)this.visit(methodCall.getExpr());
                return this.factory.binary(SqlOperator.IN, left, right);
            }
            return this.checkAndReturnValue(methodCall);
        }
        if (String.class.isAssignableFrom(methodCall.getMethod().getDeclaringClass())) {
            Method method = methodCall.getMethod();
            if (Modifier.isStatic(method.getModifiers())) {
                switch (method.getName()) {
                    case "join": {
                        ISqlExpression delimiter = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                        if (method.isVarArgs()) {
                            ArrayList<ISqlExpression> args = new ArrayList<ISqlExpression>(methodCall.getArgs().size() - 1);
                            for (int i = 1; i < methodCall.getArgs().size(); ++i) {
                                args.add((ISqlExpression)this.visit((Expression)methodCall.getArgs().get(i)));
                            }
                            return StringMethods.joinArray(this.config, delimiter, args);
                        }
                        ISqlExpression elements = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(1));
                        return StringMethods.joinList(this.config, delimiter, elements);
                    }
                }
                return this.checkAndReturnValue(methodCall);
            }
            switch (method.getName()) {
                case "contains": {
                    ISqlExpression left = (ISqlExpression)this.visit(methodCall.getExpr());
                    ISqlExpression right = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                    return StringMethods.contains(this.config, left, right);
                }
                case "startsWith": {
                    ISqlExpression left = (ISqlExpression)this.visit(methodCall.getExpr());
                    ISqlExpression right = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                    return StringMethods.startsWith(this.config, left, right);
                }
                case "endsWith": {
                    ISqlExpression left = (ISqlExpression)this.visit(methodCall.getExpr());
                    ISqlExpression right = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                    return StringMethods.endsWith(this.config, left, right);
                }
                case "length": {
                    ISqlExpression left = (ISqlExpression)this.visit(methodCall.getExpr());
                    return StringMethods.length(this.config, left);
                }
                case "toUpperCase": {
                    ISqlExpression left = (ISqlExpression)this.visit(methodCall.getExpr());
                    return StringMethods.toUpperCase(this.config, left);
                }
                case "toLowerCase": {
                    ISqlExpression left = (ISqlExpression)this.visit(methodCall.getExpr());
                    return StringMethods.toLowerCase(this.config, left);
                }
                case "concat": {
                    ISqlExpression left = (ISqlExpression)this.visit(methodCall.getExpr());
                    ISqlExpression right = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                    return StringMethods.concat(this.config, left, right);
                }
                case "trim": {
                    ISqlExpression left = (ISqlExpression)this.visit(methodCall.getExpr());
                    return StringMethods.trim(this.config, left);
                }
                case "isEmpty": {
                    ISqlExpression left = (ISqlExpression)this.visit(methodCall.getExpr());
                    return StringMethods.isEmpty(this.config, left);
                }
                case "indexOf": {
                    if (method.getParameterTypes()[0] == String.class) {
                        ISqlExpression thisStr = (ISqlExpression)this.visit(methodCall.getExpr());
                        ISqlExpression subStr = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                        if (method.getParameterCount() == 1) {
                            return StringMethods.indexOf(this.config, thisStr, subStr);
                        }
                        ISqlExpression fromIndex = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(1));
                        return StringMethods.indexOf(this.config, thisStr, subStr, fromIndex);
                    }
                }
                case "replace": {
                    ISqlExpression thisStr = (ISqlExpression)this.visit(methodCall.getExpr());
                    ISqlExpression oldStr = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                    ISqlExpression newStr = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(1));
                    return StringMethods.replace(this.config, thisStr, oldStr, newStr);
                }
                case "substring": {
                    ISqlExpression thisStr = (ISqlExpression)this.visit(methodCall.getExpr());
                    ISqlExpression beginIndex = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                    if (method.getParameterCount() == 1) {
                        return StringMethods.substring(this.config, thisStr, beginIndex);
                    }
                    ISqlExpression endIndex = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(1));
                    return StringMethods.substring(this.config, thisStr, beginIndex, endIndex);
                }
            }
            return this.checkAndReturnValue(methodCall);
        }
        if (Math.class.isAssignableFrom(methodCall.getMethod().getDeclaringClass())) {
            Method method = methodCall.getMethod();
            switch (method.getName()) {
                case "abs": {
                    ISqlExpression arg = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                    return this.factory.template(Arrays.asList("ABS(", ")"), Collections.singletonList(arg));
                }
                case "cos": {
                    ISqlExpression arg = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                    return this.factory.template(Arrays.asList("COS(", ")"), Collections.singletonList(arg));
                }
                case "acos": {
                    ISqlExpression arg = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                    return this.factory.template(Arrays.asList("ACOS(", ")"), Collections.singletonList(arg));
                }
                case "sin": {
                    ISqlExpression arg = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                    return this.factory.template(Arrays.asList("SIN(", ")"), Collections.singletonList(arg));
                }
                case "asin": {
                    ISqlExpression arg = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                    return this.factory.template(Arrays.asList("ASIN(", ")"), Collections.singletonList(arg));
                }
                case "tan": {
                    ISqlExpression arg = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                    return this.factory.template(Arrays.asList("TAN(", ")"), Collections.singletonList(arg));
                }
                case "atan": {
                    ISqlExpression arg = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                    return this.factory.template(Arrays.asList("ATAN(", ")"), Collections.singletonList(arg));
                }
                case "atan2": {
                    ISqlExpression arg1 = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                    ISqlExpression arg2 = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(1));
                    return MathMethods.atan2(this.config, arg1, arg2);
                }
                case "toDegrees": {
                    ISqlExpression arg = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                    return MathMethods.toDegrees(this.config, arg);
                }
                case "toRadians": {
                    ISqlExpression arg = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                    return MathMethods.toRadians(this.config, arg);
                }
                case "exp": {
                    ISqlExpression arg = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                    return this.factory.template(Arrays.asList("EXP(", ")"), Collections.singletonList(arg));
                }
                case "floor": {
                    ISqlExpression arg = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                    return this.factory.template(Arrays.asList("FLOOR(", ")"), Collections.singletonList(arg));
                }
                case "log": {
                    ISqlExpression arg = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                    return MathMethods.log(this.config, arg);
                }
                case "log10": {
                    ISqlExpression arg = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                    return MathMethods.log10(this.config, arg);
                }
                case "random": {
                    return MathMethods.random(this.config);
                }
                case "round": {
                    ISqlExpression arg = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                    return MathMethods.round(this.config, arg);
                }
                case "pow": {
                    ISqlExpression arg1 = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                    ISqlExpression arg2 = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(1));
                    return this.factory.template(Arrays.asList("POWER(", ",", ")"), Arrays.asList(arg1, arg2));
                }
                case "signum": {
                    ISqlExpression arg = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                    return this.factory.template(Arrays.asList("SIGN(", ")"), Collections.singletonList(arg));
                }
                case "sqrt": {
                    ISqlExpression arg = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                    return this.factory.template(Arrays.asList("SQRT(", ")"), Collections.singletonList(arg));
                }
            }
            return this.checkAndReturnValue(methodCall);
        }
        if (BigDecimal.class.isAssignableFrom(methodCall.getMethod().getDeclaringClass())) {
            Method method = methodCall.getMethod();
            switch (method.getName()) {
                case "add": {
                    if (method.getParameterCount() == 1) {
                        ISqlExpression left = (ISqlExpression)this.visit(methodCall.getExpr());
                        ISqlExpression right = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                        return this.factory.binary(SqlOperator.PLUS, left, right);
                    }
                }
                case "subtract": {
                    if (method.getParameterCount() == 1) {
                        ISqlExpression left = (ISqlExpression)this.visit(methodCall.getExpr());
                        ISqlExpression right = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                        return this.factory.binary(SqlOperator.MINUS, left, right);
                    }
                }
                case "multiply": {
                    if (method.getParameterCount() == 1) {
                        ISqlExpression left = (ISqlExpression)this.visit(methodCall.getExpr());
                        ISqlExpression right = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                        return this.factory.binary(SqlOperator.MUL, left, right);
                    }
                }
                case "divide": {
                    if (method.getParameterCount() == 1) {
                        ISqlExpression left = (ISqlExpression)this.visit(methodCall.getExpr());
                        ISqlExpression right = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                        return this.factory.binary(SqlOperator.DIV, left, right);
                    }
                }
                case "remainder": {
                    if (method.getParameterCount() != 1) break;
                    ISqlExpression left = (ISqlExpression)this.visit(methodCall.getExpr());
                    ISqlExpression right = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                    return BigDecimalMethods.remainder(this.config, left, right);
                }
            }
            return this.checkAndReturnValue(methodCall);
        }
        if (Temporal.class.isAssignableFrom(methodCall.getMethod().getDeclaringClass())) {
            Method method = methodCall.getMethod();
            switch (method.getName()) {
                case "isAfter": {
                    ISqlExpression left = (ISqlExpression)this.visit(methodCall.getExpr());
                    ISqlExpression right = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                    return TemporalMethods.isAfter(this.config, left, right);
                }
                case "isBefore": {
                    ISqlExpression left = (ISqlExpression)this.visit(methodCall.getExpr());
                    ISqlExpression right = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                    return TemporalMethods.isBefore(this.config, left, right);
                }
                case "isEqual": {
                    ISqlExpression left = (ISqlExpression)this.visit(methodCall.getExpr());
                    ISqlExpression right = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                    return TemporalMethods.isEqual(this.config, left, right);
                }
            }
            return this.checkAndReturnValue(methodCall);
        }
        if (ExpressionUtil.isSqlOperatorMethod(methodCall.getMethod())) {
            Method method = methodCall.getMethod();
            List args = methodCall.getArgs();
            SqlOperatorMethod operatorMethod = method.getAnnotation(SqlOperatorMethod.class);
            SqlOperator operator = operatorMethod.value();
            if (operator == SqlOperator.BETWEEN) {
                ISqlExpression thiz = (ISqlExpression)this.visit((Expression)args.get(0));
                ISqlExpression min = (ISqlExpression)this.visit((Expression)args.get(1));
                ISqlExpression max = (ISqlExpression)this.visit((Expression)args.get(2));
                return this.factory.binary(SqlOperator.BETWEEN, thiz, this.factory.binary(SqlOperator.AND, min, max));
            }
            if (operator.isLeft() || operator == SqlOperator.POSTINC || operator == SqlOperator.POSTDEC) {
                return this.factory.unary(operator, (ISqlExpression)this.visit((Expression)args.get(0)));
            }
            ISqlExpression left = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
            ISqlExpression right = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(1));
            return this.factory.binary(operator, left, right);
        }
        if (ExpressionUtil.isProperty(this.parameters, methodCall)) {
            if (ExpressionUtil.isGetter(methodCall.getMethod())) {
                ParameterExpression parameter = (ParameterExpression)methodCall.getExpr();
                int index = this.parameters.indexOf(parameter) + this.offset;
                Method getter = methodCall.getMethod();
                MetaData metaData = MetaDataCache.getMetaData(getter.getDeclaringClass());
                return this.factory.column(metaData.getPropertyMetaDataByGetter(getter), index);
            }
            if (ExpressionUtil.isSetter(methodCall.getMethod())) {
                ParameterExpression parameter = (ParameterExpression)methodCall.getExpr();
                int index = this.parameters.indexOf(parameter) + this.offset;
                Method setter = methodCall.getMethod();
                MetaData metaData = MetaDataCache.getMetaData(setter.getDeclaringClass());
                ISqlColumnExpression columnExpression = this.factory.column(metaData.getPropertyMetaDataBySetter(setter), index);
                ISqlExpression value = (ISqlExpression)this.visit((Expression)methodCall.getArgs().get(0));
                return this.factory.set(columnExpression, value);
            }
            return this.checkAndReturnValue(methodCall);
        }
        return this.checkAndReturnValue(methodCall);
    }

    public ISqlExpression visit(BinaryExpression binary) {
        Expression left = binary.getLeft();
        Expression right = binary.getRight();
        return this.factory.binary(SqlOperator.valueOf(binary.getOperatorType().name()), (ISqlExpression)this.visit(left), (ISqlExpression)this.visit(right));
    }

    public ISqlExpression visit(UnaryExpression unary) {
        return this.factory.unary(SqlOperator.valueOf(unary.getOperatorType().name()), (ISqlExpression)this.visit(unary.getOperand()));
    }

    public ISqlExpression visit(ConditionalExpression conditional) {
        ISqlExpression cond = (ISqlExpression)this.visit(conditional.getCondition());
        ISqlExpression truePart = (ISqlExpression)this.visit(conditional.getTruePart());
        ISqlExpression falsePart = (ISqlExpression)this.visit(conditional.getFalsePart());
        return LogicExpression.IfExpression(this.config, cond, truePart, falsePart);
    }

    public ISqlExpression visit(ParensExpression parens) {
        return this.factory.parens((ISqlExpression)this.visit(parens.getExpr()));
    }

    public ISqlExpression visit(StaticClassExpression staticClass) {
        return this.factory.type(staticClass.getType());
    }

    public ISqlExpression visit(ConstantExpression constant) {
        return this.factory.value(constant.getValue());
    }

    public ISqlExpression visit(ReferenceExpression reference) {
        return this.factory.AnyValue(reference.getValue());
    }

    public ISqlExpression visit(NewExpression newExpression) {
        return this.checkAndReturnValue(newExpression);
    }

    protected abstract SqlVisitor getSelf();

    protected ISqlValueExpression checkAndReturnValue(MethodCallExpression expression) {
        Method method = expression.getMethod();
        if (ExpressionUtil.isVoid(method.getReturnType()) || this.hasParameter((Expression)expression)) {
            throw new IllegalExpressionException((Expression)expression);
        }
        return this.factory.AnyValue(expression.getValue());
    }

    protected ISqlValueExpression checkAndReturnValue(FieldSelectExpression expression) {
        if (this.hasParameter((Expression)expression)) {
            throw new IllegalExpressionException((Expression)expression);
        }
        return this.factory.AnyValue(expression.getValue());
    }

    protected ISqlValueExpression checkAndReturnValue(NewExpression expression) {
        if (this.hasParameter((Expression)expression)) {
            throw new IllegalExpressionException((Expression)expression);
        }
        return this.factory.AnyValue(expression.getValue());
    }

    protected boolean hasParameter(Expression expression) {
        final AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        expression.accept((Visitor)new DeepFindVisitor(){

            public void visit(ParameterExpression parameterExpression) {
                atomicBoolean.set(true);
            }
        });
        return atomicBoolean.get();
    }

    protected SqlExtensionExpression getSqlFuncExt(SqlExtensionExpression[] sqlExtensionExpressions) {
        DbType dbType = this.config.getDbType();
        Optional<SqlExtensionExpression> first = Arrays.stream(sqlExtensionExpressions).filter(a -> a.dbType() == dbType).findFirst();
        if (!first.isPresent()) {
            Optional<SqlExtensionExpression> any = Arrays.stream(sqlExtensionExpressions).filter(a -> a.dbType() == DbType.Any).findFirst();
            if (any.isPresent()) {
                return any.get();
            }
            throw new SqlFuncExtNotFoundException(dbType);
        }
        return first.get();
    }

    protected ParamMatcher match(String input) {
        ParamMatcher paramMatcher = new ParamMatcher();
        List<String> bracesContent = paramMatcher.bracesContent;
        List<String> remainder = paramMatcher.remainder;
        Pattern pattern = Pattern.compile("\\{([^}]+)}");
        Matcher matcher = pattern.matcher(input);
        int lastIndex = 0;
        while (matcher.find()) {
            if (lastIndex < matcher.start()) {
                remainder.add(input.substring(lastIndex, matcher.start()));
            }
            bracesContent.add(matcher.group(1));
            lastIndex = matcher.end();
        }
        if (lastIndex < input.length()) {
            remainder.add(input.substring(lastIndex));
        }
        if (input.startsWith("{")) {
            remainder.add(0, "");
        }
        if (input.endsWith("}")) {
            remainder.add("");
        }
        return paramMatcher;
    }
}

