/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.core.expression.oracle;

import java.util.ArrayList;
import java.util.List;
import org.noear.solon.data.sqlink.base.DbType;
import org.noear.solon.data.sqlink.base.IConfig;
import org.noear.solon.data.sqlink.base.expression.ISqlFromExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlGroupByExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlHavingExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlJoinsExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlLimitExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlOrderByExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlSelectExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlWhereExpression;
import org.noear.solon.data.sqlink.base.expression.SqlExpressionFactory;
import org.noear.solon.data.sqlink.base.expression.impl.SqlQueryableExpression;
import org.noear.solon.data.sqlink.base.metaData.MetaData;
import org.noear.solon.data.sqlink.base.metaData.MetaDataCache;
import org.noear.solon.data.sqlink.base.metaData.PropertyMetaData;
import org.noear.solon.data.sqlink.core.exception.SQLinkLimitNotFoundOrderByException;

public class OracleQueryableExpression
extends SqlQueryableExpression {
    public OracleQueryableExpression(ISqlSelectExpression select, ISqlFromExpression from, ISqlJoinsExpression joins, ISqlWhereExpression where, ISqlGroupByExpression groupBy, ISqlHavingExpression having, ISqlOrderByExpression orderBy, ISqlLimitExpression limit) {
        super(select, from, joins, where, groupBy, having, orderBy, limit);
    }

    @Override
    public String getSqlAndValue(IConfig config, List<Object> values) {
        String orderBySqlAndValue;
        String havingSqlAndValue;
        String groupBySqlAndValue;
        String whereSqlAndValue;
        String joinsSqlAndValue;
        ArrayList<String> strings = new ArrayList<String>();
        strings.add(this.select.getSqlAndValue(config, values));
        String fromSqlAndValue = this.from.getSqlAndValue(config, values);
        if (!fromSqlAndValue.isEmpty()) {
            strings.add(fromSqlAndValue);
        }
        if (!(joinsSqlAndValue = this.joins.getSqlAndValue(config, values)).isEmpty()) {
            strings.add(joinsSqlAndValue);
        }
        if (!(whereSqlAndValue = this.where.getSqlAndValue(config, values)).isEmpty()) {
            strings.add(whereSqlAndValue);
        }
        if (!(groupBySqlAndValue = this.groupBy.getSqlAndValue(config, values)).isEmpty()) {
            strings.add(groupBySqlAndValue);
        }
        if (!(havingSqlAndValue = this.having.getSqlAndValue(config, values)).isEmpty()) {
            strings.add(havingSqlAndValue);
        }
        if (!(orderBySqlAndValue = this.orderBy.getSqlAndValue(config, values)).isEmpty()) {
            strings.add(orderBySqlAndValue);
        }
        if (!this.from.isEmptyTable()) {
            this.limitAndOrderCheck(strings, values, config);
            String limitSqlAndValue = this.limit.getSqlAndValue(config, values);
            if (!limitSqlAndValue.isEmpty()) {
                strings.add(limitSqlAndValue);
            }
        }
        return String.join((CharSequence)" ", strings);
    }

    private void limitAndOrderCheck(List<String> strings, List<Object> values, IConfig config) {
        if (this.limit.hasRowsOrOffset() && this.orderBy.isEmpty()) {
            MetaData metaData = MetaDataCache.getMetaData(this.from.getSqlTableExpression().getTableClass());
            PropertyMetaData primary = metaData.getPrimary();
            if (primary == null) {
                throw new SQLinkLimitNotFoundOrderByException(DbType.Oracle);
            }
            SqlExpressionFactory factory = config.getSqlExpressionFactory();
            ISqlOrderByExpression sqlOrderByExpression = factory.orderBy();
            sqlOrderByExpression.addOrder(factory.order(factory.column(primary)));
            strings.add(sqlOrderByExpression.getSqlAndValue(config, values));
        }
    }
}

