/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.base.toBean.Include;

import com.sun.jmx.mbeanserver.Util;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.noear.solon.data.sqlink.base.IConfig;
import org.noear.solon.data.sqlink.base.expression.ISqlBinaryExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlColumnExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlConstStringExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlLimitExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlOrderByExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlQueryableExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlWhereExpression;
import org.noear.solon.data.sqlink.base.expression.JoinType;
import org.noear.solon.data.sqlink.base.expression.SqlExpressionFactory;
import org.noear.solon.data.sqlink.base.expression.SqlOperator;
import org.noear.solon.data.sqlink.base.metaData.IMappingTable;
import org.noear.solon.data.sqlink.base.metaData.MetaData;
import org.noear.solon.data.sqlink.base.metaData.MetaDataCache;
import org.noear.solon.data.sqlink.base.metaData.NavigateData;
import org.noear.solon.data.sqlink.base.metaData.PropertyMetaData;
import org.noear.solon.data.sqlink.base.session.SqlSession;
import org.noear.solon.data.sqlink.base.toBean.Include.IncludeFactory;
import org.noear.solon.data.sqlink.base.toBean.Include.IncludeSet;
import org.noear.solon.data.sqlink.base.toBean.build.ObjectBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncludeBuilder<T> {
    protected static final Logger log = LoggerFactory.getLogger(IncludeBuilder.class);
    protected final IConfig config;
    protected final Class<T> targetClass;
    protected final Collection<T> sources;
    protected final List<IncludeSet> includes;
    protected final ISqlQueryableExpression queryable;
    protected final SqlExpressionFactory factory;
    protected final SqlSession session;

    public IncludeBuilder(IConfig config, SqlSession session, Class<T> targetClass, Collection<T> sources, List<IncludeSet> includes, ISqlQueryableExpression queryable) {
        this.config = config;
        this.targetClass = targetClass;
        this.sources = sources;
        this.includes = includes;
        this.queryable = queryable;
        this.factory = config.getSqlExpressionFactory();
        this.session = session;
    }

    public void include() throws InvocationTargetException, IllegalAccessException {
        MetaData targetClassMetaData = MetaDataCache.getMetaData(this.targetClass);
        HashMap<PropertyMetaData, Map<Object, List<T>>> cache = new HashMap<PropertyMetaData, Map<Object, List<T>>>();
        for (IncludeSet include : this.includes) {
            NavigateData navigateData = include.getColumnExpression().getPropertyMetaData().getNavigateData();
            Class<?> navigateTargetType = navigateData.getNavigateTargetType();
            PropertyMetaData selfPropertyMetaData = targetClassMetaData.getPropertyMetaDataByFieldName(navigateData.getSelfPropertyName());
            PropertyMetaData targetPropertyMetaData = MetaDataCache.getMetaData(navigateTargetType).getPropertyMetaDataByFieldName(navigateData.getTargetPropertyName());
            PropertyMetaData includePropertyMetaData = include.getColumnExpression().getPropertyMetaData();
            Map<Object, List<T>> sourcesMapList = (Map<Object, List<T>>)cache.get(selfPropertyMetaData);
            if (sourcesMapList == null) {
                sourcesMapList = this.getMapList(selfPropertyMetaData);
                cache.put(selfPropertyMetaData, sourcesMapList);
            }
            switch (navigateData.getRelationType()) {
                case OneToOne: {
                    this.oneToOne(sourcesMapList, include, navigateData, selfPropertyMetaData, targetPropertyMetaData, includePropertyMetaData);
                    break;
                }
                case OneToMany: {
                    this.oneToMany(sourcesMapList, include, navigateData, selfPropertyMetaData, targetPropertyMetaData, includePropertyMetaData);
                    break;
                }
                case ManyToOne: {
                    this.manyToOne(sourcesMapList, include, navigateData, selfPropertyMetaData, targetPropertyMetaData, includePropertyMetaData);
                    break;
                }
                case ManyToMany: {
                    this.manyToMany(sourcesMapList, include, navigateData, selfPropertyMetaData, targetPropertyMetaData, includePropertyMetaData);
                }
            }
        }
    }

    protected void oneToOne(Map<Object, List<T>> sourcesMapList, IncludeSet include, NavigateData navigateData, PropertyMetaData selfPropertyMetaData, PropertyMetaData targetPropertyMetaData, PropertyMetaData includePropertyMetaData) throws InvocationTargetException, IllegalAccessException {
        Class<?> navigateTargetType = navigateData.getNavigateTargetType();
        ISqlQueryableExpression tempQueryable = this.factory.queryable(navigateTargetType);
        ISqlQueryableExpression warpQueryable = this.factory.queryable(this.queryable);
        warpQueryable.setSelect(this.factory.select(Collections.singletonList(this.factory.column(selfPropertyMetaData, 0)), selfPropertyMetaData.getType(), true, false));
        tempQueryable.addWhere(this.factory.binary(SqlOperator.IN, this.factory.column(targetPropertyMetaData, 0), warpQueryable));
        if (include.hasCond()) {
            ISqlExpression cond = include.getCond();
            if (cond instanceof ISqlQueryableExpression) {
                ISqlQueryableExpression queryableExpression = (ISqlQueryableExpression)cond;
                tempQueryable = this.warpItQueryable(tempQueryable, targetPropertyMetaData, navigateTargetType, queryableExpression);
            } else {
                tempQueryable.addWhere(this.factory.parens(cond));
            }
        }
        ArrayList<Object> values = new ArrayList<Object>();
        String sql = tempQueryable.getSqlAndValue(this.config, values);
        this.tryPrint(sql);
        List<PropertyMetaData> mappingData = tempQueryable.getMappingData(this.config);
        Map objectMap = this.session.executeQuery(r -> ObjectBuilder.start(r, (Class)Util.cast(navigateTargetType), mappingData, false, this.config).createMap(targetPropertyMetaData.getColumn()), sql, values);
        for (Map.Entry objectEntry : objectMap.entrySet()) {
            Object key = objectEntry.getKey();
            Object value = objectEntry.getValue();
            for (T t : sourcesMapList.get(key)) {
                includePropertyMetaData.getSetter().invoke(t, value);
            }
        }
        this.round(include, navigateTargetType, objectMap.values(), tempQueryable, new Object[0]);
    }

    protected void oneToMany(Map<Object, List<T>> sourcesMapList, IncludeSet include, NavigateData navigateData, PropertyMetaData selfPropertyMetaData, PropertyMetaData targetPropertyMetaData, PropertyMetaData includePropertyMetaData) throws InvocationTargetException, IllegalAccessException {
        Class<?> navigateTargetType = navigateData.getNavigateTargetType();
        ISqlQueryableExpression tempQueryable = this.factory.queryable(navigateTargetType);
        ISqlQueryableExpression warpQueryable = this.factory.queryable(this.queryable);
        warpQueryable.setSelect(this.factory.select(Collections.singletonList(this.factory.column(selfPropertyMetaData, 0)), selfPropertyMetaData.getType(), true, false));
        tempQueryable.addWhere(this.factory.binary(SqlOperator.IN, this.factory.column(targetPropertyMetaData, 0), warpQueryable));
        if (include.hasCond()) {
            ISqlExpression cond = include.getCond();
            if (cond instanceof ISqlQueryableExpression) {
                ISqlQueryableExpression queryableExpression = (ISqlQueryableExpression)cond;
                tempQueryable = this.warpItQueryable(tempQueryable, targetPropertyMetaData, navigateTargetType, queryableExpression);
            } else {
                tempQueryable.addWhere(this.factory.parens(cond));
            }
        }
        ArrayList<Object> values = new ArrayList<Object>();
        String sql = tempQueryable.getSqlAndValue(this.config, values);
        this.tryPrint(sql);
        List<PropertyMetaData> mappingData = tempQueryable.getMappingData(this.config);
        Map targetMap = this.session.executeQuery(r -> ObjectBuilder.start(r, (Class)Util.cast(navigateTargetType), mappingData, false, this.config).createMapList(targetPropertyMetaData.getColumn()), sql, values);
        boolean isSet = Set.class.isAssignableFrom(navigateData.getCollectionWrapperType());
        for (Map.Entry objectListEntry : targetMap.entrySet()) {
            Object key = objectListEntry.getKey();
            List value = (List)objectListEntry.getValue();
            for (T t : sourcesMapList.get(key)) {
                if (isSet) {
                    includePropertyMetaData.getSetter().invoke(t, new HashSet(value));
                    continue;
                }
                includePropertyMetaData.getSetter().invoke(t, value);
            }
        }
        this.round(include, navigateTargetType, targetMap.values(), tempQueryable);
    }

    protected void manyToOne(Map<Object, List<T>> sourcesMapList, IncludeSet include, NavigateData navigateData, PropertyMetaData selfPropertyMetaData, PropertyMetaData targetPropertyMetaData, PropertyMetaData includePropertyMetaData) throws InvocationTargetException, IllegalAccessException {
        Class<?> navigateTargetType = navigateData.getNavigateTargetType();
        ISqlQueryableExpression tempQueryable = this.factory.queryable(navigateTargetType);
        ISqlQueryableExpression warpQueryable = this.factory.queryable(this.queryable);
        warpQueryable.setSelect(this.factory.select(Collections.singletonList(this.factory.column(selfPropertyMetaData, 0)), selfPropertyMetaData.getType(), true, false));
        tempQueryable.addWhere(this.factory.binary(SqlOperator.IN, this.factory.column(targetPropertyMetaData, 0), warpQueryable));
        if (include.hasCond()) {
            ISqlExpression cond = include.getCond();
            if (cond instanceof ISqlQueryableExpression) {
                ISqlQueryableExpression queryableExpression = (ISqlQueryableExpression)cond;
                tempQueryable = this.warpItQueryable(tempQueryable, targetPropertyMetaData, navigateTargetType, queryableExpression);
            } else {
                tempQueryable.addWhere(this.factory.parens(cond));
            }
        }
        ArrayList<Object> values = new ArrayList<Object>();
        String sql = tempQueryable.getSqlAndValue(this.config, values);
        this.tryPrint(sql);
        List<PropertyMetaData> mappingData = tempQueryable.getMappingData(this.config);
        Map objectMap = this.session.executeQuery(r -> ObjectBuilder.start(r, (Class)Util.cast(navigateTargetType), mappingData, false, this.config).createMap(targetPropertyMetaData.getColumn()), sql, values);
        for (Map.Entry objectEntry : objectMap.entrySet()) {
            Object key = objectEntry.getKey();
            Object value = objectEntry.getValue();
            List<T> ts = sourcesMapList.get(key);
            for (T t : ts) {
                includePropertyMetaData.getSetter().invoke(t, value);
            }
        }
        this.round(include, navigateTargetType, objectMap.values(), tempQueryable, new Object[0]);
    }

    protected void manyToMany(Map<Object, List<T>> sourcesMapList, IncludeSet include, NavigateData navigateData, PropertyMetaData selfPropertyMetaData, PropertyMetaData targetPropertyMetaData, PropertyMetaData includePropertyMetaData) throws InvocationTargetException, IllegalAccessException {
        Class<?> navigateTargetType = navigateData.getNavigateTargetType();
        Class<? extends IMappingTable> mappingTableType = navigateData.getMappingTableType();
        MetaData mappingTableMetadata = MetaDataCache.getMetaData(mappingTableType);
        String selfMappingPropertyName = navigateData.getSelfMappingPropertyName();
        PropertyMetaData selfMappingPropertyMetaData = mappingTableMetadata.getPropertyMetaDataByFieldName(selfMappingPropertyName);
        String targetMappingPropertyName = navigateData.getTargetMappingPropertyName();
        PropertyMetaData targetMappingPropertyMetaData = mappingTableMetadata.getPropertyMetaDataByFieldName(targetMappingPropertyName);
        ISqlQueryableExpression tempQueryable = this.factory.queryable(navigateTargetType);
        tempQueryable.addJoin(this.factory.join(JoinType.LEFT, this.factory.table(mappingTableType), this.factory.binary(SqlOperator.EQ, this.factory.column(targetPropertyMetaData, 0), this.factory.column(targetMappingPropertyMetaData, 1)), 1));
        ISqlQueryableExpression warpQueryable = this.factory.queryable(this.queryable);
        warpQueryable.setSelect(this.factory.select(Collections.singletonList(this.factory.column(selfPropertyMetaData, 0)), selfPropertyMetaData.getType(), true, false));
        tempQueryable.addWhere(this.factory.binary(SqlOperator.IN, this.factory.column(selfMappingPropertyMetaData, 1), warpQueryable));
        tempQueryable.getSelect().getColumns().add(this.factory.column(selfMappingPropertyMetaData, 1));
        if (include.hasCond()) {
            ISqlExpression cond = include.getCond();
            if (cond instanceof ISqlQueryableExpression) {
                ISqlQueryableExpression queryableExpression = (ISqlQueryableExpression)cond;
                tempQueryable = this.warpItQueryable(tempQueryable, selfMappingPropertyMetaData, navigateTargetType, queryableExpression, this.factory.column(selfMappingPropertyMetaData, 0));
            } else {
                tempQueryable.addWhere(this.factory.parens(cond));
            }
        }
        ArrayList<Object> values = new ArrayList<Object>();
        String sql = tempQueryable.getSqlAndValue(this.config, values);
        this.tryPrint(sql);
        List<PropertyMetaData> mappingData = tempQueryable.getMappingData(this.config);
        Map targetMap = this.session.executeQuery(r -> ObjectBuilder.start(r, (Class)Util.cast(navigateTargetType), mappingData, false, this.config).createMapListByAnotherKey(selfMappingPropertyMetaData), sql, values);
        boolean isSet = Set.class.isAssignableFrom(navigateData.getCollectionWrapperType());
        for (Map.Entry objectEntry : targetMap.entrySet()) {
            Object key = objectEntry.getKey();
            List value = (List)objectEntry.getValue();
            List<T> ts = sourcesMapList.get(key);
            for (T t : ts) {
                if (isSet) {
                    includePropertyMetaData.getSetter().invoke(t, new HashSet(value));
                    continue;
                }
                includePropertyMetaData.getSetter().invoke(t, value);
            }
        }
        this.round(include, navigateTargetType, targetMap.values(), tempQueryable);
    }

    private <K> Map<K, T> getMap(PropertyMetaData propertyMetaData) throws InvocationTargetException, IllegalAccessException {
        HashMap<Object, T> sourcesMap = new HashMap<Object, T>();
        for (T source : this.sources) {
            Object selfKey = propertyMetaData.getGetter().invoke(source, new Object[0]);
            sourcesMap.put(selfKey, source);
        }
        return sourcesMap;
    }

    private <K> Map<K, List<T>> getMapList(PropertyMetaData propertyMetaData) throws InvocationTargetException, IllegalAccessException {
        HashMap sourcesMapList = new HashMap();
        for (T source : this.sources) {
            Object selfKey = propertyMetaData.getGetter().invoke(source, new Object[0]);
            if (!sourcesMapList.containsKey(selfKey)) {
                ArrayList<T> list = new ArrayList<T>();
                list.add(source);
                sourcesMapList.put(selfKey, list);
                continue;
            }
            ((List)sourcesMapList.get(selfKey)).add(source);
        }
        return sourcesMapList;
    }

    protected ISqlQueryableExpression warpItQueryable(ISqlQueryableExpression querySqlBuilder, PropertyMetaData targetPropertyMetaData, Class<?> navigateTargetType, ISqlQueryableExpression virtualTableContext) {
        return this.warpItQueryable(querySqlBuilder, targetPropertyMetaData, navigateTargetType, virtualTableContext, null);
    }

    protected ISqlQueryableExpression warpItQueryable(ISqlQueryableExpression querySqlBuilder, PropertyMetaData targetPropertyMetaData, Class<?> navigateTargetType, ISqlQueryableExpression virtualTableContext, ISqlColumnExpression another) {
        ISqlOrderByExpression orderBy = virtualTableContext.getOrderBy();
        ISqlWhereExpression where = virtualTableContext.getWhere();
        ISqlLimitExpression limit = virtualTableContext.getLimit();
        if (!where.isEmpty()) {
            for (ISqlExpression condition : where.getConditions().getConditions()) {
                querySqlBuilder.addWhere(condition);
            }
        }
        ISqlQueryableExpression window = this.factory.queryable(querySqlBuilder);
        ArrayList<ISqlExpression> selects = new ArrayList<ISqlExpression>(2);
        selects.add(this.factory.constString("t0.*"));
        ArrayList<ISqlExpression> rowNumberParams = new ArrayList<ISqlExpression>();
        rowNumberParams.add(this.factory.column(targetPropertyMetaData, 0));
        rowNumberParams.addAll(orderBy.getSqlOrders());
        ArrayList<String> rowNumberFunction = new ArrayList<String>();
        this.rowNumber(rowNumberFunction, rowNumberParams);
        String rank = "-rank-";
        selects.add(this.factory.as(this.factory.template(rowNumberFunction, rowNumberParams), rank));
        window.setSelect(this.factory.select(selects, navigateTargetType));
        ISqlQueryableExpression window2 = this.factory.queryable(window);
        if (another != null) {
            window2.getSelect().getColumns().add(another);
        }
        if (limit.onlyHasRows()) {
            ISqlConstStringExpression _rank_ = this.factory.constString(this.config.getDisambiguation().disambiguation(rank));
            window2.addWhere(this.factory.binary(SqlOperator.LE, _rank_, this.factory.value(limit.getRows())));
        } else if (limit.hasRowsAndOffset()) {
            ISqlConstStringExpression _rank_ = this.factory.constString(this.config.getDisambiguation().disambiguation(rank));
            ISqlBinaryExpression right = this.factory.binary(SqlOperator.LE, _rank_, this.factory.value(limit.getOffset() + limit.getRows()));
            ISqlBinaryExpression left = this.factory.binary(SqlOperator.GT, _rank_, this.factory.value(limit.getOffset()));
            window2.addWhere(this.factory.binary(SqlOperator.AND, left, right));
        }
        return window2;
    }

    private void round(IncludeSet include, Class<?> navigateTargetType, Collection<?> sources, ISqlQueryableExpression main, Object ... os) throws InvocationTargetException, IllegalAccessException {
        if (!include.getIncludeSets().isEmpty()) {
            IncludeFactory includeFactory = this.config.getIncludeFactory();
            includeFactory.getBuilder(this.config, this.session, (Class)Util.cast(navigateTargetType), sources, include.getIncludeSets(), main).include();
        }
    }

    private void round(IncludeSet include, Class<?> navigateTargetType, Collection<List<Object>> sources, ISqlQueryableExpression main) throws InvocationTargetException, IllegalAccessException {
        if (!include.getIncludeSets().isEmpty()) {
            List collect = sources.stream().flatMap(o -> o.stream()).collect(Collectors.toList());
            IncludeFactory includeFactory = this.config.getIncludeFactory();
            includeFactory.getBuilder(this.config, this.session, (Class)Util.cast(navigateTargetType), collect, include.getIncludeSets(), main).include();
        }
    }

    private void tryPrint(String sql) {
        if (this.config.isPrintSql()) {
            log.info("includeQuery: ==> {}", (Object)sql);
        }
    }

    protected void rowNumber(List<String> rowNumberFunction, List<ISqlExpression> rowNumberParams) {
        rowNumberFunction.add("ROW_NUMBER() OVER (PARTITION BY ");
        if (rowNumberParams.size() > 1) {
            rowNumberFunction.add(" ORDER BY ");
        }
        for (int i = 0; i < rowNumberParams.size(); ++i) {
            if (i >= rowNumberParams.size() - 2) continue;
            rowNumberFunction.add(",");
        }
        rowNumberFunction.add(")");
    }
}

