/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.sqlink.base.expression;

import java.util.ArrayList;
import java.util.List;
import org.noear.solon.data.sqlink.base.IConfig;
import org.noear.solon.data.sqlink.base.expression.ISqlExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlFromExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlGroupByExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlHavingExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlJoinExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlJoinsExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlLimitExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlOrderByExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlOrderExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlSelectExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlTableExpression;
import org.noear.solon.data.sqlink.base.expression.ISqlWhereExpression;
import org.noear.solon.data.sqlink.base.expression.SqlExpressionFactory;
import org.noear.solon.data.sqlink.base.metaData.MetaData;
import org.noear.solon.data.sqlink.base.metaData.MetaDataCache;
import org.noear.solon.data.sqlink.base.metaData.PropertyMetaData;

public interface ISqlQueryableExpression
extends ISqlTableExpression {
    default public ISqlQueryableExpression copy(IConfig config) {
        SqlExpressionFactory factory = config.getSqlExpressionFactory();
        return factory.queryable(this.getSelect().copy(config), this.getFrom().copy(config), this.getJoins().copy(config), this.getWhere().copy(config), this.getGroupBy().copy(config), this.getHaving().copy(config), this.getOrderBy().copy(config), this.getLimit().copy(config));
    }

    @Override
    public Class<?> getTableClass();

    public void addWhere(ISqlExpression var1);

    public void addJoin(ISqlJoinExpression var1);

    public void setGroup(ISqlGroupByExpression var1);

    public void addHaving(ISqlExpression var1);

    public void addOrder(ISqlOrderExpression var1);

    public void setSelect(ISqlSelectExpression var1);

    public void setLimit(long var1, long var3);

    public void setDistinct(boolean var1);

    public ISqlFromExpression getFrom();

    public int getOrderedCount();

    public ISqlWhereExpression getWhere();

    public ISqlGroupByExpression getGroupBy();

    public ISqlJoinsExpression getJoins();

    public ISqlSelectExpression getSelect();

    public ISqlOrderByExpression getOrderBy();

    public ISqlLimitExpression getLimit();

    public ISqlHavingExpression getHaving();

    public List<Class<?>> getOrderedClass();

    default public List<PropertyMetaData> getMappingData(IConfig config) {
        List<Class<?>> orderedClass = this.getOrderedClass();
        SqlExpressionFactory factory = config.getSqlExpressionFactory();
        Class<?> target = this.getSelect().getTarget();
        MetaData metaData = MetaDataCache.getMetaData(target);
        if (orderedClass.contains(target)) {
            return metaData.getNotIgnorePropertys();
        }
        ArrayList<PropertyMetaData> propertyMetaDataList = new ArrayList<PropertyMetaData>();
        block0: for (PropertyMetaData sel : metaData.getNotIgnorePropertys()) {
            for (MetaData data : MetaDataCache.getMetaData(this.getOrderedClass())) {
                for (PropertyMetaData noi : data.getNotIgnorePropertys()) {
                    if (!noi.getColumn().equals(sel.getColumn()) || !noi.getType().equals(sel.getType())) continue;
                    propertyMetaDataList.add(sel);
                    continue block0;
                }
            }
        }
        return propertyMetaDataList;
    }
}

