/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.configurationprocessor;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.noear.snack.core.utils.StringUtil;
import org.noear.solon.configurationprocessor.ConstructorParameterPropertyDescriptor;
import org.noear.solon.configurationprocessor.JavaBeanPropertyDescriptor;
import org.noear.solon.configurationprocessor.LombokPropertyDescriptor;
import org.noear.solon.configurationprocessor.MetadataGenerationEnvironment;
import org.noear.solon.configurationprocessor.PropertyDescriptor;
import org.noear.solon.configurationprocessor.TypeElementMembers;

class PropertyDescriptorResolver {
    private final MetadataGenerationEnvironment environment;

    PropertyDescriptorResolver(MetadataGenerationEnvironment environment) {
        this.environment = environment;
    }

    Stream<PropertyDescriptor> resolve(TypeElement type, ExecutableElement factoryMethod) {
        TypeElementMembers members = new TypeElementMembers(this.environment, type);
        if (factoryMethod != null) {
            return this.resolveJavaBeanProperties(type, members, factoryMethod);
        }
        return this.resolve(Bindable.of(type, this.environment), members);
    }

    private Stream<PropertyDescriptor> resolve(Bindable bindable, TypeElementMembers members) {
        if (bindable.isConstructorBindingEnabled()) {
            ExecutableElement bindConstructor = bindable.getBindConstructor();
            return bindConstructor != null ? this.resolveConstructorBoundProperties(bindable.getType(), members, bindConstructor) : Stream.empty();
        }
        return this.resolveJavaBeanProperties(bindable.getType(), members, null);
    }

    private Stream<PropertyDescriptor> resolveConstructorBoundProperties(TypeElement declaringElement, TypeElementMembers members, ExecutableElement bindConstructor) {
        LinkedHashMap candidates = new LinkedHashMap();
        bindConstructor.getParameters().forEach(parameter -> {
            PropertyDescriptor descriptor = this.extracted(declaringElement, members, (VariableElement)parameter);
            this.register(candidates, descriptor);
        });
        return candidates.values().stream();
    }

    private PropertyDescriptor extracted(TypeElement declaringElement, TypeElementMembers members, VariableElement parameter) {
        String name = this.getPropertyName(parameter);
        TypeMirror type = parameter.asType();
        ExecutableElement getter = members.getPublicGetter(name, type);
        ExecutableElement setter = members.getPublicSetter(name, type);
        VariableElement field = members.getFields().get(name);
        return new ConstructorParameterPropertyDescriptor(name, type, parameter, declaringElement, getter, setter, field);
    }

    private String getPropertyName(VariableElement parameter) {
        return this.getPropertyName(parameter, parameter.getSimpleName().toString());
    }

    private String getPropertyName(VariableElement parameter, String fallback) {
        if (StringUtil.isEmpty((String)fallback)) {
            return fallback;
        }
        if (Objects.nonNull(parameter)) {
            return parameter.getSimpleName().toString();
        }
        return null;
    }

    private Stream<PropertyDescriptor> resolveJavaBeanProperties(TypeElement declaringElement, TypeElementMembers members, ExecutableElement factoryMethod) {
        LinkedHashMap candidates = new LinkedHashMap();
        members.getPublicGetters().forEach((name, getters) -> {
            VariableElement field = members.getFields().get(name);
            ExecutableElement getter = this.findMatchingGetter(members, (List<ExecutableElement>)getters, field);
            TypeMirror propertyType = getter.getReturnType();
            this.register(candidates, new JavaBeanPropertyDescriptor(this.getPropertyName(field, (String)name), propertyType, declaringElement, getter, members.getPublicSetter((String)name, propertyType), field, factoryMethod));
        });
        members.getFields().forEach((name, field) -> {
            TypeMirror propertyType = field.asType();
            ExecutableElement getter = members.getPublicGetter((String)name, propertyType);
            ExecutableElement setter = members.getPublicSetter((String)name, propertyType);
            this.register(candidates, new LombokPropertyDescriptor(this.getPropertyName((VariableElement)field, (String)name), propertyType, declaringElement, getter, setter, (VariableElement)field, factoryMethod));
        });
        return candidates.values().stream();
    }

    private ExecutableElement findMatchingGetter(TypeElementMembers members, List<ExecutableElement> candidates, VariableElement field) {
        if (candidates.size() > 1 && field != null) {
            return members.getMatchingGetter(candidates, field.asType());
        }
        return candidates.get(0);
    }

    private void register(Map<String, PropertyDescriptor> candidates, PropertyDescriptor descriptor) {
        if (!candidates.containsKey(descriptor.getName()) && this.isCandidate(descriptor)) {
            candidates.put(descriptor.getName(), descriptor);
        }
    }

    private boolean isCandidate(PropertyDescriptor descriptor) {
        return descriptor.isProperty(this.environment) || descriptor.isNested(this.environment);
    }

    private static class Bindable {
        private final TypeElement type;
        private final List<ExecutableElement> constructors;
        private final List<ExecutableElement> boundConstructors;

        Bindable(TypeElement type, List<ExecutableElement> constructors, List<ExecutableElement> boundConstructors) {
            this.type = type;
            this.constructors = constructors;
            this.boundConstructors = boundConstructors;
        }

        TypeElement getType() {
            return this.type;
        }

        boolean isConstructorBindingEnabled() {
            return !this.boundConstructors.isEmpty();
        }

        ExecutableElement getBindConstructor() {
            if (this.boundConstructors.isEmpty()) {
                return this.findBoundConstructor();
            }
            if (this.boundConstructors.size() == 1) {
                return this.boundConstructors.get(0);
            }
            return null;
        }

        private ExecutableElement findBoundConstructor() {
            ExecutableElement boundConstructor = null;
            for (ExecutableElement candidate : this.constructors) {
                if (candidate.getParameters().isEmpty()) continue;
                if (boundConstructor != null) {
                    return null;
                }
                boundConstructor = candidate;
            }
            return boundConstructor;
        }

        static Bindable of(TypeElement type, MetadataGenerationEnvironment env) {
            List<ExecutableElement> constructors = ElementFilter.constructorsIn(type.getEnclosedElements());
            List<ExecutableElement> boundConstructors = Bindable.getBoundConstructors(type, env, constructors);
            return new Bindable(type, constructors, boundConstructors);
        }

        private static List<ExecutableElement> getBoundConstructors(TypeElement type, MetadataGenerationEnvironment env, List<ExecutableElement> constructors) {
            ExecutableElement bindConstructor = Bindable.deduceBindConstructor(type, constructors, env);
            if (bindConstructor != null) {
                return Collections.singletonList(bindConstructor);
            }
            return Collections.emptyList();
        }

        private static ExecutableElement deduceBindConstructor(TypeElement type, List<ExecutableElement> constructors, MetadataGenerationEnvironment env) {
            ExecutableElement candidate;
            if (constructors.size() == 1 && !(candidate = constructors.get(0)).getParameters().isEmpty() && !env.hasAutowiredAnnotation(candidate)) {
                if (type.getNestingKind() == NestingKind.MEMBER && candidate.getModifiers().contains((Object)Modifier.PRIVATE)) {
                    return null;
                }
                return candidate;
            }
            return null;
        }
    }
}

