/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.configurationprocessor;

import java.util.function.Function;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.TypeKindVisitor8;
import org.noear.solon.configurationprocessor.MetadataGenerationEnvironment;
import org.noear.solon.configurationprocessor.PropertyDescriptor;

abstract class ParameterPropertyDescriptor
extends PropertyDescriptor {
    private final VariableElement parameter;

    ParameterPropertyDescriptor(String name, TypeMirror type, VariableElement parameter, TypeElement declaringElement, ExecutableElement getter) {
        super(name, type, declaringElement, getter);
        this.parameter = parameter;
    }

    final VariableElement getParameter() {
        return this.parameter;
    }

    @Override
    protected Object resolveDefaultValue(MetadataGenerationEnvironment environment) {
        return this.getParameter().asType().accept(DefaultPrimitiveTypeVisitor.INSTANCE, null);
    }

    @Override
    public boolean isProperty(MetadataGenerationEnvironment env) {
        return !this.isNested(env);
    }

    private static final class DefaultValueCoercionTypeVisitor
    extends TypeKindVisitor8<Object, String> {
        static final DefaultValueCoercionTypeVisitor INSTANCE = new DefaultValueCoercionTypeVisitor();

        private DefaultValueCoercionTypeVisitor() {
        }

        private <T extends Number> T parseNumber(String value, Function<String, T> parser, PrimitiveType primitiveType) {
            try {
                return (T)((Number)parser.apply(value));
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException(String.format("Invalid %s representation '%s'", primitiveType, value));
            }
        }

        @Override
        public Object visitPrimitiveAsBoolean(PrimitiveType type, String value) {
            return Boolean.parseBoolean(value);
        }

        @Override
        public Object visitPrimitiveAsByte(PrimitiveType type, String value) {
            return this.parseNumber(value, Byte::parseByte, type);
        }

        @Override
        public Object visitPrimitiveAsShort(PrimitiveType type, String value) {
            return this.parseNumber(value, Short::parseShort, type);
        }

        @Override
        public Object visitPrimitiveAsInt(PrimitiveType type, String value) {
            return this.parseNumber(value, Integer::parseInt, type);
        }

        @Override
        public Object visitPrimitiveAsLong(PrimitiveType type, String value) {
            return this.parseNumber(value, Long::parseLong, type);
        }

        @Override
        public Object visitPrimitiveAsChar(PrimitiveType type, String value) {
            if (value.length() > 1) {
                throw new IllegalArgumentException(String.format("Invalid character representation '%s'", value));
            }
            return value;
        }

        @Override
        public Object visitPrimitiveAsFloat(PrimitiveType type, String value) {
            return this.parseNumber(value, Float::parseFloat, type);
        }

        @Override
        public Object visitPrimitiveAsDouble(PrimitiveType type, String value) {
            return this.parseNumber(value, Double::parseDouble, type);
        }
    }

    private static final class DefaultPrimitiveTypeVisitor
    extends TypeKindVisitor8<Object, Void> {
        static final DefaultPrimitiveTypeVisitor INSTANCE = new DefaultPrimitiveTypeVisitor();

        private DefaultPrimitiveTypeVisitor() {
        }

        @Override
        public Object visitPrimitiveAsBoolean(PrimitiveType type, Void parameter) {
            return false;
        }

        @Override
        public Object visitPrimitiveAsByte(PrimitiveType type, Void parameter) {
            return (byte)0;
        }

        @Override
        public Object visitPrimitiveAsShort(PrimitiveType type, Void parameter) {
            return (short)0;
        }

        @Override
        public Object visitPrimitiveAsInt(PrimitiveType type, Void parameter) {
            return 0;
        }

        @Override
        public Object visitPrimitiveAsLong(PrimitiveType type, Void parameter) {
            return 0L;
        }

        @Override
        public Object visitPrimitiveAsChar(PrimitiveType type, Void parameter) {
            return null;
        }

        @Override
        public Object visitPrimitiveAsFloat(PrimitiveType type, Void parameter) {
            return Float.valueOf(0.0f);
        }

        @Override
        public Object visitPrimitiveAsDouble(PrimitiveType type, Void parameter) {
            return 0.0;
        }
    }
}

