/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.model;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.noear.solon.Solon;
import org.noear.solon.cloud.exception.CloudFileException;
import org.noear.solon.core.util.IoUtil;

public class Media {
    private final InputStream body;
    private final String contentType;
    private final long contentSize;

    public Media(InputStream body, String contentType) {
        this(body, contentType, 0L);
    }

    public Media(InputStream body, String contentType, long contentSize) {
        this.body = body;
        this.contentType = contentType;
        this.contentSize = contentSize;
    }

    public Media(InputStream body) {
        this(body, null);
    }

    public Media(byte[] body, String contentType) {
        this(new ByteArrayInputStream(body), contentType, body.length);
    }

    public Media(byte[] body) {
        this(body, null);
    }

    public Media(String body, String contentType) {
        this(body.getBytes(StandardCharsets.UTF_8), contentType);
    }

    public Media(String body) {
        this(body, null);
    }

    public String contentType() {
        return this.contentType;
    }

    public long contentSize() throws IOException {
        if (this.contentSize > 0L) {
            return this.contentSize;
        }
        return this.body.available();
    }

    public InputStream body() {
        return this.body;
    }

    public byte[] bodyAsBytes() {
        return this.bodyAsBytes(false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] bodyAsBytes(boolean autoClose) {
        try {
            if (!autoClose) return IoUtil.transferToBytes((InputStream)this.body);
            try (InputStream stream = this.body;){
                byte[] byArray = IoUtil.transferToBytes((InputStream)stream);
                return byArray;
            }
        }
        catch (IOException e) {
            throw new CloudFileException(e);
        }
    }

    public String bodyAsString() {
        return this.bodyAsString(false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String bodyAsString(boolean autoClose) {
        try {
            if (!autoClose) return IoUtil.transferToString((InputStream)this.body, (String)Solon.encoding());
            try (InputStream stream = this.body;){
                String string = IoUtil.transferToString((InputStream)stream, (String)Solon.encoding());
                return string;
            }
        }
        catch (IOException e) {
            throw new CloudFileException(e);
        }
    }
}

