/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.service;

import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import org.noear.solon.cloud.exception.CloudFileException;
import org.noear.solon.cloud.model.Media;
import org.noear.solon.core.handle.Result;

public interface CloudFileService {
    public boolean exists(String var1, String var2) throws CloudFileException;

    default public boolean exists(String key) throws CloudFileException {
        return this.exists(null, key);
    }

    public String getTempUrl(String var1, String var2, Duration var3) throws CloudFileException, UnsupportedOperationException;

    default public String getTempUrl(String key, Duration duration) throws CloudFileException, UnsupportedOperationException {
        return this.getTempUrl(null, key, duration);
    }

    default public String getTempUrl(String bucket, String key, Date expiration) throws CloudFileException, UnsupportedOperationException {
        return this.getTempUrl(bucket, key, Duration.between(Instant.now(), expiration.toInstant()));
    }

    default public String getTempUrl(String key, Date expiration) throws CloudFileException, UnsupportedOperationException {
        return this.getTempUrl(null, key, expiration);
    }

    public Media get(String var1, String var2) throws CloudFileException;

    default public Media get(String key) throws CloudFileException {
        return this.get(null, key);
    }

    public Result put(String var1, String var2, Media var3) throws CloudFileException;

    default public Result put(String key, Media media) throws CloudFileException {
        return this.put(null, key, media);
    }

    public Result delete(String var1, String var2) throws CloudFileException;

    default public Result delete(String key) {
        return this.delete(null, key);
    }
}

