/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.telemetry.integration;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Scope;
import java.util.HashSet;
import java.util.Set;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.cloud.telemetry.slf4j.TracingMDC;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Filter;
import org.noear.solon.core.handle.FilterChain;

public class SolonFilterTracing
implements Filter {
    private Tracer tracer;
    private Set<String> excludePaths = new HashSet<String>();

    public SolonFilterTracing(String excluded) {
        Solon.context().getBeanAsync(Tracer.class, bean -> {
            this.tracer = bean;
        });
        if (Utils.isNotEmpty((String)excluded)) {
            for (String path : excluded.split(",")) {
                if ((path = path.trim()).length() <= 0) continue;
                if (path.startsWith("/")) {
                    this.excludePaths.add(path);
                    continue;
                }
                this.excludePaths.add("/" + path);
            }
        }
    }

    public void doFilter(Context ctx, FilterChain chain) throws Throwable {
        if (this.tracer == null || this.excludePaths.contains(ctx.pathNew())) {
            chain.doFilter(ctx);
        } else {
            Span span = this.buildSpan(ctx);
            try (Scope scope = span.makeCurrent();){
                TracingMDC.inject(span);
                chain.doFilter(ctx);
            }
            catch (Throwable e) {
                throw e;
            }
            finally {
                TracingMDC.removeSpanId();
                TracingMDC.removeTraceId();
                span.end();
            }
        }
    }

    public Span buildSpan(Context ctx) {
        StringBuilder operationName = new StringBuilder();
        operationName.append(ctx.pathNew()).append(" (").append(ctx.uri().getScheme()).append(" ").append(ctx.method()).append(')');
        SpanBuilder spanBuilder = this.tracer.spanBuilder(operationName.toString());
        spanBuilder.setSpanKind(SpanKind.SERVER);
        spanBuilder.setAttribute("req.url", ctx.url());
        Span span = spanBuilder.startSpan();
        return span;
    }
}

