/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.data.cache.integration;

import java.util.function.Consumer;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.aspect.Interceptor;
import org.noear.solon.data.annotation.Cache;
import org.noear.solon.data.annotation.CachePut;
import org.noear.solon.data.annotation.CacheRemove;
import org.noear.solon.data.cache.CacheLib;
import org.noear.solon.data.cache.CacheService;
import org.noear.solon.data.cache.CacheServiceWrapConsumer;
import org.noear.solon.data.cache.LocalCacheFactoryImpl;
import org.noear.solon.data.cache.LocalCacheService;
import org.noear.solon.data.cache.interceptor.CacheInterceptor;
import org.noear.solon.data.cache.interceptor.CachePutInterceptor;
import org.noear.solon.data.cache.interceptor.CacheRemoveInterceptor;

public class CachePlugin
implements Plugin {
    public void start(AppContext context) throws Throwable {
        CacheLib.cacheFactoryAdd("local", new LocalCacheFactoryImpl());
        if (context.app().enableCaching()) {
            CacheLib.cacheServiceAddIfAbsent("", LocalCacheService.instance);
            context.subWrapsOfType(CacheService.class, (Consumer)new CacheServiceWrapConsumer());
            context.lifecycle(-94, () -> {
                if (!context.hasWrap(CacheService.class)) {
                    context.wrapAndPut(CacheService.class, (Object)LocalCacheService.instance);
                }
            });
            context.beanInterceptorAdd(CachePut.class, (Interceptor)new CachePutInterceptor(), 110);
            context.beanInterceptorAdd(CacheRemove.class, (Interceptor)new CacheRemoveInterceptor(), 110);
            context.beanInterceptorAdd(Cache.class, (Interceptor)new CacheInterceptor(), 111);
        }
    }
}

