/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.websocket.netty;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.concurrent.Future;
import org.noear.solon.boot.web.DecodeUtils;
import org.noear.solon.boot.websocket.netty.NettyWsServerHandler;
import org.noear.solon.core.util.RunUtil;
import org.noear.solon.net.websocket.WebSocketTimeoutBase;

public class WebSocketImpl
extends WebSocketTimeoutBase {
    private ChannelHandlerContext real;

    public WebSocketImpl(ChannelHandlerContext real) {
        this.real = real;
        String uri = DecodeUtils.rinseUri((String)((String)real.attr(NettyWsServerHandler.ResourceDescriptorKey).get()));
        this.init(URI.create(uri));
    }

    public boolean isValid() {
        return !this.isClosed() && this.real.channel().isOpen();
    }

    public boolean isSecure() {
        return false;
    }

    public InetSocketAddress remoteAddress() {
        return (InetSocketAddress)this.real.channel().remoteAddress();
    }

    public InetSocketAddress localAddress() {
        return (InetSocketAddress)this.real.channel().localAddress();
    }

    public Future<Void> send(String text) {
        try {
            ChannelFuture channelFuture = this.real.writeAndFlush((Object)new TextWebSocketFrame(text));
            return channelFuture;
        }
        finally {
            this.onSend();
        }
    }

    public Future<Void> send(ByteBuffer binary) {
        try {
            ChannelFuture channelFuture = this.real.writeAndFlush((Object)new BinaryWebSocketFrame(Unpooled.wrappedBuffer((ByteBuffer)binary)));
            return channelFuture;
        }
        finally {
            this.onSend();
        }
    }

    public void close() {
        super.close();
        RunUtil.runAndTry(() -> ((ChannelHandlerContext)this.real).close());
    }
}

