/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.aot.proxy;

import com.squareup.javapoet.JavaFile;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import org.noear.solon.aot.Settings;
import org.noear.solon.aot.proxy.ProxyClassFileBuilder;

public class ProxyClassGenerator {
    private ProxyClassFileBuilder classFileBuilder = new ProxyClassFileBuilder();

    public void generateCode(Settings settings, Class<?> typeElement) {
        this.assertProxyType(typeElement);
        JavaFile javaFile = this.classFileBuilder.build(typeElement);
        try {
            javaFile.writeTo(this.getProxyFileDir(settings, typeElement));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private File getProxyFileDir(Settings settings, Class<?> typeElement) {
        try {
            String dir = typeElement.getPackage().getName().replace("\\.", "/");
            String proxyFileDir = settings.getGeneratedSources() + "/" + dir;
            File file = new File(proxyFileDir);
            File parentFile = file.getParentFile();
            if (!parentFile.exists()) {
                parentFile.mkdirs();
            }
            return new File(settings.getGeneratedSources() + "/");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void assertProxyType(Class<?> typeElement) throws IllegalStateException {
        int modifiers = typeElement.getModifiers();
        if (Modifier.isAbstract(modifiers)) {
            throw new IllegalStateException("Abstract classes are not supported as proxy components");
        }
        if (Modifier.isFinal(modifiers)) {
            throw new IllegalStateException("Final classes are not supported as proxy components");
        }
        if (!Modifier.isPublic(modifiers)) {
            throw new IllegalStateException("Not public classes are not supported as proxy components");
        }
        if (typeElement.getTypeParameters() != null && typeElement.getTypeParameters().length > 0) {
            throw new IllegalStateException("Generic type classes are not supported as proxy components");
        }
    }
}

