/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.llm.dialect.dashscope;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.noear.snack4.Feature;
import org.noear.snack4.ONode;
import org.noear.solon.Utils;
import org.noear.solon.ai.AiUsage;
import org.noear.solon.ai.rag.Document;
import org.noear.solon.ai.reranking.Reranking;
import org.noear.solon.ai.reranking.RerankingConfig;
import org.noear.solon.ai.reranking.RerankingException;
import org.noear.solon.ai.reranking.RerankingOptions;
import org.noear.solon.ai.reranking.RerankingResponse;
import org.noear.solon.ai.reranking.dialect.AbstractRerankingDialect;

public class DashscopeRerankingDialect
extends AbstractRerankingDialect {
    private static final String URL_PREFIX = "https://dashscope.aliyuncs.com/api/v1/services/";
    private static DashscopeRerankingDialect instance = new DashscopeRerankingDialect();

    public static DashscopeRerankingDialect getInstance() {
        return instance;
    }

    public boolean matched(RerankingConfig config) {
        if ("dashscope".equals(config.getProvider())) {
            return true;
        }
        return config.getApiUrl().startsWith(URL_PREFIX);
    }

    public String buildRequestJson(RerankingConfig config, RerankingOptions options, String query, List<Document> documents) {
        return new ONode().then(n -> {
            if (Utils.isNotEmpty((String)config.getModel())) {
                n.set("model", (Object)config.getModel());
            }
            n.getOrNew("input").then(n1 -> {
                n1.set("query", (Object)query);
                n1.getOrNew("documents").then(n2 -> {
                    for (Document doc : documents) {
                        n2.add((Object)doc.getContent());
                    }
                });
            });
            for (Map.Entry kv : options.options().entrySet()) {
                n.set((String)kv.getKey(), kv.getValue());
            }
        }).toJson();
    }

    public RerankingResponse parseResponseJson(RerankingConfig config, String respJson) {
        ONode oResp = ONode.ofJson((String)respJson, (Feature[])new Feature[0]);
        String model = oResp.get("model").getString();
        if (oResp.hasKey("message")) {
            return new RerankingResponse(model, new RerankingException(oResp.get("message").getString()), null, null);
        }
        ArrayList<Reranking> results = new ArrayList<Reranking>();
        for (ONode n1 : oResp.get("output").get("results").getArray()) {
            Reranking r1 = new Reranking(n1.get("index").getInt().intValue(), n1.get("document").get("text").getString(), n1.get("relevance_score").getFloat().floatValue());
            results.add(r1);
        }
        AiUsage usage = null;
        if (oResp.hasKey("usage")) {
            ONode oUsage = oResp.get("usage");
            long total_tokens = oUsage.get("total_tokens").getLong();
            usage = new AiUsage(total_tokens, 0L, total_tokens, oUsage);
        }
        return new RerankingResponse(model, null, results, usage);
    }
}

