/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack.core;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Consumer;
import org.noear.snack.core.DEFAULTS;
import org.noear.snack.core.Feature;
import org.noear.snack.core.NodeDecoder;
import org.noear.snack.core.NodeDecoderEntity;
import org.noear.snack.core.NodeEncoder;
import org.noear.snack.core.NodeEncoderEntity;
import org.noear.snack.core.utils.StringUtil;
import org.noear.snack.exception.SnackException;

public class Options {
    public static int features_def = Feature.of(Feature.OrderedField, Feature.WriteDateUseTicks, Feature.TransferCompatible, Feature.QuoteFieldNames);
    public static int features_serialize = Feature.of(Feature.OrderedField, Feature.WriteDateUseTicks, Feature.BrowserCompatible, Feature.WriteClassName, Feature.QuoteFieldNames);
    private int features = DEFAULTS.DEF_FEATURES;
    private final Map<Class<?>, NodeEncoderEntity> encoderMap = new LinkedHashMap();
    private final Map<Class<?>, NodeDecoderEntity> decoderMap = new LinkedHashMap();
    private String dateFormat = DEFAULTS.DEF_DATETIME_FORMAT;
    private String typePropertyName = "@type";
    private TimeZone timeZone = DEFAULTS.DEF_TIME_ZONE;
    private ClassLoader classLoader;

    public static final Options def() {
        return new Options(features_def);
    }

    public static final Options serialize() {
        return new Options(features_serialize);
    }

    public Options() {
    }

    public Options(int features) {
        this();
        this.features = features;
    }

    public static Options of(Feature ... features) {
        return new Options().add(features);
    }

    public Options add(Feature ... features) {
        for (Feature f : features) {
            this.features = Feature.config(this.features, f, true);
        }
        return this;
    }

    public Options remove(Feature ... features) {
        for (Feature f : features) {
            this.features = Feature.config(this.features, f, false);
        }
        return this;
    }

    @Deprecated
    public Options sub(Feature ... features) {
        return this.remove(features);
    }

    public final int getFeatures() {
        return this.features;
    }

    public final void setFeatures(Feature ... features) {
        this.features = Feature.of(features);
    }

    public final boolean hasFeature(Feature feature) {
        return Feature.isEnabled(this.features, feature);
    }

    public Options build(Consumer<Options> custom) {
        custom.accept(this);
        return this;
    }

    public Collection<NodeEncoderEntity> encoders() {
        return Collections.unmodifiableCollection(this.encoderMap.values());
    }

    public <T> void addEncoder(Class<T> clz, NodeEncoder<T> encoder) {
        this.encoderMap.put(clz, new NodeEncoderEntity<T>(clz, encoder));
    }

    public Collection<NodeDecoderEntity> decoders() {
        return Collections.unmodifiableCollection(this.decoderMap.values());
    }

    public <T> void addDecoder(Class<T> clz, NodeDecoder<T> decoder) {
        this.decoderMap.put(clz, new NodeDecoderEntity<T>(clz, decoder));
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public String getTypePropertyName() {
        return this.typePropertyName;
    }

    public void setTypePropertyName(String typePropertyName) {
        this.typePropertyName = typePropertyName;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Class<?> loadClass(String clzName) {
        if (StringUtil.isEmpty(clzName)) {
            return null;
        }
        try {
            if (this.classLoader == null) {
                return Class.forName(clzName);
            }
            return this.classLoader.loadClass(clzName);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SnackException("Failed to load class: " + clzName, e);
        }
    }
}

