/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server.handler;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartboot.http.common.utils.AntPathMatcher;
import org.smartboot.http.server.WebSocketHandler;
import org.smartboot.http.server.WebSocketRequest;
import org.smartboot.http.server.WebSocketResponse;
import org.smartboot.http.server.impl.Request;
import org.smartboot.http.server.impl.WebSocketRequestImpl;
import org.smartboot.http.server.impl.WebSocketResponseImpl;

public final class WebSocketRouteHandler
extends WebSocketHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSocketRouteHandler.class);
    private static final AntPathMatcher PATH_MATCHER = new AntPathMatcher();
    private final WebSocketHandler defaultHandler = new WebSocketHandler(){

        @Override
        public void handle(WebSocketRequest request, WebSocketResponse response) throws IOException {
            LOGGER.warn("not found");
        }
    };
    private final Map<String, WebSocketHandler> handlerMap = new ConcurrentHashMap<String, WebSocketHandler>();

    public void onClose(Request request) {
        this.handlerMap.get(request.getRequestURI()).onClose(request);
    }

    @Override
    public void willHeaderComplete(WebSocketRequestImpl request, WebSocketResponseImpl response) {
        String uri = request.getRequestURI();
        WebSocketHandler httpHandler = this.handlerMap.get(uri);
        if (httpHandler == null) {
            for (Map.Entry<String, WebSocketHandler> entity : this.handlerMap.entrySet()) {
                if (!PATH_MATCHER.match(entity.getKey(), uri)) continue;
                httpHandler = entity.getValue();
                break;
            }
            if (httpHandler == null) {
                httpHandler = this.defaultHandler;
            }
            this.handlerMap.put(uri, httpHandler);
        }
        httpHandler.willHeaderComplete(request, response);
    }

    @Override
    public void whenHeaderComplete(WebSocketRequestImpl request, WebSocketResponseImpl response) {
        WebSocketHandler httpHandler = this.handlerMap.get(request.getRequestURI());
        httpHandler.whenHeaderComplete(request, response);
    }

    @Override
    public void handle(WebSocketRequest request, WebSocketResponse response) throws Throwable {
        WebSocketHandler httpHandler = this.handlerMap.get(request.getRequestURI());
        httpHandler.handle(request, response);
    }

    public WebSocketRouteHandler route(String urlPattern, WebSocketHandler httpHandle) {
        this.handlerMap.put(urlPattern, httpHandle);
        return this;
    }
}

