/*
 * Decompiled with CFR 0.152.
 */
package org.noear.nami;

import java.util.HashMap;
import java.util.Map;
import org.noear.solon.core.util.CallableTx;
import org.noear.solon.core.util.ScopeLocal;
import org.noear.solon.lang.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NamiAttachment {
    private static final Logger log = LoggerFactory.getLogger(NamiAttachment.class);
    private static final ScopeLocal<Map<String, String>> LOCAL = ScopeLocal.newInstance(NamiAttachment.class);

    public static void with(Runnable runnable) {
        HashMap data = (HashMap)LOCAL.get();
        if (data == null) {
            data = new HashMap();
        }
        LOCAL.with(data, runnable);
    }

    public static <R, X extends Throwable> R with(CallableTx<R, X> callable) throws X {
        HashMap data = (HashMap)LOCAL.get();
        if (data == null) {
            data = new HashMap();
        }
        return (R)LOCAL.with(data, callable);
    }

    public static @Nullable Map<String, String> getData() {
        return (Map)LOCAL.get();
    }

    public static void put(String name, String value) {
        Map data = (Map)LOCAL.get();
        if (data != null) {
            data.put(name, value);
        } else {
            log.error("Attachment is null, please use `NamiAttachment.with(() -> NamiAttachment.put(k, v))`");
        }
    }

    public static String get(String name) {
        Map data = (Map)LOCAL.get();
        if (data != null) {
            return (String)data.get(name);
        }
        log.error("Attachment is null, please use `NamiAttachment.with(() -> NamiAttachment.get(k))`");
        return null;
    }

    public static void remove(String name) {
        Map data = (Map)LOCAL.get();
        if (data != null) {
            data.remove(name);
        } else {
            log.error("Attachment is null, please use `NamiAttachment.with(() -> NamiAttachment.remove(k))`");
        }
    }

    public static void clear() {
        LOCAL.set(null);
    }
}

