/*
 * Decompiled with CFR 0.152.
 */
package org.noear.nami;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.noear.nami.Channel;
import org.noear.nami.Decoder;
import org.noear.nami.Encoder;
import org.noear.nami.Filter;
import org.noear.nami.NamiConfiguration;
import org.noear.solon.core.util.ClassUtil;

public class NamiManager {
    static final Map<String, Decoder> decoderMap = new HashMap<String, Decoder>();
    static final Map<String, Encoder> encoderMap = new HashMap<String, Encoder>();
    static final Map<String, Channel> channelMap = new HashMap<String, Channel>();
    static final Map<Class<?>, NamiConfiguration> configuratorMap = new HashMap();
    static Decoder decoderFirst;
    static Encoder encoderFirst;
    static final Set<Filter> filterSet;

    public static void reg(Decoder decoder) {
        decoderMap.put(decoder.enctype(), decoder);
        if (decoderFirst == null) {
            decoderFirst = decoder;
        }
    }

    public static void regIfAbsent(Decoder decoder) {
        decoderMap.putIfAbsent(decoder.enctype(), decoder);
        if (decoderFirst == null) {
            decoderFirst = decoder;
        }
    }

    public static void reg(Encoder encoder) {
        encoderMap.put(encoder.enctype(), encoder);
        if (encoderFirst == null) {
            encoderFirst = encoder;
        }
    }

    public static void regIfAbsent(Encoder encoder) {
        encoderMap.putIfAbsent(encoder.enctype(), encoder);
        if (encoderFirst == null) {
            encoderFirst = encoder;
        }
    }

    public static void reg(Filter filter) {
        filterSet.add(filter);
    }

    public static void reg(String scheme, Channel channel) {
        channelMap.put(scheme, channel);
    }

    public static void regIfAbsent(String scheme, Channel channel) {
        channelMap.putIfAbsent(scheme, channel);
    }

    public static Decoder getDecoder(String enctype) {
        if (enctype == null) {
            return null;
        }
        return decoderMap.get(enctype);
    }

    public static Decoder getDecoderFirst() {
        return decoderFirst;
    }

    public static Encoder getEncoder(String enctype) {
        if (enctype == null) {
            return null;
        }
        return encoderMap.get(enctype);
    }

    public static Encoder getEncoderFirst() {
        return encoderFirst;
    }

    public static Set<Filter> getFilters() {
        return filterSet;
    }

    public static Channel getChannel(String scheme) {
        return channelMap.get(scheme);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NamiConfiguration getConfigurator(Class<? extends NamiConfiguration> clz) throws Exception {
        NamiConfiguration tmp = configuratorMap.get(clz);
        if (tmp == null) {
            Class<? extends NamiConfiguration> clazz = clz;
            synchronized (clazz) {
                tmp = configuratorMap.get(clz);
                if (tmp == null) {
                    tmp = (NamiConfiguration)ClassUtil.newInstance(clz);
                    configuratorMap.put(clz, tmp);
                }
            }
        }
        return tmp;
    }

    static {
        filterSet = new LinkedHashSet<Filter>();
    }
}

