/*
 * Decompiled with CFR 0.152.
 */
package org.noear.nami.coder.fastjson;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.ParserConfig;
import java.lang.reflect.Type;
import org.noear.nami.Context;
import org.noear.nami.Decoder;
import org.noear.nami.Result;

public class FastjsonDecoder
implements Decoder {
    public static final FastjsonDecoder instance;

    public String enctype() {
        return "application/json";
    }

    public <T> T decode(Result rst, Type type) {
        String str = rst.bodyAsString();
        Object returnVal = null;
        try {
            if (str == null) {
                return (T)str;
            }
            returnVal = str.contains("\"stackTrace\":[{") ? JSON.parseObject((String)str, Throwable.class) : JSON.parseObject((String)str, (Type)type, (Feature[])new Feature[0]);
        }
        catch (Throwable ex) {
            returnVal = ex;
        }
        if (returnVal != null && returnVal instanceof Throwable) {
            if (returnVal instanceof RuntimeException) {
                throw (RuntimeException)returnVal;
            }
            throw new RuntimeException((Throwable)returnVal);
        }
        return (T)returnVal;
    }

    public void pretreatment(Context ctx) {
        ctx.headers.put("X-Serialization", "@type_json");
        ctx.headers.put("Accept", "application/json");
    }

    static {
        ParserConfig.getGlobalInstance().setAutoTypeSupport(true);
        instance = new FastjsonDecoder();
    }
}

