/*
 * Decompiled with CFR 0.152.
 */
package org.noear.nami.channel.socketd;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.noear.nami.Channel;
import org.noear.nami.ChannelBase;
import org.noear.nami.Context;
import org.noear.nami.Result;
import org.noear.nami.channel.socketd.SocketdChannel;
import org.noear.nami.channel.socketd.SocketdProxy;
import org.noear.socketd.SocketD;
import org.noear.socketd.transport.core.Listener;
import org.noear.socketd.transport.core.Session;

public class SocketdClientChannel
extends ChannelBase
implements Channel {
    public static final SocketdClientChannel instance = new SocketdClientChannel();
    private final Map<String, SocketdChannel> channelMap = new HashMap<String, SocketdChannel>();
    private final ReentrantLock SYNC_LOCK = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SocketdChannel get(String hostname, String url) {
        SocketdChannel channel;
        block7: {
            channel = this.channelMap.get(hostname);
            if (channel == null) {
                this.SYNC_LOCK.lock();
                try {
                    channel = this.channelMap.get(hostname);
                    if (channel != null) break block7;
                    try {
                        Session session = (Session)SocketD.createClient((String)url).listen((Listener)SocketdProxy.socketdToHandler).openOrThow();
                        channel = new SocketdChannel(() -> session);
                        this.channelMap.put(hostname, channel);
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(e);
                    }
                }
                finally {
                    this.SYNC_LOCK.unlock();
                }
            }
        }
        return channel;
    }

    public Result call(Context ctx) throws Throwable {
        this.pretreatment(ctx);
        URI uri = URI.create(ctx.url);
        String hostname = uri.getAuthority();
        SocketdChannel channel = this.get(hostname, ctx.url);
        return channel.call(ctx);
    }
}

