/*
 * Decompiled with CFR 0.152.
 */
package org.noear.nami.channel.http.okhttp;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.net.ssl.HostnameVerifier;
import okhttp3.Call;
import okhttp3.Dispatcher;
import okhttp3.FormBody;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.noear.nami.NamiException;
import org.noear.nami.NamiGlobal;
import org.noear.nami.channel.http.okhttp.HttpInterceptor;
import org.noear.nami.channel.http.okhttp.SSLClient;
import org.noear.nami.channel.http.okhttp.TimeoutProps;

class HttpUtils {
    private static final Supplier<Dispatcher> httpClientDispatcher = () -> {
        Dispatcher temp = new Dispatcher();
        temp.setMaxRequests(NamiGlobal.getMaxConnections());
        temp.setMaxRequestsPerHost(NamiGlobal.getMaxConnections());
        return temp;
    };
    private static final OkHttpClient httpClientDefault = new OkHttpClient.Builder().connectTimeout((long)NamiGlobal.getConnectTimeout(), TimeUnit.SECONDS).writeTimeout((long)NamiGlobal.getWriteTimeout(), TimeUnit.SECONDS).readTimeout((long)NamiGlobal.getReadTimeout(), TimeUnit.SECONDS).dispatcher(httpClientDispatcher.get()).addInterceptor((Interceptor)HttpInterceptor.instance).sslSocketFactory(SSLClient.getSSLSocketFactory(), SSLClient.getX509TrustManager()).hostnameVerifier((HostnameVerifier)SSLClient.defaultHostnameVerifier).build();
    private Charset _charset;
    private RequestBody _body;
    private Map<String, String> _form;
    private Request.Builder _builder;
    private OkHttpClient _client;

    public static HttpUtils http(String url) {
        return new HttpUtils(url);
    }

    public static String urlEncode(String str) {
        try {
            return URLEncoder.encode(str, "utf-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new NamiException((Throwable)ex);
        }
    }

    public HttpUtils(String url) {
        this(httpClientDefault, url);
    }

    public HttpUtils(OkHttpClient client, String url) {
        this._builder = new Request.Builder().url(url);
        this._client = client;
        if (this._client == null) {
            this._client = httpClientDefault;
        }
    }

    public HttpUtils charset(String charset) {
        this._charset = Charset.forName(charset);
        return this;
    }

    public HttpUtils headers(Map<String, String> headers) {
        if (headers != null) {
            headers.forEach((k, v) -> {
                if (v != null) {
                    this._builder.header(k, v);
                }
            });
        }
        return this;
    }

    public HttpUtils data(Map<String, Object> data) {
        if (data != null) {
            this.tryInitForm();
            data.forEach((k, v) -> {
                if (v != null) {
                    this._form.put((String)k, v.toString());
                }
            });
        }
        return this;
    }

    public HttpUtils data(String key, String value) {
        this.tryInitForm();
        this._form.put(key, value);
        return this;
    }

    public HttpUtils bodyRaw(byte[] bytes, String contentType) {
        this._body = FormBody.create((MediaType)MediaType.parse((String)contentType), (byte[])bytes);
        return this;
    }

    public HttpUtils timeout(int timeoutSeconds) {
        if (timeoutSeconds > 0) {
            this._builder.tag(TimeoutProps.class, (Object)new TimeoutProps(timeoutSeconds));
        }
        return this;
    }

    public Response exec(String mothod) throws Exception {
        if (this._form != null) {
            String fb = new FormBody.Builder(this._charset);
            this._form.forEach((arg_0, arg_1) -> HttpUtils.lambda$exec$3((FormBody.Builder)fb, arg_0, arg_1));
            this._body = fb.build();
        }
        switch (mothod.toUpperCase()) {
            case "GET": {
                this._builder.method("GET", null);
                break;
            }
            case "POST": {
                this._builder.method("POST", this._body);
                break;
            }
            case "PUT": {
                this._builder.method("PUT", this._body);
                break;
            }
            case "DELETE": {
                this._builder.method("DELETE", this._body);
                break;
            }
            case "PATCH": {
                this._builder.method("PATCH", this._body);
                break;
            }
            case "HEAD": {
                this._builder.method("HEAD", null);
                break;
            }
            case "OPTIONS": {
                this._builder.method("OPTIONS", null);
                break;
            }
            case "TRACE": {
                this._builder.method("TRACE", null);
                break;
            }
            default: {
                throw new IllegalStateException("This method is not supported");
            }
        }
        Call call = this._client.newCall(this._builder.build());
        return call.execute();
    }

    private void tryInitForm() {
        if (this._form == null) {
            this._form = new HashMap<String, String>();
        }
    }

    private static /* synthetic */ void lambda$exec$3(FormBody.Builder fb, String k, String v) {
        fb.add(k, v);
    }
}

